/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.common.entity.util.IRandomTargetGenerator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.Heightmap;

public class FlyingTargetGenerator
implements IRandomTargetGenerator {
    private final CreatureEntity owner;
    private final int minRange;
    private final int maxRange;
    private final int minHeight;
    private final int maxHeight;

    public FlyingTargetGenerator(CreatureEntity owner, int minRange, int maxRange, int minHeight, int maxHeight) {
        this.owner = owner;
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    @Override
    @Nullable
    public BlockPos generate(@Nullable BlockPos anchor) {
        Random random = this.owner.func_70681_au();
        BlockPos result = null;
        float maxWeight = -1.4E-45f;
        for (int i = 0; i < 10; ++i) {
            BlockPos displacedPos;
            BlockPos target;
            float weight;
            int displacementX = this.generateCoordinate(random);
            int displacementZ = this.generateCoordinate(random);
            if (anchor != null) {
                displacementX = this.owner.func_226277_ct_() > (double)anchor.func_177958_n() ? (displacementX -= random.nextInt(this.maxRange / 2)) : (displacementX += random.nextInt(this.maxRange / 2));
                displacementZ = this.owner.func_226281_cx_() > (double)anchor.func_177952_p() ? (displacementZ -= random.nextInt(this.maxRange / 2)) : (displacementZ += random.nextInt(this.maxRange / 2));
            }
            if (!((weight = this.owner.func_180484_a(target = this.generateTarget(random, displacedPos = new BlockPos((double)displacementX + this.owner.func_226277_ct_(), 0.0, (double)displacementZ + this.owner.func_226281_cx_())))) > maxWeight)) continue;
            maxWeight = weight;
            result = target;
        }
        return result;
    }

    private BlockPos generateTarget(Random random, BlockPos displacedPos) {
        int flightHeight = random.nextInt(this.maxHeight - this.minHeight + 1) + this.minHeight;
        BlockPos surface = this.owner.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING, displacedPos);
        return surface.func_177981_b(flightHeight);
    }

    private int generateCoordinate(Random random) {
        return (random.nextBoolean() ? 1 : -1) * (random.nextInt(this.maxRange - this.minRange + 1) + this.minRange);
    }
}

