/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.fluid;

import com.mushroom.midnight.common.fluid.NeighborReactiveFluid;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightFluids;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.registry.MidnightTags;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MiasmaFluid
extends LavaFluid
implements NeighborReactiveFluid {
    private static final ResourceLocation STILL_TEXTURE = new ResourceLocation("midnight", "blocks/miasma_still");
    private static final ResourceLocation FLOW_TEXTURE = new ResourceLocation("midnight", "blocks/miasma_flow");

    public Fluid func_210197_e() {
        return MidnightFluids.FLOWING_MIASMA;
    }

    public Fluid func_210198_f() {
        return MidnightFluids.MIASMA;
    }

    public Item func_204524_b() {
        return MidnightItems.MIASMA_BUCKET;
    }

    public BlockState func_204527_a(IFluidState state) {
        return (BlockState)MidnightBlocks.MIASMA.func_176223_P().func_206870_a((IProperty)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(MiasmaFluid.func_207205_e((IFluidState)state)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World world, BlockPos pos, IFluidState state, Random random) {
        BlockPos abovePos = pos.func_177984_a();
        if (world.func_180495_p(abovePos).func_196958_f() && !world.func_180495_p(abovePos).func_200015_d((IBlockReader)world, abovePos) && random.nextInt(200) == 0) {
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), MidnightSounds.MIASMA_AMBIENT, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
        }
    }

    public boolean func_207187_a(Fluid fluid) {
        return fluid.func_207185_a(MidnightTags.Fluids.MIASMA);
    }

    public int func_205569_a(IWorldReader world) {
        return 20;
    }

    protected void func_205574_a(IWorld world, BlockPos intoPos, BlockState intoBlock, Direction direction, IFluidState fluidState) {
        if (direction == Direction.DOWN) {
            IFluidState intoFluid = world.func_204610_c(intoPos);
            if (intoFluid.func_206884_a(MidnightTags.Fluids.DARK_WATER) || intoFluid.func_206884_a(FluidTags.field_206959_a)) {
                this.mixInto(world, intoPos, MidnightBlocks.NIGHTSTONE.func_176223_P());
                return;
            }
            if (intoFluid.func_206884_a(FluidTags.field_206960_b)) {
                this.mixInto(world, intoPos, MidnightBlocks.MIASMA_SURFACE.func_176223_P());
                return;
            }
        }
        if (intoBlock.func_177230_c() instanceof ILiquidContainer) {
            ((ILiquidContainer)intoBlock.func_177230_c()).func_204509_a(world, intoPos, intoBlock, fluidState);
        } else {
            if (!intoBlock.func_196958_f()) {
                this.func_205580_a(world, intoPos, intoBlock);
            }
            world.func_180501_a(intoPos, fluidState.func_206883_i(), 3);
        }
    }

    @Override
    public boolean reactWithNeighbors(World world, BlockPos pos, BlockState state) {
        boolean nearWater = false;
        for (Direction direction : Direction.values()) {
            IFluidState fluid;
            if (direction == Direction.DOWN || !(fluid = world.func_204610_c(pos.func_177972_a(direction))).func_206884_a(FluidTags.field_206959_a)) continue;
            nearWater = true;
            break;
        }
        if (nearWater) {
            IFluidState fluid = world.func_204610_c(pos);
            if (fluid.func_206889_d()) {
                this.mixInto((IWorld)world, pos, MidnightBlocks.TRENCHSTONE.func_176223_P());
                return false;
            }
            if ((double)fluid.func_215679_a((IBlockReader)world, pos) >= 0.45) {
                this.mixInto((IWorld)world, pos, MidnightBlocks.NIGHTSTONE.func_176223_P());
                return false;
            }
        }
        return true;
    }

    private void mixInto(IWorld world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 3);
        world.func_217379_c(1501, pos, 0);
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)STILL_TEXTURE, (ResourceLocation)FLOW_TEXTURE).density(3000).viscosity(3000).luminosity(15).temperature(400).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L).build((Fluid)this);
    }

    public static class Source
    extends MiasmaFluid {
        public int func_207192_d(IFluidState state) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends MiasmaFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> container) {
            super.func_207184_a(container);
            container.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState state) {
            return (Integer)state.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

