/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mushroom.midnight.common.recipe.MidnightRecipeBookCategories;
import com.mushroom.midnight.common.registry.MidnightRecipeTypes;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.item.BlockItem;
import net.minecraft.item.crafting.IRecipe;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientRecipeBook.class})
public class ClientRecipeBookMixin {
    @Shadow
    @Final
    private Map<RecipeBookCategories, List<RecipeList>> field_197931_e = Maps.newHashMap();
    @Shadow
    @Final
    private List<RecipeList> field_197932_f = Lists.newArrayList();

    @Inject(at={@At(value="HEAD")}, method={"newRecipeList(Lnet/minecraft/client/util/RecipeBookCategories;)Lnet/minecraft/client/gui/recipebook/RecipeList;"}, cancellable=true)
    private void newRecipeList(RecipeBookCategories categories, CallbackInfoReturnable<RecipeList> callback) {
        RecipeList list = ClientRecipeBookMixin.newRecipeList(categories, this.field_197932_f, this.field_197931_e);
        if (list != null) {
            this.field_197932_f.add(list);
            callback.setReturnValue((Object)list);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getCategory(Lnet/minecraft/item/crafting/IRecipe;)Lnet/minecraft/client/util/RecipeBookCategories;"}, cancellable=true)
    private static void getCategory(IRecipe<?> recipe, CallbackInfoReturnable<RecipeBookCategories> callback) {
        RecipeBookCategories category = ClientRecipeBookMixin.getRecipeCategory(recipe);
        if (category != null) {
            callback.setReturnValue((Object)category);
        }
    }

    private static RecipeBookCategories getRecipeCategory(IRecipe<?> recipe) {
        if (recipe.func_222127_g() == MidnightRecipeTypes.SMELTING) {
            if (recipe.func_77571_b().func_77973_b().func_219971_r()) {
                return MidnightRecipeBookCategories.FURNACE_FOOD;
            }
            return recipe.func_77571_b().func_77973_b() instanceof BlockItem ? MidnightRecipeBookCategories.FURNACE_BLOCKS : MidnightRecipeBookCategories.FURNACE_MISC;
        }
        return null;
    }

    private static RecipeList newRecipeList(RecipeBookCategories category, List<RecipeList> allRecipes, Map<RecipeBookCategories, List<RecipeList>> recsByCategory) {
        if (category == MidnightRecipeBookCategories.FURNACE_BLOCKS || category == MidnightRecipeBookCategories.FURNACE_MISC || category == MidnightRecipeBookCategories.FURNACE_FOOD) {
            RecipeList list = new RecipeList();
            allRecipes.add(list);
            recsByCategory.computeIfAbsent(category, cgr -> Lists.newArrayList()).add(list);
            recsByCategory.computeIfAbsent(MidnightRecipeBookCategories.FURNACE_SEARCH, cgr -> Lists.newArrayList()).add(list);
            return list;
        }
        return null;
    }
}

