/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MidnightCookingRecipeSerializer<T extends AbstractCookingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    private final int defaultCookingTime;
    private final IFactory<T> factory;

    public MidnightCookingRecipeSerializer(IFactory<T> factory, int defaultCookingTime) {
        this.defaultCookingTime = defaultCookingTime;
        this.factory = factory;
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        ItemStack itemstack;
        String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray jsonelement = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)jsonelement);
        if (!json.has("result")) {
            throw new JsonSyntaxException("Missing result, expected to find a string or object");
        }
        if (json.get("result").isJsonObject()) {
            itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
        } else {
            String s1 = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            ResourceLocation resourcelocation = new ResourceLocation(s1);
            itemstack = new ItemStack((IItemProvider)Registry.field_212630_s.func_218349_b(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
        }
        float f = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int i = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this.defaultCookingTime);
        return this.factory.create(recipeId, s, ingredient, itemstack, f, i);
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String s = buffer.func_150789_c(Short.MAX_VALUE);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack itemstack = buffer.func_150791_c();
        float f = buffer.readFloat();
        int i = buffer.func_150792_a();
        return this.factory.create(recipeId, s, ingredient, itemstack, f, i);
    }

    public void write(PacketBuffer buffer, T recipe) {
        buffer.func_180714_a(recipe.func_193358_e());
        ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(buffer);
        buffer.func_150788_a(recipe.func_77571_b());
        buffer.writeFloat(recipe.func_222138_b());
        buffer.func_150787_b(recipe.func_222137_e());
    }

    @FunctionalInterface
    public static interface IFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

