/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import com.mushroom.midnight.common.biome.BiomeSpawnEntry;
import com.mushroom.midnight.common.biome.MidnightBiomeGroup;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.biome.cavern.ClosedCavernBiome;
import com.mushroom.midnight.common.biome.cavern.CrystalCavernBiome;
import com.mushroom.midnight.common.biome.cavern.FungalCavernBiome;
import com.mushroom.midnight.common.biome.cavern.GreatCavernBiome;
import com.mushroom.midnight.common.registry.RegUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="midnight", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="midnight")
public class MidnightCavernousBiomes {
    public static final CavernousBiome CLOSED_CAVERN = (CavernousBiome)RegUtil.injected();
    public static final CavernousBiome GREAT_CAVERN = (CavernousBiome)RegUtil.injected();
    public static final CavernousBiome CRYSTAL_CAVERN = (CavernousBiome)RegUtil.injected();
    public static final CavernousBiome FUNGAL_CAVERN = (CavernousBiome)RegUtil.injected();
    private static ForgeRegistry<CavernousBiome> registry;

    @SubscribeEvent
    public static void onNewRegistry(RegistryEvent.NewRegistry event) {
        registry = (ForgeRegistry)new RegistryBuilder().setType(CavernousBiome.class).setName(new ResourceLocation("midnight", "cavernous_biomes")).setDefaultKey(new ResourceLocation("midnight", "closed_cavern")).create();
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<CavernousBiome> event) {
        RegUtil.generic(event.getRegistry()).add("closed_cavern", new ClosedCavernBiome()).add("great_cavern", (ClosedCavernBiome)((Object)new GreatCavernBiome())).add("crystal_cavern", (ClosedCavernBiome)((Object)new CrystalCavernBiome())).add("fungal_cavern", (ClosedCavernBiome)((Object)new FungalCavernBiome()));
    }

    public static void onInit() {
        MidnightBiomeGroup.UNDERGROUND.add(new BiomeSpawnEntry(GREAT_CAVERN, 100));
        MidnightBiomeGroup.UNDERGROUND_POCKET.add(new BiomeSpawnEntry(CRYSTAL_CAVERN, 8).canReplace(GREAT_CAVERN));
    }

    public static ForgeRegistry<CavernousBiome> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }

    public static int getId(CavernousBiome biome) {
        return registry.getID((IForgeRegistryEntry)biome);
    }

    public static CavernousBiome byId(int id) {
        return (CavernousBiome)registry.getValue(id);
    }
}

