/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.entity.CloudEntity;
import com.mushroom.midnight.common.entity.creature.BulbAnglerEntity;
import com.mushroom.midnight.common.entity.creature.CrystalBugEntity;
import com.mushroom.midnight.common.entity.creature.DeceitfulSnapperEntity;
import com.mushroom.midnight.common.entity.creature.HunterEntity;
import com.mushroom.midnight.common.entity.creature.NightStagEntity;
import com.mushroom.midnight.common.entity.creature.NovaEntity;
import com.mushroom.midnight.common.entity.creature.PenumbrianEntity;
import com.mushroom.midnight.common.entity.creature.RifterEntity;
import com.mushroom.midnight.common.entity.creature.ShadeSquirrelEntity;
import com.mushroom.midnight.common.entity.creature.SkulkEntity;
import com.mushroom.midnight.common.entity.creature.StingerEntity;
import com.mushroom.midnight.common.entity.creature.TreeHopperEntity;
import com.mushroom.midnight.common.entity.projectile.BladeshroomCapEntity;
import com.mushroom.midnight.common.entity.projectile.NovaSpikeEntity;
import com.mushroom.midnight.common.entity.projectile.SporeBombEntity;
import com.mushroom.midnight.common.entity.projectile.ThrownGeodeEntity;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="midnight", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="midnight")
public class MidnightEntities {
    public static final EntityType<RifterEntity> RIFTER = EntityType.Builder.func_220322_a(RifterEntity::new, (EntityClassification)Midnight.MIDNIGHT_MOB).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.6f, 1.9f).func_206830_a("midnight:rifter");
    public static final EntityType<HunterEntity> HUNTER = EntityType.Builder.func_220322_a(HunterEntity::new, (EntityClassification)Midnight.MIDNIGHT_MOB).setTrackingRange(80).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true).func_220321_a(1.0f, 1.0f).func_206830_a("midnight:hunter");
    public static final EntityType<BladeshroomCapEntity> BLADESHROOM_CAP = EntityType.Builder.func_220322_a(BladeshroomCapEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(BladeshroomCapEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("midnight:bladeshroom_cap");
    public static final EntityType<NovaEntity> NOVA = EntityType.Builder.func_220322_a(NovaEntity::new, (EntityClassification)Midnight.MIDNIGHT_MOB).setTrackingRange(80).setUpdateInterval(2).setShouldReceiveVelocityUpdates(true).func_220321_a(1.2f, 1.8f).func_220320_c().func_206830_a("midnight:nova");
    public static final EntityType<NovaSpikeEntity> NOVA_SPIKE = EntityType.Builder.func_220322_a(NovaSpikeEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(NovaSpikeEntity::new).func_220321_a(0.4f, 0.4f).func_206830_a("midnight:nova_spike");
    public static final EntityType<CrystalBugEntity> CRYSTAL_BUG = EntityType.Builder.func_220322_a(CrystalBugEntity::new, (EntityClassification)Midnight.MIDNIGHT_AMBIENT).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(false).func_220321_a(0.2f, 0.2f).func_206830_a("midnight:crystal_bug");
    public static final EntityType<PenumbrianEntity> PENUMBRIAN = EntityType.Builder.func_220322_a(PenumbrianEntity::new, (EntityClassification)Midnight.MIDNIGHT_MOB).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f).func_206830_a("midnight:penumbrian");
    public static final EntityType<TreeHopperEntity> TREE_HOPPER = EntityType.Builder.func_220322_a(TreeHopperEntity::new, (EntityClassification)Midnight.MIDNIGHT_MOB).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.5f, 0.5f).func_206830_a("midnight:tree_hopper");
    public static final EntityType<StingerEntity> STINGER = EntityType.Builder.func_220322_a(StingerEntity::new, (EntityClassification)Midnight.MIDNIGHT_MOB).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.2f, 0.2f).func_206830_a("midnight:stinger");
    public static final EntityType<NightStagEntity> NIGHTSTAG = EntityType.Builder.func_220322_a(NightStagEntity::new, (EntityClassification)EntityClassification.CREATURE).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.9f, 1.87f).func_206830_a("midnight:nightstag");
    public static final EntityType<DeceitfulSnapperEntity> DECEITFUL_SNAPPER = EntityType.Builder.func_220322_a(DeceitfulSnapperEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.4f, 0.4f).func_206830_a("midnight:deceitful_snapper");
    public static final EntityType<BulbAnglerEntity> BULB_ANGLER = EntityType.Builder.func_220322_a(BulbAnglerEntity::new, (EntityClassification)EntityClassification.WATER_CREATURE).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.6f, 0.6f).func_206830_a("midnight:bulb_angler");
    public static final EntityType<SkulkEntity> SKULK = EntityType.Builder.func_220322_a(SkulkEntity::new, (EntityClassification)EntityClassification.CREATURE).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.6f, 0.6f).func_206830_a("midnight:skulk");
    public static final EntityType<ShadeSquirrelEntity> SHADE_SQUIRREL = EntityType.Builder.func_220322_a(ShadeSquirrelEntity::new, (EntityClassification)EntityClassification.CREATURE).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(0.6f, 0.75f).func_206830_a("midnight:shade_squirrel");
    public static final EntityType<ThrownGeodeEntity> THROWN_GEODE = EntityType.Builder.func_220322_a(ThrownGeodeEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(ThrownGeodeEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("midnight:thrown_geode");
    public static final EntityType<SporeBombEntity> SPORE_BOMB = EntityType.Builder.func_220322_a(SporeBombEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(64).setUpdateInterval(10).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(SporeBombEntity::new).func_220321_a(0.5f, 0.5f).func_206830_a("midnight:spore_bomb");
    public static final EntityType<CloudEntity> CLOUD = EntityType.Builder.func_220322_a(CloudEntity::new, (EntityClassification)EntityClassification.MISC).setTrackingRange(160).setUpdateInterval(Integer.MAX_VALUE).setShouldReceiveVelocityUpdates(true).setCustomClientFactory(CloudEntity::new).func_220320_c().func_220321_a(6.0f, 0.5f).func_206830_a("midnight:cloud");

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        RIFTER.setRegistryName("midnight", "rifter");
        event.getRegistry().register(RIFTER);
        HUNTER.setRegistryName("midnight", "hunter");
        event.getRegistry().register(HUNTER);
        BLADESHROOM_CAP.setRegistryName("midnight", "bladeshroom_cap");
        event.getRegistry().register(BLADESHROOM_CAP);
        NOVA.setRegistryName("midnight", "nova");
        event.getRegistry().register(NOVA);
        NOVA_SPIKE.setRegistryName("midnight", "nova_spike");
        event.getRegistry().register(NOVA_SPIKE);
        CRYSTAL_BUG.setRegistryName("midnight", "crystal_bug");
        event.getRegistry().register(CRYSTAL_BUG);
        STINGER.setRegistryName("midnight", "stinger");
        event.getRegistry().register(STINGER);
        NIGHTSTAG.setRegistryName("midnight", "nightstag");
        event.getRegistry().register(NIGHTSTAG);
        DECEITFUL_SNAPPER.setRegistryName("midnight", "deceitful_snapper");
        event.getRegistry().register(DECEITFUL_SNAPPER);
        BULB_ANGLER.setRegistryName("midnight", "bulb_angler");
        event.getRegistry().register(BULB_ANGLER);
        SKULK.setRegistryName("midnight", "skulk");
        event.getRegistry().register(SKULK);
        THROWN_GEODE.setRegistryName("midnight", "thrown_geode");
        event.getRegistry().register(THROWN_GEODE);
        SPORE_BOMB.setRegistryName("midnight", "spore_bomb");
        event.getRegistry().register(SPORE_BOMB);
        CLOUD.setRegistryName("midnight", "cloud");
        event.getRegistry().register(CLOUD);
        EntitySpawnPlacementRegistry.func_209343_a(HUNTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::monsterCondition);
        EntitySpawnPlacementRegistry.func_209343_a(CRYSTAL_BUG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::mobCondition);
        EntitySpawnPlacementRegistry.func_209343_a(NOVA, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::monsterCondition);
        EntitySpawnPlacementRegistry.func_209343_a(DECEITFUL_SNAPPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::fishCondition);
        EntitySpawnPlacementRegistry.func_209343_a(BULB_ANGLER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.IN_WATER, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::fishCondition);
        EntitySpawnPlacementRegistry.func_209343_a(RIFTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::monsterCondition);
        EntitySpawnPlacementRegistry.func_209343_a(STINGER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::mobCondition);
        EntitySpawnPlacementRegistry.func_209343_a(SKULK, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::mobCondition);
        EntitySpawnPlacementRegistry.func_209343_a(NIGHTSTAG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MidnightEntities::mobCondition);
    }

    private static boolean fishCondition(EntityType<? extends AbstractFishEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return world.func_180495_p(pos).func_177230_c() == MidnightBlocks.DARK_WATER && (world.func_180495_p(pos.func_177977_b()).func_177230_c() == MidnightBlocks.DARK_WATER || world.func_180495_p(pos.func_177984_a()).func_177230_c() == MidnightBlocks.DARK_WATER);
    }

    private static boolean monsterCondition(EntityType<? extends MonsterEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && MidnightEntities.mobCondition(entityType, world, spawnReason, pos, random);
    }

    private static boolean mobCondition(EntityType<? extends MobEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177977_b();
        return spawnReason == SpawnReason.SPAWNER || world.func_201672_e().func_180495_p(blockpos).func_215688_a((IBlockReader)world, blockpos, entityType);
    }

    private static boolean lightCondition(IWorld world, BlockPos pos, Random random) {
        if (world.func_226658_a_(LightType.SKY, pos) > random.nextInt(32)) {
            return false;
        }
        int i = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return i <= random.nextInt(8);
    }
}

