/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.registry;

import com.mushroom.midnight.common.biome.BiomeSpawnEntry;
import com.mushroom.midnight.common.biome.MidnightBiomeGroup;
import com.mushroom.midnight.common.biome.surface.BlackRidgeBiome;
import com.mushroom.midnight.common.biome.surface.CrystalSpiresBiome;
import com.mushroom.midnight.common.biome.surface.DeceitfulBogBiome;
import com.mushroom.midnight.common.biome.surface.FungiForestBiome;
import com.mushroom.midnight.common.biome.surface.HillyFungiForestBiome;
import com.mushroom.midnight.common.biome.surface.HillyVigilantForestBiome;
import com.mushroom.midnight.common.biome.surface.NightPlainsBiome;
import com.mushroom.midnight.common.biome.surface.ObscuredPeaksBiome;
import com.mushroom.midnight.common.biome.surface.ObscuredPlateauBiome;
import com.mushroom.midnight.common.biome.surface.PhantasmalValleyBiome;
import com.mushroom.midnight.common.biome.surface.RunebushGroveBiome;
import com.mushroom.midnight.common.biome.surface.VigilantForestBiome;
import com.mushroom.midnight.common.biome.surface.WarpedFieldsBiome;
import com.mushroom.midnight.common.registry.MidnightCarvers;
import com.mushroom.midnight.common.registry.MidnightFeatures;
import com.mushroom.midnight.common.registry.MidnightPlacements;
import com.mushroom.midnight.common.registry.MidnightStructures;
import com.mushroom.midnight.common.registry.RegUtil;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="midnight", bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="midnight")
public class MidnightSurfaceBiomes {
    public static final Biome BLACK_RIDGE = Biomes.field_180279_ad;
    public static final Biome VIGILANT_FOREST = Biomes.field_180279_ad;
    public static final Biome DECEITFUL_BOG = Biomes.field_180279_ad;
    public static final Biome FUNGI_FOREST = Biomes.field_180279_ad;
    public static final Biome OBSCURED_PEAKS = Biomes.field_180279_ad;
    public static final Biome WARPED_FIELDS = Biomes.field_180279_ad;
    public static final Biome CRYSTAL_SPIRES = Biomes.field_180279_ad;
    public static final Biome NIGHT_PLAINS = Biomes.field_180279_ad;
    public static final Biome OBSCURED_PLATEAU = Biomes.field_180279_ad;
    public static final Biome PHANTASMAL_VALLEY = Biomes.field_180279_ad;
    public static final Biome RUNEBUSH_GROVE = Biomes.field_180279_ad;
    public static final Biome HILLY_VIGILANT_FOREST = Biomes.field_180279_ad;
    public static final Biome HILLY_FUNGI_FOREST = Biomes.field_180279_ad;

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        MidnightPlacements.registerPlacements(ForgeRegistries.DECORATORS);
        MidnightFeatures.registerFeatures(ForgeRegistries.FEATURES);
        MidnightStructures.registerStructures(ForgeRegistries.FEATURES);
        MidnightCarvers.registerCarvers(ForgeRegistries.WORLD_CARVERS);
        RegUtil.generic(event.getRegistry()).add("vigilant_forest", new VigilantForestBiome()).add("black_ridge", (VigilantForestBiome)((Object)new BlackRidgeBiome())).add("deceitful_bog", (VigilantForestBiome)((Object)new DeceitfulBogBiome())).add("fungi_forest", (VigilantForestBiome)((Object)new FungiForestBiome())).add("obscured_peaks", (VigilantForestBiome)((Object)new ObscuredPeaksBiome())).add("warped_fields", (VigilantForestBiome)((Object)new WarpedFieldsBiome())).add("crystal_spires", (VigilantForestBiome)((Object)new CrystalSpiresBiome())).add("night_plains", (VigilantForestBiome)((Object)new NightPlainsBiome())).add("obscured_plateau", (VigilantForestBiome)((Object)new ObscuredPlateauBiome())).add("phantasmal_valley", (VigilantForestBiome)((Object)new PhantasmalValleyBiome())).add("runebush_grove", (VigilantForestBiome)((Object)new RunebushGroveBiome())).add("hilly_vigilant_forest", (VigilantForestBiome)((Object)new HillyVigilantForestBiome())).add("hilly_fungi_forest", (VigilantForestBiome)((Object)new HillyFungiForestBiome()));
    }

    public static void onInit() {
        BiomeDictionary.addTypes((Biome)VIGILANT_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)RUNEBUSH_GROVE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)BLACK_RIDGE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)FUNGI_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)OBSCURED_PEAKS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)WARPED_FIELDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)CRYSTAL_SPIRES, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes((Biome)DECEITFUL_BOG, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)NIGHT_PLAINS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)OBSCURED_PLATEAU, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)PHANTASMAL_VALLEY, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)HILLY_VIGILANT_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes((Biome)HILLY_FUNGI_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPOOKY});
        MidnightBiomeGroup.SURFACE.add(new BiomeSpawnEntry(VIGILANT_FOREST, 100), new BiomeSpawnEntry(FUNGI_FOREST, 70), new BiomeSpawnEntry(DECEITFUL_BOG, 50), new BiomeSpawnEntry(OBSCURED_PLATEAU, 50), new BiomeSpawnEntry(NIGHT_PLAINS, 100), new BiomeSpawnEntry(WARPED_FIELDS, 35));
        MidnightBiomeGroup.SURFACE_HILLS.add(new BiomeSpawnEntry(HILLY_VIGILANT_FOREST, 5).canReplace(VIGILANT_FOREST), new BiomeSpawnEntry(HILLY_FUNGI_FOREST, 5).canReplace(FUNGI_FOREST), new BiomeSpawnEntry(OBSCURED_PEAKS, 5).canReplace(OBSCURED_PLATEAU, BLACK_RIDGE));
        MidnightBiomeGroup.SURFACE_POCKET.add(new BiomeSpawnEntry(CRYSTAL_SPIRES, 80), new BiomeSpawnEntry(RUNEBUSH_GROVE, 50).canReplace(VIGILANT_FOREST));
    }

    public static Stream<Biome> allBiomes() {
        return ForgeRegistries.BIOMES.getEntries().stream().filter(entry -> ((ResourceLocation)entry.getKey()).func_110624_b().equals("midnight")).map(Map.Entry::getValue);
    }
}

