/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import com.google.common.base.Preconditions;
import com.mushroom.midnight.common.registry.MidnightDimensions;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public final class MidnightUtil {
    public static ResourceLocation transformPath(ResourceLocation identifier, Function<String, String> function) {
        Preconditions.checkNotNull((Object)identifier);
        return new ResourceLocation(identifier.func_110624_b(), function.apply(identifier.func_110623_a()));
    }

    public static boolean isMidnightDimension(@Nullable World world) {
        if (world == null) {
            return false;
        }
        return world.field_73011_w.func_186058_p().getModType() == MidnightDimensions.MIDNIGHT;
    }

    public static boolean isNotFakePlayer(@Nullable Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public static float[] getRGBColorF(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static ItemEntity spawnItemStack(World world, BlockPos pos, Block block) {
        return MidnightUtil.spawnItemStack(world, pos, block.func_199767_j());
    }

    public static ItemEntity spawnItemStack(World world, BlockPos pos, Item item) {
        return MidnightUtil.spawnItemStack(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, item);
    }

    public static ItemEntity spawnItemStack(World world, double x, double y, double z, Item item) {
        return MidnightUtil.spawnItemStack(world, x, y, z, new ItemStack((IItemProvider)item, 1));
    }

    public static ItemEntity spawnItemStack(World world, BlockPos pos, ItemStack stack) {
        return MidnightUtil.spawnItemStack(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack);
    }

    public static ItemEntity spawnItemStack(World world, double x, double y, double z, ItemStack stack) {
        ItemEntity itemEntity = new ItemEntity(world, x, y, z, stack);
        world.func_217376_c((Entity)itemEntity);
        return itemEntity;
    }

    public static Vec3d lerp(Vec3d a, Vec3d b, double alpha) {
        if (alpha <= 0.0) {
            return a;
        }
        if (alpha >= 1.0) {
            return b;
        }
        return new Vec3d(a.field_72450_a + (b.field_72450_a - a.field_72450_a) * alpha, a.field_72448_b + (b.field_72448_b - a.field_72448_b) * alpha, a.field_72449_c + (b.field_72449_c - a.field_72449_c) * alpha);
    }
}

