/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.google.common.collect.Iterables;
import com.mushroom.midnight.common.biome.BiomeLayers;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.world.MidnightBiomeProvider;
import com.mushroom.midnight.common.world.MidnightNoiseGenerator;
import com.mushroom.midnight.common.world.feature.placement.UndergroundPlacementLevel;
import com.mushroom.midnight.common.world.util.NoiseChunkPrimer;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.INoiseGenerator;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.PerlinNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.server.ServerWorld;

public class MidnightChunkGenerator
extends NoiseChunkGenerator<Config> {
    public static final int SURFACE_LEVEL = 78;
    public static final int MIN_CAVE_HEIGHT = 20;
    public static final int MAX_CAVE_HEIGHT = 46;
    public static final int SURFACE_CAVE_BOUNDARY = 58;
    public static final int SEA_LEVEL = 80;
    private final World world;
    private final MidnightNoiseGenerator noiseGenerator;
    private final NoiseChunkPrimer noisePrimer;
    private final BiomeLayers<Biome> surfaceLayers;
    private final BiomeLayers<CavernousBiome> undergroundLayers;
    private final INoiseGenerator surfaceDepthNoise;

    public MidnightChunkGenerator(World world, BiomeLayers<Biome> surfaceLayers, BiomeLayers<CavernousBiome> undergroundLayers, Config config) {
        super((IWorld)world, (BiomeProvider)new MidnightBiomeProvider(surfaceLayers), 4, 4, 256, (GenerationSettings)config, true);
        this.world = world;
        this.noiseGenerator = new MidnightNoiseGenerator((Random)this.field_222558_e);
        this.noisePrimer = new NoiseChunkPrimer(4, 4, 4, 64);
        this.surfaceLayers = surfaceLayers;
        this.undergroundLayers = undergroundLayers;
        this.surfaceDepthNoise = new PerlinNoiseGenerator(this.field_222558_e, 4, 0);
    }

    public void func_222537_b(IWorld world, IChunk chunk) {
        double[] noise = this.noiseGenerator.sampleChunkNoise(chunk.func_76632_l(), this.surfaceLayers, this.undergroundLayers);
        this.noisePrimer.primeChunk((ChunkPrimer)chunk, noise, (density, x, y, z) -> {
            if (density > 0.0) {
                return this.field_222559_f;
            }
            if (y < 80 && y > 58) {
                return this.field_222560_g;
            }
            return null;
        });
    }

    public void func_225551_a_(WorldGenRegion worldGenRegion, IChunk chunk) {
        long seed = this.world.func_72905_C();
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        SharedSeedRandom random = new SharedSeedRandom();
        random.func_202422_a(chunkX, chunkZ);
        int minChunkX = chunkPos.func_180334_c();
        int minChunkZ = chunkPos.func_180333_d();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int localX = 0; localX < 16; ++localX) {
            for (int localZ = 0; localZ < 16; ++localZ) {
                int globalX = minChunkX + localX;
                int globalZ = minChunkZ + localZ;
                int i2 = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, localX, localZ) + 1;
                Biome surfaceBiome = this.getSurfaceBiome(globalX, globalZ);
                CavernousBiome cavernousBiome = this.getCavernousBiome(globalX, globalZ);
                int height = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, localX, localZ) + 1;
                double depth = this.surfaceDepthNoise.func_215460_a((double)globalX * 0.0625, (double)globalZ * 0.0625, 0.0625, (double)localX * 0.0625);
                surfaceBiome.func_206854_a((Random)random, chunk, globalX, globalZ, height, depth, this.field_222559_f, this.field_222560_g, 80, seed);
                cavernousBiome.generateSurface(random, chunk, globalX, globalZ, height, depth, this.field_222559_f, this.field_222560_g, 80, seed);
            }
        }
        this.func_222555_a(chunk, (Random)random);
    }

    protected void func_222555_a(IChunk chunkIn, Random rand) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int x = chunkIn.func_76632_l().func_180334_c();
        int z = chunkIn.func_76632_l().func_180333_d();
        for (BlockPos pos : BlockPos.func_191531_b((int)x, (int)0, (int)z, (int)(x + 15), (int)0, (int)(z + 15))) {
            for (int y = 0; y < 5; ++y) {
                if (y > rand.nextInt(5)) continue;
                chunkIn.func_177436_a((BlockPos)mutable.func_181079_c(pos.func_177958_n(), y, pos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    public void func_225550_a_(BiomeManager biomeManagerIn, IChunk chunk, GenerationStage.Carving stage) {
        ChunkPos chunkpos = chunk.func_76632_l();
        Biome biome = this.func_225552_a_(biomeManagerIn, chunkpos.func_206849_h());
        List surfaceCarvers = biome.func_203603_a(stage);
        Collection<ConfiguredCarver<?>> undergroundCarvers = this.getCavernousBiome(chunk).getCarversFor(stage);
        this.applyCarvers(biomeManagerIn, chunk, stage, Iterables.concat((Iterable)surfaceCarvers, undergroundCarvers));
    }

    private void applyCarvers(BiomeManager biomeManager, IChunk chunk, GenerationStage.Carving stage, Iterable<ConfiguredCarver<?>> carvers) {
        ChunkPos chunkPos = chunk.func_76632_l();
        int chunkX = chunkPos.field_77276_a;
        int chunkZ = chunkPos.field_77275_b;
        SharedSeedRandom random = new SharedSeedRandom();
        BitSet mask = chunk.func_205749_a(stage);
        for (int nz = chunkZ - 8; nz <= chunkZ + 8; ++nz) {
            for (int nx = chunkX - 8; nx <= chunkX + 8; ++nx) {
                int i = 0;
                for (ConfiguredCarver<?> carver : carvers) {
                    random.func_202425_c(this.field_222541_b + (long)i, nx, nz);
                    if (carver.func_222730_a((Random)random, nx, nz)) {
                        carver.func_227207_a_(chunk, p_227059_2_ -> this.func_225552_a_(biomeManager, (BlockPos)p_227059_2_), (Random)random, this.func_222530_f(), nx, nz, chunkX, chunkZ, mask);
                    }
                    ++i;
                }
            }
        }
    }

    public void func_202092_b(WorldGenRegion world) {
        super.func_202092_b(world);
        int chunkX = world.func_201679_a();
        int chunkZ = world.func_201680_b();
        int minX = chunkX * 16;
        int minZ = chunkZ * 16;
        BlockPos origin = new BlockPos(minX, 0, minZ);
        CavernousBiome cavernousBiome = this.getCavernousBiome(origin.func_177958_n() + 8, origin.func_177952_p() + 8);
        SharedSeedRandom random = new SharedSeedRandom();
        long seed = random.func_202424_a(world.func_72905_C(), minX, minZ);
        for (GenerationStage.Decoration stage : GenerationStage.Decoration.values()) {
            cavernousBiome.placeFeatures(stage, this, world, seed, random, origin);
        }
    }

    public void func_202093_c(WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        SharedSeedRandom random = new SharedSeedRandom();
        random.func_202424_a(region.func_72905_C(), chunkX << 4, chunkZ << 4);
    }

    public void func_203222_a(ServerWorld world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        if (this.world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            // empty if block
        }
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification classification, BlockPos pos) {
        if (UndergroundPlacementLevel.INSTANCE.containsY((IWorld)this.world, pos.func_177956_o())) {
            CavernousBiome biome = this.getCavernousBiome(pos.func_177958_n(), pos.func_177952_p());
            return biome.getSpawnsFor(classification);
        }
        return super.func_177458_a(classification, pos);
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        throw new UnsupportedOperationException();
    }

    protected void func_222548_a(double[] noise, int x, int z) {
        this.noiseGenerator.populateColumnNoise(noise, x, z, this.surfaceLayers, this.undergroundLayers);
    }

    protected double func_222545_a(double x, double z, int i) {
        throw new UnsupportedOperationException();
    }

    public int func_205470_d() {
        return this.world.func_181545_F() + 1;
    }

    public int func_222530_f() {
        return 80;
    }

    protected CavernousBiome getCavernousBiome(IChunk chunk) {
        ChunkPos pos = chunk.func_76632_l();
        return (CavernousBiome)this.undergroundLayers.block.sample(pos.func_180334_c(), pos.func_180333_d());
    }

    protected CavernousBiome getCavernousBiome(int x, int z) {
        return (CavernousBiome)this.undergroundLayers.block.sample(x, z);
    }

    protected Biome getSurfaceBiome(int x, int z) {
        return (Biome)this.surfaceLayers.block.sample(x, z);
    }

    public static class Config
    extends GenerationSettings {
        public static Config createDefault() {
            Config config = new Config();
            config.func_214969_a(MidnightBlocks.NIGHTSTONE.func_176223_P());
            config.func_214970_b(MidnightBlocks.DARK_WATER.func_176223_P());
            return config;
        }
    }
}

