/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.client.render.MidnightSkyRenderer;
import com.mushroom.midnight.common.biome.BiomeLayerType;
import com.mushroom.midnight.common.biome.BiomeLayers;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.world.MidnightAtmosphereController;
import com.mushroom.midnight.common.world.MidnightChunkGenerator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.extensions.IForgeDimension;

public class MidnightDimension
extends Dimension {
    public MidnightDimension(World world, DimensionType type) {
        super(world, type, 0.0f);
        float baseLight = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float alpha = 1.0f - (float)i / 14.0f;
            float brightness = (1.0f - alpha) / (alpha * 10.0f + 1.0f);
            this.field_76573_f[i] = (float)(Math.pow(brightness, 2.5) * 3.0) + baseLight;
        }
    }

    public ChunkGenerator<?> func_186060_c() {
        long seed = this.field_76579_a.func_72905_C();
        BiomeLayers<Biome> surfaceLayers = BiomeLayerType.SURFACE.make(seed);
        BiomeLayers<CavernousBiome> undergroundLayers = BiomeLayerType.UNDERGROUND.make(seed);
        return new MidnightChunkGenerator(this.field_76579_a, surfaceLayers, undergroundLayers, MidnightChunkGenerator.Config.createDefault());
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos chunk, boolean checkValid) {
        return null;
    }

    @Nullable
    public BlockPos func_206921_a(int posX, int posZ, boolean checkValid) {
        return null;
    }

    public int getActualHeight() {
        return 256;
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return IForgeDimension.SleepResult.BED_EXPLODES;
    }

    public boolean func_76569_d() {
        return false;
    }

    public boolean shouldMapSpin(String entity, double x, double z, double rotation) {
        return true;
    }

    public float func_227174_a_(int p_227174_1_) {
        return super.func_227174_a_(p_227174_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void getLightmapColors(float partialTicks, float sunBrightness, float skyLight, float blockLight, Vector3f colors) {
        float colors0 = blockLight * 0.93f + 0.07f;
        float colors1 = blockLight * 0.96f + 0.03f;
        float colors2 = blockLight * 0.94f + 0.16f;
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_228332_n_() > 0) {
            float undergroundFactor = (float)MidnightAtmosphereController.INSTANCE.getUndergroundFactor();
            colors0 = MathHelper.func_219799_g((float)undergroundFactor, (float)0.95f, (float)colors0);
            colors1 = MathHelper.func_219799_g((float)undergroundFactor, (float)0.3f, (float)colors1);
            colors2 = MathHelper.func_219799_g((float)undergroundFactor, (float)0.3f, (float)colors2);
        }
        colors.func_195905_a(colors0 + colors.func_195899_a() * 4.0f, colors1 + colors.func_195900_b() * 4.0f, colors2 + colors.func_195902_c() * 4.0f);
    }

    public boolean isDaytime() {
        return false;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return MidnightAtmosphereController.INSTANCE.computeSkyColor();
    }

    public Vec3d getSkyColor(BlockPos cameraPos, float partialTicks) {
        return MidnightAtmosphereController.INSTANCE.computeSkyColor();
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        return 0.5f;
    }

    public void calculateInitialWeather() {
    }

    public void updateWeather(Runnable defaultLogic) {
        if (this.field_76579_a instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)this.field_76579_a;
            ServerChunkProvider chunkProvider = serverWorld.func_72863_F();
            if (((Boolean)MidnightConfig.logic.randomLightnings.get()).booleanValue()) {
                chunkProvider.field_217237_a.func_223491_f().forEach(chunkHolder -> chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left().ifPresent(chunk -> {
                    Random rand = this.field_76579_a.field_73012_v;
                    ChunkPos chunkPos = chunkHolder.func_219277_h();
                    if (!chunkProvider.field_217237_a.func_219243_d(chunkPos)) {
                        int globalX = chunkPos.func_180334_c();
                        int globalZ = chunkPos.func_180333_d();
                        if (rand.nextInt(200000) == 0) {
                            int lightningX = globalX + rand.nextInt(16);
                            int lightningZ = globalZ + rand.nextInt(16);
                            BlockPos pos = this.field_76579_a.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(lightningX, 0, lightningZ));
                            LightningBoltEntity lightning = new LightningBoltEntity(this.field_76579_a, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (Boolean)MidnightConfig.logic.allowLightningDamage.get() == false);
                            serverWorld.func_217468_a(lightning);
                        }
                    }
                }));
            }
        }
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean func_76567_e() {
        return (Boolean)MidnightConfig.logic.canRespawnInMidnight.get();
    }

    public boolean func_76568_b(int x, int z) {
        return false;
    }

    public double func_76565_k() {
        return 1.0;
    }

    @Nullable
    public IRenderHandler getSkyRenderer() {
        return MidnightSkyRenderer.INSTANCE;
    }
}

