/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.biome.BiomeLayers;
import com.mushroom.midnight.common.biome.cavern.CavernousBiome;
import com.mushroom.midnight.common.biome.surface.SurfaceBiome;
import com.mushroom.midnight.common.util.Curve;
import com.mushroom.midnight.common.util.RegionInterpolator;
import com.mushroom.midnight.common.world.noise.OctaveNoiseSampler;
import com.mushroom.midnight.common.world.noise.PerlinNoiseSampler;
import com.mushroom.midnight.common.world.util.BiomeWeightTable;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;

public class MidnightNoiseGenerator {
    private static final BiomeProperties BIOME_PROPERTIES = new BiomeProperties();
    public static final int HORIZONTAL_GRANULARITY = 4;
    public static final int VERTICAL_GRANULARITY = 4;
    public static final int NOISE_WIDTH = 4;
    public static final int NOISE_HEIGHT = 64;
    private static final int BUFFER_WIDTH = 5;
    private static final int BUFFER_HEIGHT = 65;
    private static final int BIOME_WEIGHT_RADIUS = 2;
    private static final int NOISE_SURFACE_CAVE_BOUNDARY = 14;
    private final OctaveNoiseSampler worldNoise;
    private final OctaveNoiseSampler surfaceNoise;
    private final OctaveNoiseSampler ceilingNoise;
    private final OctaveNoiseSampler ridgedSurfaceNoise;
    private final PerlinNoiseSampler pillarNoise;
    private final BiomeWeightTable weightTable;

    public MidnightNoiseGenerator(Random random) {
        this.worldNoise = OctaveNoiseSampler.perlin(random, 3);
        this.worldNoise.setAmplitude(5.0);
        this.worldNoise.setFrequency(0.1);
        this.surfaceNoise = OctaveNoiseSampler.perlin(random, 8);
        this.surfaceNoise.setAmplitude(3.0);
        this.surfaceNoise.setFrequency(0.04);
        this.ceilingNoise = OctaveNoiseSampler.perlin(random, 6);
        this.ceilingNoise.setAmplitude(3.0);
        this.ceilingNoise.setFrequency(0.04);
        this.pillarNoise = new PerlinNoiseSampler(random);
        this.pillarNoise.setFrequency(0.2);
        this.ridgedSurfaceNoise = OctaveNoiseSampler.ridged(random, 3, 4.0);
        this.ridgedSurfaceNoise.setAmplitude(4.0);
        this.ridgedSurfaceNoise.setFrequency(0.08);
        this.weightTable = new BiomeWeightTable(2);
    }

    public double[] sampleChunkNoise(ChunkPos chunkPos, BiomeLayers<Biome> surfaceLayers, BiomeLayers<CavernousBiome> undergroundLayers) {
        int globalX = chunkPos.field_77276_a * 4;
        int globalZ = chunkPos.field_77275_b * 4;
        double[] noise = new double[1625];
        double[] column = new double[65];
        int index = 0;
        for (int localZ = 0; localZ < 5; ++localZ) {
            for (int localX = 0; localX < 5; ++localX) {
                this.populateColumnNoise(column, globalX + localX, globalZ + localZ, surfaceLayers, undergroundLayers);
                System.arraycopy(column, 0, noise, index, column.length);
                index += 65;
            }
        }
        return noise;
    }

    public void populateColumnNoise(double[] noise, int x, int z, BiomeLayers<Biome> surfaceLayers, BiomeLayers<CavernousBiome> undergroundLayers) {
        BiomeProperties properties = this.computeBiomeProperties(surfaceLayers, undergroundLayers, x, z);
        float heightOrigin = 19.5f;
        float maxHeight = 64.0f;
        float minCaveHeight = 5.0f;
        float maxCaveHeight = 11.5f;
        float caveHeightRange = maxCaveHeight - minCaveHeight;
        float baseHeight = properties.heightDepth + heightOrigin;
        float cavernFloorHeight = properties.cavernFloorHeight * caveHeightRange + minCaveHeight;
        float cavernCeilingHeight = properties.cavernCeilingHeight * caveHeightRange + minCaveHeight;
        double cavernCenter = (double)(cavernFloorHeight + cavernCeilingHeight) / 2.0;
        double cavernHeight = cavernCeilingHeight - cavernFloorHeight;
        float heightVariation = properties.heightScale * 0.9f + 0.1f;
        float cavernHeightVariation = properties.cavernHeightScale * 0.9f + 0.1f;
        double perlinSurfaceNoise = (this.surfaceNoise.get(x, z) + 1.5) / 3.0;
        double perlinCeilingNoise = (this.ceilingNoise.get(x, z) + 1.5) / 3.0;
        double ridgedSurfaceNoise = (this.ridgedSurfaceNoise.get(x, z) + 1.5) / 3.0;
        double pillarDensity = Math.pow((this.pillarNoise.get(x, z) + 1.0) * 0.5, 4.0);
        double surfaceHeightVariationScale = Math.pow((double)heightVariation * 2.0, 3.0);
        double cavernHeightVariationScale = Math.pow((double)cavernHeightVariation * 2.0, 3.0);
        double surfaceHeight = perlinSurfaceNoise + (ridgedSurfaceNoise - perlinSurfaceNoise) * (double)properties.ridgeWeight;
        surfaceHeight = surfaceHeight * (double)heightVariation * 2.0 + (double)baseHeight;
        double cavernRegionStart = (double)cavernFloorHeight + perlinSurfaceNoise * (double)cavernHeightVariation * 2.0;
        double cavernRegionEnd = (double)cavernCeilingHeight + perlinCeilingNoise * 0.15;
        double curveRange = 2.0;
        RegionInterpolator.Region[] regions = new RegionInterpolator.Region[]{RegionInterpolator.region(0.0, cavernRegionStart, 2.5, curveRange), RegionInterpolator.region(cavernRegionStart, cavernRegionEnd, properties.cavernDensity, curveRange), RegionInterpolator.region(cavernRegionEnd, surfaceHeight, 3.5, curveRange), RegionInterpolator.region(surfaceHeight, maxHeight, surfaceHeight - (double)maxHeight, (double)maxHeight - surfaceHeight)};
        RegionInterpolator interpolator = new RegionInterpolator(regions, Curve.linear());
        for (int y = 0; y < 65; ++y) {
            if (y == 14) {
                noise[y] = 5.0;
                continue;
            }
            double surfaceWeight = MathHelper.func_151237_a((double)(((double)y - cavernRegionEnd) / (surfaceHeight - cavernRegionEnd)), (double)0.0, (double)1.0);
            double cavernWeight = 1.0 - surfaceWeight;
            double densityBias = interpolator.get(y);
            double cavernCenterDistance = Math.min(Math.abs((double)y - cavernCenter) / cavernHeight, 1.0);
            double pillarFalloff = Math.max(1.0 - Math.pow(cavernCenterDistance, 2.0), 0.0) * 0.125;
            double sampledNoise = this.worldNoise.get(x, y, z);
            double surfaceNoiseDensity = sampledNoise * surfaceHeightVariationScale;
            double cavernNoiseDensity = sampledNoise * cavernHeightVariationScale;
            double noiseDensity = surfaceNoiseDensity * surfaceWeight + cavernNoiseDensity * cavernWeight;
            noise[y] = noiseDensity + (densityBias += Math.max(pillarDensity * 3.5 - pillarFalloff, 0.0) * cavernWeight * 5.0 * (double)properties.pillarWeight);
        }
    }

    private BiomeProperties computeBiomeProperties(BiomeLayers<Biome> surfaceLayers, BiomeLayers<CavernousBiome> undergroundLayers, int x, int z) {
        BiomeProperties properties = BIOME_PROPERTIES;
        properties.zero();
        float totalWeight = 0.0f;
        Biome originBiome = (Biome)surfaceLayers.noise.sample(x, z);
        for (int neighborZ = -2; neighborZ <= 2; ++neighborZ) {
            for (int neighborX = -2; neighborX <= 2; ++neighborX) {
                Biome neighborBiome = (Biome)surfaceLayers.noise.sample(x + neighborX, z + neighborZ);
                CavernousBiome neighborCavernBiome = (CavernousBiome)undergroundLayers.noise.sample(x + neighborX, z + neighborZ);
                float nDepth = neighborBiome.func_185355_j();
                float nScale = neighborBiome.func_185360_m();
                float nRidgeWeight = 0.0f;
                float nDensityScale = 1.0f;
                if (neighborBiome instanceof SurfaceBiome) {
                    SurfaceBiome surfaceBiome = (SurfaceBiome)neighborBiome;
                    nRidgeWeight = surfaceBiome.getRidgeWeight();
                    nDensityScale = surfaceBiome.getDensityScale();
                }
                float nCavernFloorHeight = neighborCavernBiome.getFloorHeight();
                float nCavernCeilingHeight = neighborCavernBiome.getCeilingHeight();
                float nCavernDensity = neighborCavernBiome.getCavernDensity();
                float nCavernHeightScale = neighborCavernBiome.getHeightScale();
                float nCavernPillarWeight = neighborCavernBiome.getPillarWeight();
                float biomeWeight = this.weightTable.get(neighborX, neighborZ) / (nDepth + 2.0f);
                if (neighborBiome.func_185355_j() > originBiome.func_185355_j()) {
                    biomeWeight *= 2.0f;
                }
                properties.heightScale += nScale * biomeWeight;
                properties.heightDepth += nDepth * biomeWeight;
                properties.ridgeWeight += nRidgeWeight * biomeWeight;
                properties.densityScale += nDensityScale * biomeWeight;
                properties.cavernFloorHeight += nCavernFloorHeight * biomeWeight;
                properties.cavernCeilingHeight += nCavernCeilingHeight * biomeWeight;
                properties.cavernDensity += nCavernDensity * biomeWeight;
                properties.cavernHeightScale += nCavernHeightScale * biomeWeight;
                properties.pillarWeight += nCavernPillarWeight * biomeWeight;
                totalWeight += biomeWeight;
            }
        }
        properties.normalize(totalWeight);
        return properties;
    }

    private static class BiomeProperties {
        float heightScale;
        float heightDepth;
        float densityScale;
        float ridgeWeight;
        float cavernFloorHeight;
        float cavernCeilingHeight;
        float cavernDensity;
        float cavernHeightScale;
        float pillarWeight;

        private BiomeProperties() {
        }

        void zero() {
            this.heightScale = 0.0f;
            this.heightDepth = 0.0f;
            this.ridgeWeight = 0.0f;
            this.densityScale = 0.0f;
            this.cavernFloorHeight = 0.0f;
            this.cavernCeilingHeight = 0.0f;
            this.cavernDensity = 0.0f;
            this.cavernHeightScale = 0.0f;
            this.pillarWeight = 0.0f;
        }

        void normalize(float weight) {
            this.heightScale /= weight;
            this.heightDepth /= weight;
            this.ridgeWeight /= weight;
            this.densityScale /= weight;
            this.cavernFloorHeight /= weight;
            this.cavernCeilingHeight /= weight;
            this.cavernDensity /= weight;
            this.cavernHeightScale /= weight;
            this.pillarWeight /= weight;
        }
    }
}

