/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.util.WorldUtil;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FallenDeadLogFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final BlockState LOG = MidnightBlocks.DEAD_WOOD_LOG.func_176223_P();

    public FallenDeadLogFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize) {
        super(deserialize);
    }

    private static boolean canBeReplaced(IWorld world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.canBeReplacedByLogs((IWorldReader)world, pos));
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos origin, NoFeatureConfig config) {
        BlockPos endPos;
        Direction direction = HORIZONTALS[rand.nextInt(HORIZONTALS.length)];
        Direction.Axis axis = direction.func_176740_k() == Direction.Axis.X ? Direction.Axis.X : Direction.Axis.Z;
        Direction.Axis perpendicular = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        int length = rand.nextInt(4) + 3;
        int halfLength = length / 2;
        BlockPos basePos = origin.func_177967_a(direction, -halfLength);
        if (!this.checkValid(world, basePos, endPos = origin.func_177967_a(direction, length - halfLength))) {
            return false;
        }
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)basePos, (BlockPos)endPos)) {
            this.func_202278_a((IWorldWriter)world, pos, (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)axis));
        }
        int extrusionCount = rand.nextInt(3);
        for (int i = 0; i < extrusionCount; ++i) {
            BlockPos intermediate = basePos.func_177967_a(direction, rand.nextInt(length));
            Direction side = rand.nextBoolean() ? direction.func_176746_e() : direction.func_176735_f();
            this.func_202278_a((IWorldWriter)world, intermediate.func_177972_a(side), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)perpendicular));
        }
        return true;
    }

    private boolean checkValid(IWorld world, BlockPos basePos, BlockPos endPos) {
        BlockPos minPos = WorldUtil.min(basePos, endPos).func_177982_a(-1, 0, -1);
        BlockPos maxPos = WorldUtil.max(basePos, endPos).func_177982_a(1, 1, 1);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)minPos, (BlockPos)maxPos)) {
            if (FallenDeadLogFeature.canBeReplaced(world, pos)) continue;
            return false;
        }
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)basePos, (BlockPos)endPos)) {
            BlockPos.Mutable mutablePos = (BlockPos.Mutable)pos;
            mutablePos.func_189536_c(Direction.DOWN);
            BlockState groundState = world.func_180495_p((BlockPos)mutablePos);
            if (groundState.func_200132_m()) continue;
            return false;
        }
        return true;
    }
}

