/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.tree;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.util.WorldUtil;
import com.mushroom.midnight.common.world.feature.tree.MidnightTreeFeature;
import com.mushroom.midnight.common.world.template.CompiledTemplate;
import com.mushroom.midnight.common.world.template.ExtendRootsProcessor;
import com.mushroom.midnight.common.world.template.RootsAttachProcessor;
import com.mushroom.midnight.common.world.template.RotatedSettingConfigurator;
import com.mushroom.midnight.common.world.template.ShelfAttachProcessor;
import com.mushroom.midnight.common.world.template.TemplateCompiler;
import com.mushroom.midnight.common.world.template.TemplateMarkers;
import java.util.Collection;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.common.IPlantable;

public abstract class TemplateFungiFeature
extends MidnightTreeFeature {
    private static final int MAX_DEPTH = 3;
    private static final String ANCHOR_MARKER = "origin";
    private static final String TRUNK_TOP_MARKER = "trunk_top";
    private static final String TRUNK_CORNER_MARKER = "trunk_corner";
    protected final ResourceLocation[] templates;
    protected final BlockState stem;
    protected final BlockState hat;
    protected final BlockState[] roots;
    private TemplateCompiler templateCompiler;

    protected TemplateFungiFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize, ResourceLocation[] templates, BlockState stem, BlockState hat, BlockState[] roots) {
        super(deserialize);
        this.templates = templates;
        this.stem = stem;
        this.hat = hat;
        this.roots = roots;
        this.setSapling((IPlantable)MidnightBlocks.NIGHTSHROOM);
    }

    protected TemplateCompiler buildCompiler() {
        TemplateCompiler compiler = TemplateCompiler.of(this.templates).withAnchor(ANCHOR_MARKER).withSettingConfigurator(RotatedSettingConfigurator.INSTANCE).withProcessor(this::processState).withPostProcessor(new ExtendRootsProcessor(this.stem)).withPostProcessor(new ShelfAttachProcessor(this::canPlaceShelf, ShelfAttachProcessor.FOREST_SHELF_BLOCKS));
        if (this.roots.length > 0) {
            compiler = compiler.withPostProcessor(new RootsAttachProcessor(6, this.roots));
        }
        return compiler;
    }

    @Override
    protected boolean place(IWorld world, Random random, BlockPos origin) {
        if (!TemplateFungiFeature.isSoil((IWorldGenerationBaseReader)world, origin.func_177977_b(), this.getSapling())) {
            return false;
        }
        if (this.templateCompiler == null) {
            this.templateCompiler = this.buildCompiler();
        }
        CompiledTemplate template = this.templateCompiler.compile(world, random, origin);
        TemplateMarkers markers = template.markers;
        BlockPos anchor = markers.lookupAny(ANCHOR_MARKER);
        if (anchor == null) {
            anchor = origin;
        }
        BlockPos trunkTop = markers.lookupAny(TRUNK_TOP_MARKER);
        Collection<BlockPos> trunkCorners = markers.lookup(TRUNK_CORNER_MARKER);
        if (trunkTop == null || trunkCorners.isEmpty()) {
            Midnight.LOGGER.warn("Template '{}' did not have required '{}' and '{}' data blocks", (Object)template, (Object)TRUNK_TOP_MARKER, (Object)TRUNK_CORNER_MARKER);
            return false;
        }
        BlockPos minCorner = WorldUtil.min(trunkCorners);
        BlockPos maxCorner = WorldUtil.max(trunkCorners);
        if (!this.canGrow(world, minCorner = new BlockPos(minCorner.func_177958_n() + 1, anchor.func_177956_o(), minCorner.func_177952_p() + 1), maxCorner = new BlockPos(maxCorner.func_177958_n() - 1, anchor.func_177956_o(), maxCorner.func_177952_p() - 1)) || !this.canFit(world, trunkTop, minCorner, maxCorner)) {
            return false;
        }
        this.setDirtAt((IWorldGenerationReader)world, origin.func_177977_b(), origin);
        template.addTo(world, random, 18);
        return true;
    }

    protected boolean canGrow(IWorld world, BlockPos minCorner, BlockPos maxCorner) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)minCorner, (BlockPos)maxCorner)) {
            mutablePos.func_189533_g((Vec3i)pos);
            mutablePos.func_189536_c(Direction.DOWN);
            int depth = 0;
            while (TemplateFungiFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, (BlockPos)mutablePos)) {
                mutablePos.func_189536_c(Direction.DOWN);
                if (depth++ < 3) continue;
                return false;
            }
            if (TemplateFungiFeature.isSoil((IWorldGenerationBaseReader)world, (BlockPos)mutablePos, this.getSapling())) continue;
            return false;
        }
        return true;
    }

    protected boolean canFit(IWorld world, BlockPos trunkTop, BlockPos minCorner, BlockPos maxCorner) {
        BlockPos maxFit = new BlockPos(maxCorner.func_177958_n(), trunkTop.func_177956_o(), maxCorner.func_177952_p());
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)minCorner, (BlockPos)maxFit)) {
            if (TemplateFungiFeature.canGrowInto(world, pos)) continue;
            return false;
        }
        return true;
    }

    protected Template.BlockInfo processState(IWorldReader world, BlockPos origin, Template.BlockInfo srcInfo, Template.BlockInfo info, PlacementSettings settings) {
        Block block = info.field_186243_b.func_177230_c();
        return block == Blocks.field_185779_df || block == Blocks.field_150350_a ? null : info;
    }

    private boolean canPlaceShelf(IWorld world, BlockPos pos) {
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MidnightBlocks.FUNGI_INSIDE) {
            return false;
        }
        return state.func_177230_c().isAir(state, (IBlockReader)world, pos) || state.func_203425_a(BlockTags.field_206952_E) || state.func_185904_a() == Material.field_151585_k;
    }
}

