/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.template;

import com.mushroom.midnight.common.world.template.CompiledTemplate;
import com.mushroom.midnight.common.world.template.RuntimeStructureProcessor;
import com.mushroom.midnight.common.world.template.TemplateMarkerProcessor;
import com.mushroom.midnight.common.world.template.TemplateMarkers;
import com.mushroom.midnight.common.world.template.TemplatePostProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public class TemplateCompiler {
    private final List<ResourceLocation> templates = new ArrayList<ResourceLocation>();
    private String anchorKey;
    private final Collection<BiConsumer<PlacementSettings, Random>> settingConfigurators = new ArrayList<BiConsumer<PlacementSettings, Random>>();
    private final Collection<StructureProcessor> processors = new ArrayList<StructureProcessor>();
    private TemplateMarkerProcessor markerProcessor;
    private final Collection<TemplatePostProcessor> postProcessors = new ArrayList<TemplatePostProcessor>();

    public static TemplateCompiler of(ResourceLocation ... templates) {
        return new TemplateCompiler().withTemplates(templates);
    }

    public TemplateCompiler withTemplates(ResourceLocation ... templates) {
        Collections.addAll(this.templates, templates);
        return this;
    }

    public TemplateCompiler withSettingConfigurator(BiConsumer<PlacementSettings, Random> configurator) {
        this.settingConfigurators.add(configurator);
        return this;
    }

    public TemplateCompiler withProcessor(RuntimeStructureProcessor.Function processor) {
        this.processors.add(new RuntimeStructureProcessor(processor));
        return this;
    }

    public TemplateCompiler withMarkerProcessor(TemplateMarkerProcessor processor) {
        this.markerProcessor = processor;
        return this;
    }

    public TemplateCompiler withPostProcessor(TemplatePostProcessor processor) {
        this.postProcessors.add(processor);
        return this;
    }

    public TemplateCompiler withAnchor(String key) {
        if (this.anchorKey != null) {
            throw new IllegalStateException("Template is already anchored to '" + this.anchorKey + "'");
        }
        this.anchorKey = key;
        return this;
    }

    public CompiledTemplate compile(IWorld world, Random random, BlockPos origin) {
        World rootWorld = world.func_201672_e();
        if (!(rootWorld instanceof ServerWorld)) {
            throw new IllegalArgumentException("Cannot load template on " + rootWorld);
        }
        ResourceLocation templateId = this.templates.get(random.nextInt(this.templates.size()));
        TemplateManager templateManager = ((ServerWorld)rootWorld).func_184163_y();
        PlacementSettings settings = this.buildPlacementSettings(random);
        Template template = templateManager.func_200219_b(templateId);
        if (template == null) {
            throw new IllegalStateException("Could not load template for id " + templateId);
        }
        TemplateMarkers markers = TemplateCompiler.compileMarkers(BlockPos.field_177992_a, settings, template);
        BlockPos anchor = this.computeAnchor(markers);
        BlockPos anchoredOrigin = anchor != null ? origin.func_177973_b((Vec3i)anchor) : origin;
        return new CompiledTemplate(templateId, template, settings, anchoredOrigin, this.markerProcessor, this.postProcessors);
    }

    @Nullable
    private BlockPos computeAnchor(TemplateMarkers markers) {
        if (this.anchorKey == null) {
            return null;
        }
        return markers.lookupAny(this.anchorKey);
    }

    private PlacementSettings buildPlacementSettings(Random random) {
        PlacementSettings settings = new PlacementSettings();
        for (BiConsumer<PlacementSettings, Random> configurator : this.settingConfigurators) {
            configurator.accept(settings, random);
        }
        this.processors.forEach(arg_0 -> ((PlacementSettings)settings).func_215222_a(arg_0));
        return settings;
    }

    public static TemplateMarkers compileMarkers(BlockPos origin, PlacementSettings settings, Template template) {
        TemplateMarkers.Builder builder = TemplateMarkers.builder();
        List structureBlocks = template.func_215381_a(origin, settings, Blocks.field_185779_df);
        for (Template.BlockInfo info : structureBlocks) {
            StructureMode mode;
            if (info.field_186244_c == null || (mode = StructureMode.valueOf((String)info.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            String metadata = info.field_186244_c.func_74779_i("metadata");
            builder.add(info.field_186242_a, metadata);
        }
        return builder.build();
    }
}

