/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyTagCapability {
    public void removeColony(int var1, Chunk var2);

    public void addColony(int var1, Chunk var2);

    @NotNull
    public List<Integer> getAllCloseColonies();

    public void setOwningColony(int var1, Chunk var2);

    public int getOwningColony();

    public void reset(Chunk var1);

    public void addBuildingClaim(int var1, BlockPos var2, Chunk var3);

    public void removeBuildingClaim(int var1, BlockPos var2, Chunk var3);

    public void setCloseColonies(List<Integer> var1);

    @NotNull
    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings();

    public void readFromNBT(CompoundNBT var1);

    public static class Storage
    implements Capability.IStorage<IColonyTagCapability> {
        public INBT writeNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("id", instance.getOwningColony());
            compound.func_218657_a("colonies", (INBT)instance.getAllCloseColonies().stream().map(Storage::write).collect(NBTUtils.toListNBT()));
            compound.func_218657_a("buildingsClaim", (INBT)instance.getAllClaimingBuildings().entrySet().stream().map(Storage::writeClaims).collect(NBTUtils.toListNBT()));
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side, @NotNull INBT nbt) {
            if (nbt instanceof CompoundNBT && ((CompoundNBT)nbt).func_74764_b("id")) {
                instance.readFromNBT((CompoundNBT)nbt);
            }
        }

        private static CompoundNBT write(int id) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("id", id);
            return compound;
        }

        private static CompoundNBT writeClaims(@NotNull Map.Entry<Integer, Set<BlockPos>> entry) {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("id", entry.getKey().intValue());
            compound.func_218657_a("buildings", (INBT)entry.getValue().stream().map(pos -> BlockPosUtil.write(new CompoundNBT(), "building", pos)).collect(NBTUtils.toListNBT()));
            return compound;
        }
    }

    public static class Impl
    implements IColonyTagCapability {
        private Set<Integer> colonies = new HashSet<Integer>();
        private int owningColony = 0;
        private final Map<Integer, Set<BlockPos>> claimingBuildings = new HashMap<Integer, Set<BlockPos>>();

        @Override
        public void addColony(int id, Chunk chunk) {
            this.colonies.add(id);
            chunk.func_76630_e();
        }

        @Override
        public void removeColony(int id, Chunk chunk) {
            this.colonies.remove(id);
            if (this.owningColony == id) {
                this.owningColony = 0;
            }
            chunk.func_76630_e();
        }

        @Override
        public void setCloseColonies(List<Integer> colonies) {
            this.colonies = new HashSet<Integer>(colonies);
        }

        @Override
        public void reset(Chunk chunk) {
            this.colonies.clear();
            this.owningColony = 0;
            this.claimingBuildings.clear();
            chunk.func_76630_e();
        }

        @Override
        public void addBuildingClaim(int colonyId, BlockPos pos, Chunk chunk) {
            if (this.owningColony == 0) {
                this.setOwningColony(colonyId, chunk);
            }
            if (this.claimingBuildings.containsKey(colonyId)) {
                this.claimingBuildings.get(colonyId).add(pos);
            } else {
                HashSet<BlockPos> newList = new HashSet<BlockPos>();
                newList.add(pos);
                this.claimingBuildings.put(colonyId, newList);
            }
            chunk.func_76630_e();
        }

        @Override
        public void removeBuildingClaim(int colonyId, BlockPos pos, Chunk chunk) {
            if (this.claimingBuildings.containsKey(colonyId)) {
                Set<BlockPos> buildings = this.claimingBuildings.get(colonyId);
                buildings.remove(pos);
                if (buildings.isEmpty()) {
                    this.claimingBuildings.remove(colonyId);
                }
                if (this.owningColony == colonyId) {
                    if (this.claimingBuildings.isEmpty()) {
                        this.reset(chunk);
                    } else if (this.claimingBuildings.size() == 1) {
                        this.setOwningColony(this.claimingBuildings.keySet().iterator().next(), chunk);
                    } else {
                        this.setOwningColony(this.claimingBuildings.keySet().toArray(new Integer[0])[new Random().nextInt(this.claimingBuildings.size())], chunk);
                    }
                }
            }
            chunk.func_76630_e();
        }

        @Override
        public void setOwningColony(int id, Chunk chunk) {
            this.owningColony = id;
            chunk.func_76630_e();
        }

        @Override
        public int getOwningColony() {
            return this.owningColony;
        }

        @Override
        @NotNull
        public List<Integer> getAllCloseColonies() {
            return new ArrayList<Integer>(this.colonies);
        }

        @Override
        @NotNull
        public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
            return this.claimingBuildings;
        }

        @Override
        public void readFromNBT(CompoundNBT compound) {
            this.owningColony = compound.func_74762_e("id");
            NBTUtils.streamCompound(compound.func_150295_c("colonies", 10)).map(c -> c.func_74762_e("id")).forEach(this.colonies::add);
            NBTUtils.streamCompound(compound.func_150295_c("buildingsClaim", 10)).forEach(this::readClaims);
        }

        private void readClaims(CompoundNBT compound) {
            int id = compound.func_74762_e("id");
            NBTUtils.streamCompound(compound.func_150295_c("buildings", 10)).forEach(tag -> {
                BlockPos pos = BlockPosUtil.read(tag, "building");
                if (this.claimingBuildings.containsKey(id)) {
                    this.claimingBuildings.get(id).add(pos);
                } else {
                    HashSet<BlockPos> newList = new HashSet<BlockPos>();
                    newList.add(pos);
                    this.claimingBuildings.put(id, newList);
                }
            });
        }
    }
}

