/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings;

import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public interface IGuardBuilding
extends IBuildingWorker {
    public static final int PATROL_DISTANCE = 30;

    public static boolean checkIfGuardShouldTakeDamage(AbstractEntityCitizen citizen, PlayerEntity player) {
        IBuildingWorker buildingWorker = citizen.getCitizenColonyHandler().getWorkBuilding();
        if (!(buildingWorker instanceof IGuardBuilding)) {
            return true;
        }
        return !player.equals((Object)((IGuardBuilding)buildingWorker).getPlayerToFollowOrRally());
    }

    public GuardTask getTask();

    public void setTask(GuardTask var1);

    @Nullable
    public BlockPos getNextPatrolTarget(boolean var1);

    public int getDefenceBonus();

    public int getOffenceBonus();

    public void arrivedAtPatrolPoint(AbstractEntityCitizen var1);

    public int getPatrolDistance();

    public GuardType getGuardType();

    public void setGuardType(GuardType var1);

    public List<BlockPos> getPatrolTargets();

    public boolean shallRetrieveOnLowHealth();

    public void setRetrieveOnLowHealth(boolean var1);

    public boolean shallPatrolManually();

    public void setPatrolManually(boolean var1);

    public boolean shallAssignManually();

    public void setAssignManually(boolean var1);

    public boolean isTightGrouping();

    public void setTightGrouping(boolean var1);

    public BlockPos getGuardPos();

    public void setGuardPos(BlockPos var1);

    public Map<ResourceLocation, MobEntryView> getMobsToAttack();

    public void setMobsToAttack(List<MobEntryView> var1);

    public PlayerEntity getPlayerToFollowOrRally();

    public void setPlayerToFollow(PlayerEntity var1);

    public ILocation getRallyLocation();

    public void setRallyLocation(ILocation var1);

    public BlockPos getPositionToFollow();

    public void addPatrolTargets(BlockPos var1);

    public void resetPatrolTargets();

    public int getBonusVision();

    public void calculateMobs();

    public boolean requiresManualTarget();
}

