/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.registry;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class BuildingEntry
extends ForgeRegistryEntry<BuildingEntry> {
    private final AbstractBlockHut<?> buildingBlock;
    private final BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
    private final Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;

    public AbstractBlockHut<?> getBuildingBlock() {
        return this.buildingBlock;
    }

    public BiFunction<IColony, BlockPos, IBuilding> getBuildingProducer() {
        return this.buildingProducer;
    }

    private BuildingEntry(AbstractBlockHut<?> buildingBlock, BiFunction<IColony, BlockPos, IBuilding> buildingProducer, Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer) {
        this.buildingBlock = buildingBlock;
        this.buildingProducer = buildingProducer;
        this.buildingViewProducer = buildingViewProducer;
    }

    public Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> getBuildingViewProducer() {
        return this.buildingViewProducer;
    }

    public static final class Builder {
        private AbstractBlockHut<?> buildingBlock;
        private BiFunction<IColony, BlockPos, IBuilding> buildingProducer;
        private Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer;
        private ResourceLocation registryName;

        public Builder setBuildingBlock(AbstractBlockHut<?> buildingBlock) {
            this.buildingBlock = buildingBlock;
            return this;
        }

        public Builder setBuildingProducer(BiFunction<IColony, BlockPos, IBuilding> buildingProducer) {
            this.buildingProducer = buildingProducer;
            return this;
        }

        public Builder setBuildingViewProducer(Supplier<BiFunction<IColonyView, BlockPos, IBuildingView>> buildingViewProducer) {
            this.buildingViewProducer = buildingViewProducer;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public BuildingEntry createBuildingEntry() {
            Validate.notNull(this.buildingBlock);
            Validate.notNull(this.buildingProducer);
            Validate.notNull(this.buildingViewProducer);
            Validate.notNull((Object)this.registryName);
            return (BuildingEntry)new BuildingEntry(this.buildingBlock, this.buildingProducer, this.buildingViewProducer).setRegistryName(this.registryName);
        }
    }
}

