/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.views;

import com.minecolonies.api.IMinecoloniesAPI;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class MobEntryView {
    private int priority;
    private ResourceLocation location;
    private boolean shouldAttack;

    public MobEntryView(ResourceLocation location, Boolean shouldAttack, Integer priority) {
        this.location = location;
        this.shouldAttack = shouldAttack;
        this.priority = priority;
    }

    public static void writeToByteBuf(@NotNull PacketBuffer buf, @NotNull MobEntryView entry) {
        buf.func_180714_a(entry.getLocation().toString());
        buf.writeBoolean(entry.shouldAttack());
        buf.writeInt(entry.getPriority());
    }

    @NotNull
    public static MobEntryView readFromByteBuf(@NotNull PacketBuffer buf) {
        ResourceLocation location = new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE));
        Boolean attack = buf.readBoolean();
        Integer priority = buf.readInt();
        return new MobEntryView(location, attack, priority);
    }

    public static void write(@NotNull CompoundNBT compound, String name, @NotNull MobEntryView entry) {
        CompoundNBT coordsCompound = new CompoundNBT();
        coordsCompound.func_74778_a("location", entry.getLocation().toString());
        coordsCompound.func_74757_a("attack", entry.shouldAttack());
        coordsCompound.func_74768_a("priority", entry.getPriority());
        compound.func_218657_a(name, (INBT)coordsCompound);
    }

    @NotNull
    public static MobEntryView read(@NotNull CompoundNBT compound, String name) {
        CompoundNBT entryCompound = compound.func_74775_l(name);
        ResourceLocation location = new ResourceLocation(entryCompound.func_74779_i("location"));
        Boolean attack = entryCompound.func_74767_n("attack");
        Integer priority = entryCompound.func_74762_e("priority");
        return new MobEntryView(location, attack, priority);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    public boolean shouldAttack() {
        return this.shouldAttack;
    }

    public void setShouldAttack(boolean shouldAttack) {
        this.shouldAttack = shouldAttack;
    }

    public String getName() {
        if (((Boolean)IMinecoloniesAPI.getInstance().getConfig().getCommon().enableInDevelopmentFeatures.get()).booleanValue()) {
            return String.format("%s:%d", ((EntityType)ForgeRegistries.ENTITIES.getValue(this.location)).func_210760_d(), this.priority);
        }
        return ((EntityType)ForgeRegistries.ENTITIES.getValue(this.location)).func_212546_e().func_150254_d();
    }

    public EntityType<?> getEntityEntry() {
        return (EntityType)ForgeRegistries.ENTITIES.getValue(this.location);
    }
}

