/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.ITypeOverrideHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public final class StandardFactoryController
implements IFactoryController {
    public static final String NBT_TYPE = "Type";
    public static final String NBT_DATA = "Data";
    private static final StandardFactoryController INSTANCE = new StandardFactoryController();
    @NotNull
    private final Map<TypeToken<?>, Set<IFactory<?, ?>>> primaryInputMappings = new HashMap();
    @NotNull
    private final Map<TypeToken<?>, Set<IFactory<?, ?>>> primaryOutputMappings = new HashMap();
    @NotNull
    private final Map<TypeToken<?>, Set<IFactory<?, ?>>> secondaryOutputMappings = new HashMap();
    @NotNull
    private final Cache<Tuple<TypeToken<?>, TypeToken<?>>, IFactory<?, ?>> secondaryMappingsCache = CacheBuilder.newBuilder().build();
    @NotNull
    private final List<ITypeOverrideHandler<?>> typeOverrideHandlers = new ArrayList();
    @NotNull
    private final BiMap<String, String> classRenamingHandlers = HashBiMap.create();
    private Map<Short, IFactory<?, ?>> serializationMappings = new HashMap();

    private StandardFactoryController() {
        if (INSTANCE != null) {
            throw new IllegalStateException("StandardFactoryController");
        }
    }

    public static void reset() {
        StandardFactoryController.getInstance().primaryInputMappings.clear();
        StandardFactoryController.getInstance().primaryOutputMappings.clear();
        StandardFactoryController.getInstance().secondaryOutputMappings.clear();
    }

    public static StandardFactoryController getInstance() {
        return INSTANCE;
    }

    public <INPUT, OUTPUT> IFactory<INPUT, OUTPUT> getFactoryForIO(@NotNull TypeToken<? extends INPUT> inputClass, @NotNull TypeToken<? extends OUTPUT> outputClass) throws IllegalArgumentException {
        ITypeOverrideHandler inputOverrideHandler = this.typeOverrideHandlers.stream().filter(h -> h.matches(inputClass)).findFirst().orElse(null);
        ITypeOverrideHandler outputOverrideHandler = this.typeOverrideHandlers.stream().filter(h -> h.matches(outputClass)).findFirst().orElse(null);
        Object input = inputOverrideHandler != null ? inputOverrideHandler.getOutputType() : inputClass;
        Object output = outputOverrideHandler != null ? outputOverrideHandler.getOutputType() : outputClass;
        try {
            return (IFactory)this.secondaryMappingsCache.get((Object)new Tuple(input, output), () -> {
                Set<TypeToken<?>> secondaryInputSet = ReflectionUtils.getSuperClasses(input);
                for (TypeToken<?> secondaryInputClass : secondaryInputSet) {
                    Set<IFactory<?, ?>> factories = this.primaryInputMappings.get(secondaryInputClass);
                    if (factories == null || factories.isEmpty()) continue;
                    for (IFactory<?, ?> factory : factories) {
                        Set<TypeToken<?>> secondaryOutputSet = ReflectionUtils.getSuperClasses(factory.getFactoryOutputType());
                        if (!secondaryOutputSet.contains(output)) continue;
                        return factory;
                    }
                }
                throw new IllegalArgumentException("No factory found with the given IO types: " + input + " ->" + output);
            });
        }
        catch (ExecutionException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("No factory found with the given IO types: " + input + " ->" + output).initCause(e);
        }
    }

    public <INPUT> IFactory<INPUT, ?> getFactoryForInput(@NotNull TypeToken<? extends INPUT> inputClass) throws IllegalArgumentException {
        ITypeOverrideHandler inputOverrideHandler = this.typeOverrideHandlers.stream().filter(h -> h.matches(inputClass)).findFirst().orElse(null);
        Object input = inputOverrideHandler != null ? inputOverrideHandler.getOutputType() : inputClass;
        Set<TypeToken<?>> secondaryInputSet = ReflectionUtils.getSuperClasses(input);
        for (TypeToken<?> secondaryInputClass : secondaryInputSet) {
            Set<IFactory<?, ?>> factories = this.primaryInputMappings.get(secondaryInputClass);
            if (factories == null || factories.isEmpty()) continue;
            return (IFactory)factories.stream().findFirst().get();
        }
        throw new IllegalArgumentException("The given input type is not a input of a factory.");
    }

    public <OUTPUT> IFactory<?, OUTPUT> getFactoryForOutput(@NotNull TypeToken<? extends OUTPUT> outputClass) throws IllegalArgumentException {
        Object output;
        ITypeOverrideHandler outputOverrideHandler = this.typeOverrideHandlers.stream().filter(h -> h.matches(outputClass)).findFirst().orElse(null);
        Object object = output = outputOverrideHandler != null ? outputOverrideHandler.getOutputType() : outputClass;
        if (!this.primaryOutputMappings.containsKey(output) || this.primaryOutputMappings.get(output).isEmpty()) {
            if (!this.secondaryOutputMappings.containsKey(output)) {
                throw new IllegalArgumentException("The given output type is not a output of a factory");
            }
            return (IFactory)this.secondaryOutputMappings.get(output).stream().findFirst().get();
        }
        return (IFactory)this.primaryOutputMappings.get(output).stream().findFirst().get();
    }

    public <OUTPUT> IFactory<?, OUTPUT> getFactoryForSerializationId(short id) throws IllegalArgumentException {
        return this.serializationMappings.get(id);
    }

    public <INPUT, OUTPUT> void registerNewFactory(@NotNull IFactory<INPUT, OUTPUT> factory) throws IllegalArgumentException {
        this.primaryInputMappings.putIfAbsent(factory.getFactoryInputType(), new HashSet());
        this.primaryOutputMappings.putIfAbsent(factory.getFactoryOutputType(), new HashSet());
        if (this.serializationMappings.containsKey(factory.getSerializationId())) {
            throw new IllegalArgumentException("Cannot register two factories with the same serialization id!");
        }
        this.serializationMappings.put(factory.getSerializationId(), factory);
        Set<IFactory<?, ?>> primaryInputFactories = this.primaryInputMappings.get(factory.getFactoryInputType());
        Set<IFactory<?, ?>> primaryOutputFactories = this.primaryOutputMappings.get(factory.getFactoryOutputType());
        if (primaryInputFactories.contains(factory) || primaryOutputFactories.contains(factory)) {
            throw new IllegalArgumentException("Cannot register the same factory twice!");
        }
        primaryInputFactories.add(factory);
        primaryOutputFactories.add(factory);
        Set<TypeToken<?>> outputSuperTypes = ReflectionUtils.getSuperClasses(factory.getFactoryOutputType());
        outputSuperTypes.remove(factory.getFactoryOutputType());
        if (!outputSuperTypes.isEmpty()) {
            outputSuperTypes.forEach(t -> {
                if (!this.secondaryOutputMappings.containsKey(t)) {
                    this.secondaryOutputMappings.put((TypeToken<?>)t, new HashSet());
                }
                this.secondaryOutputMappings.get(t).add(factory);
            });
        }
    }

    public <OUTPUT> CompoundNBT serialize(@NotNull OUTPUT object) throws IllegalArgumentException {
        CompoundNBT compound = new CompoundNBT();
        IFactory<?, OUTPUT> factory = this.getFactoryForOutput((TypeToken<? extends OUTPUT>)TypeToken.of(object.getClass()));
        compound.func_74778_a(NBT_TYPE, object.getClass().getName());
        compound.func_218657_a(NBT_DATA, (INBT)factory.serialize(this, object));
        return compound;
    }

    public <OUTPUT> OUTPUT deserialize(@NotNull CompoundNBT compound) throws IllegalArgumentException {
        IFactory factory;
        String className = compound.func_74779_i(NBT_TYPE);
        className = this.processClassRenaming(className);
        try {
            factory = this.getFactoryForOutput(className);
        }
        catch (IllegalArgumentException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("The given compound holds an unknown output type for this Controller: " + className).initCause(e);
        }
        try {
            return (OUTPUT)factory.deserialize((IFactoryController)this, compound.func_74775_l(NBT_DATA));
        }
        catch (Throwable throwable) {
            Log.getLogger().error((Object)throwable);
            return null;
        }
    }

    private String processClassRenaming(@NotNull String previousClassName) {
        if (!this.classRenamingHandlers.containsKey((Object)previousClassName)) {
            return previousClassName;
        }
        return this.processClassRenaming((String)this.classRenamingHandlers.get((Object)previousClassName));
    }

    public <OUTPUT> void serialize(@NotNull PacketBuffer buffer, @NotNull OUTPUT object) throws IllegalArgumentException {
        IFactory<?, OUTPUT> factory = this.getFactoryForOutput((TypeToken<? extends OUTPUT>)TypeToken.of(object.getClass()));
        buffer.writeShort((int)factory.getSerializationId());
        factory.serialize(this, object, buffer);
    }

    public <OUTPUT> OUTPUT deserialize(@NotNull PacketBuffer buffer) throws IllegalArgumentException {
        IFactory factory;
        short classId = buffer.readShort();
        try {
            factory = this.getFactoryForOutput(classId);
        }
        catch (IllegalArgumentException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("The given compound holds an unknown output type for this Controller").initCause(e);
        }
        try {
            return (OUTPUT)factory.deserialize((IFactoryController)this, buffer);
        }
        catch (Throwable throwable) {
            Log.getLogger().error((Object)throwable);
            return null;
        }
    }

    public <INPUT, OUTPUT> OUTPUT getNewInstance(@NotNull TypeToken<? extends OUTPUT> requestedType, @NotNull INPUT input, Object ... context) throws IllegalArgumentException, ClassCastException {
        TypeToken inputToken = TypeToken.of(input.getClass());
        IFactory<INPUT, OUTPUT> factory = this.getFactoryForIO((TypeToken<? extends INPUT>)inputToken, requestedType);
        return factory.getNewInstance(this, input, context);
    }

    public <OUTPUT> OUTPUT getNewInstance(@NotNull TypeToken<? extends OUTPUT> requestedType) throws IllegalArgumentException {
        return this.getNewInstance(requestedType, (INPUT)FactoryVoidInput.INSTANCE, new Object[0]);
    }

    public <OUTPUT> void registerNewTypeOverrideHandler(@NotNull ITypeOverrideHandler<OUTPUT> overrideHandler) {
        this.typeOverrideHandlers.add(overrideHandler);
    }

    @Override
    public void registerNewClassRenaming(@NotNull String previousName, @NotNull String newName) {
        this.classRenamingHandlers.put((Object)previousName, (Object)newName);
    }
}

