/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class Stack
implements IConcreteDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Stack.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_STACK = "Stack";
    private static final String NBT_MATCHMETA = "MatchMeta";
    private static final String NBT_MATCHNBT = "MatchNBT";
    private static final String NBT_MATCHOREDIC = "MatchOreDic";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_COUNT = "Count";
    private static final String NBT_MINCOUNT = "MinCount";
    @NotNull
    private final ItemStack theStack;
    private boolean matchMeta;
    private boolean matchNBT;
    private boolean matchOreDic;
    private int count;
    private int minCount;
    @NotNull
    private ItemStack result;

    public Stack(@NotNull ItemStack stack) {
        this(stack, true, false, false, ItemStackUtils.EMPTY, Math.min(stack.func_190916_E(), stack.func_77976_d()), Math.min(stack.func_190916_E(), stack.func_77976_d()));
    }

    public Stack(@NotNull ItemStack stack, int count, int minCount) {
        this(stack, true, false, false, ItemStackUtils.EMPTY, count, minCount);
    }

    public Stack(@NotNull ItemStorage itemStorage) {
        this(itemStorage.getItemStack(), !itemStorage.ignoreDamageValue(), false, false, ItemStackUtils.EMPTY, itemStorage.getAmount(), itemStorage.getAmount());
    }

    public Stack(@NotNull ItemStack stack, boolean matchMeta, boolean matchNBT, boolean matchOreDic, @NotNull ItemStack result, int count, int minCount) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            throw new IllegalArgumentException("Cannot deliver Empty Stack.");
        }
        this.theStack = stack.func_77946_l();
        this.matchMeta = matchMeta;
        this.matchNBT = matchNBT;
        this.matchOreDic = matchOreDic;
        this.result = result;
        this.count = count;
        this.minCount = minCount;
    }

    public static CompoundNBT serialize(IFactoryController controller, Stack input) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_STACK, (INBT)input.theStack.serializeNBT());
        compound.func_74757_a(NBT_MATCHMETA, input.matchMeta);
        compound.func_74757_a(NBT_MATCHNBT, input.matchNBT);
        compound.func_74757_a(NBT_MATCHOREDIC, input.matchOreDic);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            compound.func_218657_a(NBT_RESULT, (INBT)input.result.serializeNBT());
        }
        compound.func_74768_a(NBT_COUNT, input.getCount());
        compound.func_74768_a(NBT_MINCOUNT, input.getMinimumCount());
        return compound;
    }

    public static Stack deserialize(IFactoryController controller, CompoundNBT compound) {
        int count;
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_STACK));
        boolean matchMeta = compound.func_74767_n(NBT_MATCHMETA);
        boolean matchNBT = compound.func_74767_n(NBT_MATCHNBT);
        boolean matchOreDic = compound.func_74767_n(NBT_MATCHOREDIC);
        ItemStack result = compound.func_150296_c().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        int minCount = count = compound.func_74762_e("size");
        if (compound.func_150296_c().contains(NBT_COUNT)) {
            count = compound.func_74762_e(NBT_COUNT);
            minCount = compound.func_74762_e(NBT_MINCOUNT);
        }
        return new Stack(stack, matchMeta, matchNBT, matchOreDic, result, count, minCount);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Stack input) {
        buffer.func_150788_a(input.theStack);
        buffer.writeBoolean(input.matchMeta);
        buffer.writeBoolean(input.matchNBT);
        buffer.writeBoolean(input.matchOreDic);
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.func_150788_a(input.result);
        }
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinimumCount());
    }

    public static Stack deserialize(IFactoryController controller, PacketBuffer buffer) {
        ItemStack stack = buffer.func_150791_c();
        boolean matchMeta = buffer.readBoolean();
        boolean matchNBT = buffer.readBoolean();
        boolean matchOreDic = buffer.readBoolean();
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        return new Stack(stack, matchMeta, matchNBT, matchOreDic, result, count, minCount);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (this.matchOreDic && !Collections.disjoint(stack.func_77973_b().getTags(), this.theStack.func_77973_b().getTags())) {
            return true;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), stack, this.matchMeta, this.matchNBT);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return this.minCount;
    }

    @NotNull
    public ItemStack getStack() {
        return this.theStack;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Stack(this.theStack, this.matchMeta, this.matchNBT, this.matchOreDic, this.result, newCount, this.minCount);
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Stack)) {
            return false;
        }
        Stack stack1 = (Stack)o;
        if (this.matchMeta != stack1.matchMeta) {
            return false;
        }
        if (this.matchNBT != stack1.matchNBT) {
            return false;
        }
        if (this.matchOreDic != stack1.matchOreDic) {
            return false;
        }
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), stack1.getStack()).booleanValue()) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), stack1.getResult());
    }

    public int hashCode() {
        int result1 = this.getStack().hashCode();
        result1 = 31 * result1 + (this.matchMeta ? 1 : 0);
        result1 = 31 * result1 + (this.matchNBT ? 1 : 0);
        result1 = 31 * result1 + (this.matchOreDic ? 1 : 0);
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    @Override
    public List<ItemStack> getRequestedItems() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.theStack});
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

