/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class StackList
implements IConcreteDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(StackList.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_STACK_LIST = "StackList";
    private static final String NBT_MATCHMETA = "MatchMeta";
    private static final String NBT_MATCHNBT = "MatchNBT";
    private static final String NBT_MATCHOREDIC = "MatchOreDic";
    private static final String NBT_RESULT = "Result";
    private static final String TAG_DESCRIPTION = "Desc";
    private static final String NBT_COUNT = "Count";
    private static final String NBT_MINCOUNT = "MinCount";
    @NotNull
    private final List<ItemStack> theStacks = new ArrayList<ItemStack>();
    private boolean matchMeta;
    private boolean matchNBT;
    private boolean matchOreDic;
    private final String description;
    @NotNull
    private ItemStack result;
    private int count;
    private int minCount;

    public StackList(@NotNull List<ItemStack> stacks, String description, int count) {
        this(stacks, description, count, count);
    }

    public StackList(@NotNull List<ItemStack> stacks, String description, int count, int minCount) {
        this(stacks, true, true, false, ItemStackUtils.EMPTY, description, count, minCount);
    }

    public StackList(@NotNull List<ItemStack> stacks, boolean matchMeta, boolean matchNBT, boolean matchOreDic, @NotNull ItemStack result, String description, int count, int minCount) {
        this.description = description;
        for (ItemStack stack : stacks) {
            ItemStack tempStack = stack.func_77946_l();
            tempStack.func_190920_e(Math.min(tempStack.func_190916_E(), tempStack.func_77976_d()));
            this.theStacks.add(tempStack);
        }
        this.matchMeta = matchMeta;
        this.matchNBT = matchNBT;
        this.matchOreDic = matchOreDic;
        this.result = result;
        this.count = count;
        this.minCount = minCount;
    }

    public static CompoundNBT serialize(IFactoryController controller, StackList input) {
        CompoundNBT compound = new CompoundNBT();
        ListNBT neededResTagList = new ListNBT();
        for (ItemStack resource : input.theStacks) {
            neededResTagList.add((Object)resource.serializeNBT());
        }
        compound.func_218657_a(NBT_STACK_LIST, (INBT)neededResTagList);
        compound.func_74757_a(NBT_MATCHMETA, input.matchMeta);
        compound.func_74757_a(NBT_MATCHNBT, input.matchNBT);
        compound.func_74757_a(NBT_MATCHOREDIC, input.matchOreDic);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            compound.func_218657_a(NBT_RESULT, (INBT)input.result.serializeNBT());
        }
        compound.func_74778_a(TAG_DESCRIPTION, input.description);
        compound.func_74768_a(NBT_COUNT, input.getCount());
        compound.func_74768_a(NBT_MINCOUNT, input.getMinimumCount());
        return compound;
    }

    public static StackList deserialize(IFactoryController controller, CompoundNBT compound) {
        int count;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ListNBT neededResTagList = compound.func_150295_c(NBT_STACK_LIST, 10);
        for (int i = 0; i < neededResTagList.size(); ++i) {
            CompoundNBT neededRes = neededResTagList.func_150305_b(i);
            stacks.add(ItemStack.func_199557_a((CompoundNBT)neededRes));
        }
        boolean matchMeta = compound.func_74767_n(NBT_MATCHMETA);
        boolean matchNBT = compound.func_74767_n(NBT_MATCHNBT);
        boolean matchOreDic = compound.func_74767_n(NBT_MATCHOREDIC);
        ItemStack result = compound.func_150296_c().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        String desc = compound.func_150296_c().contains(TAG_DESCRIPTION) ? compound.func_74779_i(TAG_DESCRIPTION) : "com.minecolonies.coremod.request.stacklist";
        int minCount = count = stacks.isEmpty() ? 0 : ((ItemStack)stacks.get(0)).func_190916_E();
        if (compound.func_150296_c().contains(NBT_COUNT)) {
            count = compound.func_74762_e(NBT_COUNT);
            minCount = compound.func_74762_e(NBT_MINCOUNT);
        }
        return new StackList(stacks, matchMeta, matchNBT, matchOreDic, result, desc, count, minCount);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, StackList input) {
        buffer.writeInt(input.theStacks.size());
        input.theStacks.forEach(res -> buffer.func_150788_a(res));
        buffer.writeBoolean(input.matchMeta);
        buffer.writeBoolean(input.matchNBT);
        buffer.writeBoolean(input.matchOreDic);
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.result) == false);
        if (!ItemStackUtils.isEmpty(input.result).booleanValue()) {
            buffer.func_150788_a(input.result);
        }
        buffer.func_180714_a(input.description);
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinimumCount());
    }

    public static StackList deserialize(IFactoryController controller, PacketBuffer buffer) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int stacksSize = buffer.readInt();
        for (int i = 0; i < stacksSize; ++i) {
            stacks.add(buffer.func_150791_c());
        }
        boolean matchMeta = buffer.readBoolean();
        boolean matchNBT = buffer.readBoolean();
        boolean matchOreDic = buffer.readBoolean();
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        String desc = buffer.func_218666_n();
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        return new StackList(stacks, matchMeta, matchNBT, matchOreDic, result, desc, count, minCount);
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        if (this.matchOreDic) {
            for (ItemStack tempStack : this.theStacks) {
                if (Collections.disjoint(stack.func_77973_b().getTags(), tempStack.func_77973_b().getTags())) continue;
                return true;
            }
        }
        return ItemStackUtils.compareItemStackListIgnoreStackSize(this.getStacks(), stack, this.matchMeta, this.matchNBT);
    }

    @Override
    public int getMinimumCount() {
        return this.minCount;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @NotNull
    public List<ItemStack> getStacks() {
        return this.theStacks;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new StackList(this.theStacks, this.matchMeta, this.matchNBT, this.matchOreDic, this.result, this.description, newCount, this.minCount);
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackList)) {
            return false;
        }
        StackList stack1 = (StackList)o;
        if (this.matchMeta != stack1.matchMeta) {
            return false;
        }
        if (this.matchNBT != stack1.matchNBT) {
            return false;
        }
        if (this.matchOreDic != stack1.matchOreDic) {
            return false;
        }
        for (ItemStack tempStack : stack1.getStacks()) {
            if (ItemStackUtils.compareItemStackListIgnoreStackSize(this.getStacks(), tempStack)) continue;
            return false;
        }
        for (ItemStack tempStack : this.getStacks()) {
            if (ItemStackUtils.compareItemStackListIgnoreStackSize(stack1.getStacks(), tempStack)) continue;
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getResult(), stack1.getResult());
    }

    public int hashCode() {
        int result1 = this.getStacks().hashCode();
        result1 = 31 * result1 + (this.matchMeta ? 1 : 0);
        result1 = 31 * result1 + (this.matchNBT ? 1 : 0);
        result1 = 31 * result1 + (this.matchOreDic ? 1 : 0);
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public List<ItemStack> getRequestedItems() {
        return this.theStacks;
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

