/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.AbstractRecipeType;
import com.minecolonies.api.crafting.ClassicRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ImmutableItemStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModRecipeTypes;
import com.minecolonies.api.crafting.registry.RecipeTypeEntry;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeStorage
implements IRecipeStorage {
    private final AbstractRecipeType<IRecipeStorage> recipeType;
    private final ResourceLocation recipeSource;
    @NotNull
    private final List<ItemStack> input;
    @NotNull
    private final List<ItemStorage> cleanedInput;
    @NotNull
    private final ItemStack primaryOutput;
    @Nullable
    private final List<ItemStack> alternateOutputs;
    @Nullable
    private final List<ItemStack> secondaryOutputs;
    private final Block intermediate;
    private final int gridSize;
    private final IToken<?> token;

    public RecipeStorage(IToken<?> token, List<ItemStack> input, int gridSize, @NotNull ItemStack primaryOutput, Block intermediate, ResourceLocation source, ResourceLocation type, List<ItemStack> altOutputs, List<ItemStack> secOutputs) {
        this.input = Collections.unmodifiableList(input);
        this.cleanedInput = new ArrayList<ItemStorage>();
        this.cleanedInput.addAll(this.calculateCleanedInput());
        this.primaryOutput = primaryOutput;
        this.alternateOutputs = altOutputs != null ? altOutputs : ImmutableList.of();
        this.secondaryOutputs = secOutputs != null ? secOutputs.stream().filter(i -> i.func_77973_b() != ModItems.buildTool).collect(Collectors.toList()) : ImmutableList.of();
        this.gridSize = gridSize;
        this.intermediate = intermediate;
        this.token = token;
        this.recipeSource = source;
        IForgeRegistry<RecipeTypeEntry> recipeTypes = MinecoloniesAPIProxy.getInstance().getRecipeTypeRegistry();
        this.recipeType = type != null && recipeTypes.containsKey(type) ? ((RecipeTypeEntry)recipeTypes.getValue(type)).getHandlerProducer().apply(this) : ((RecipeTypeEntry)recipeTypes.getValue(recipeTypes.getDefaultKey())).getHandlerProducer().apply(this);
    }

    @Override
    public List<ItemStack> getInput() {
        return new ArrayList<ItemStack>(this.input);
    }

    @Override
    @NotNull
    public List<ItemStorage> getCleanedInput() {
        return this.cleanedInput;
    }

    private List<ImmutableItemStorage> calculateCleanedInput() {
        ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
        for (ItemStack stack : this.input) {
            if (ItemStackUtils.isEmpty(stack).booleanValue() || stack.func_77973_b() == ModItems.buildTool) continue;
            ItemStorage storage = new ItemStorage(stack.func_77946_l());
            if (items.contains(storage)) {
                int index = items.indexOf(storage);
                ItemStorage tempStorage = (ItemStorage)items.remove(index);
                tempStorage.setAmount(tempStorage.getAmount() + storage.getAmount());
                storage = tempStorage;
            }
            items.add(storage);
        }
        ArrayList<ImmutableItemStorage> immutableItems = new ArrayList<ImmutableItemStorage>();
        for (ItemStorage storage : items) {
            immutableItems.add(new ImmutableItemStorage(storage));
        }
        return immutableItems;
    }

    @Override
    @NotNull
    public ItemStack getPrimaryOutput() {
        return this.primaryOutput;
    }

    @Override
    public int getGridSize() {
        return this.gridSize;
    }

    @Override
    public Block getIntermediate() {
        return this.intermediate;
    }

    @Override
    public boolean canFullFillRecipe(int qty, Map<ItemStorage, Integer> existingRequirements, IItemHandler ... inventories) {
        int neededMultiplier = CraftingUtils.calculateMaxCraftingCount(qty, (IRecipeStorage)this);
        List<ItemStorage> items = this.getCleanedInput();
        for (ItemStorage storage : items) {
            ItemStack container;
            ItemStack stack = storage.getItemStack();
            int availableCount = InventoryUtils.getItemCountInItemHandlers((Collection<IItemHandler>)ImmutableList.copyOf((Object[])inventories), itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, true));
            int neededCount = !this.secondaryOutputs.isEmpty() ? (!ItemStackUtils.compareItemStackListIgnoreStackSize(this.secondaryOutputs, stack, false, true) ? storage.getAmount() * neededMultiplier : storage.getAmount()) : (ItemStackUtils.isEmpty(container = stack.func_77973_b().getContainerItem(stack)) != false || !ItemStackUtils.compareItemStacksIgnoreStackSize(stack, container, false, true) ? storage.getAmount() * neededMultiplier : storage.getAmount());
            if (availableCount >= neededCount + existingRequirements.getOrDefault(storage, 0)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        int i;
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeStorage)) {
            return false;
        }
        RecipeStorage that = (RecipeStorage)o;
        if (this.gridSize != that.gridSize || this.input.size() != that.input.size() || this.cleanedInput.size() != that.cleanedInput.size() || this.alternateOutputs.size() != that.alternateOutputs.size() || this.secondaryOutputs == null != (that.secondaryOutputs == null) || this.secondaryOutputs != null && this.secondaryOutputs.size() != that.secondaryOutputs.size() || !ItemStackUtils.compareItemStacksIgnoreStackSize(this.primaryOutput, that.primaryOutput, false, true)) {
            return false;
        }
        for (i = 0; i < this.cleanedInput.size(); ++i) {
            if (this.cleanedInput.get(i).equals(that.cleanedInput.get(i)) && this.cleanedInput.get(i).getAmount() == that.cleanedInput.get(i).getAmount()) continue;
            return false;
        }
        if (this.recipeSource != null && !this.recipeSource.equals((Object)that.recipeSource)) {
            return false;
        }
        if (this.recipeSource == null && that.recipeSource != null) {
            return false;
        }
        if (!this.recipeType.getId().equals((Object)that.recipeType.getId())) {
            return false;
        }
        for (i = 0; i < this.alternateOutputs.size(); ++i) {
            ItemStack right;
            ItemStack left = this.alternateOutputs.get(i);
            if (ItemStackUtils.compareItemStacksIgnoreStackSize(left, right = that.alternateOutputs.get(i), false, true) && left.func_190916_E() == right.func_190916_E()) continue;
            return false;
        }
        if (this.secondaryOutputs != null) {
            if (that.secondaryOutputs == null) {
                return false;
            }
            for (i = 0; i < this.secondaryOutputs.size(); ++i) {
                if (ItemStackUtils.compareItemStacksIgnoreStackSize(this.secondaryOutputs.get(i), that.secondaryOutputs.get(i), false, true)) continue;
                return false;
            }
        }
        return this.intermediate == null ? that.intermediate == null : this.intermediate.equals(that.intermediate);
    }

    public int hashCode() {
        int result = this.input.hashCode();
        result = 31 * result + this.primaryOutput.hashCode();
        result = 31 * result + (this.intermediate != null ? this.intermediate.hashCode() : 0);
        result = 31 * result + this.gridSize;
        if (this.recipeSource != null) {
            result = 31 * result + this.recipeSource.hashCode();
        }
        if (this.recipeType != null && !(this.recipeType instanceof ClassicRecipe)) {
            result = 31 * result + this.recipeType.hashCode();
        }
        if (this.alternateOutputs != null && !this.alternateOutputs.isEmpty()) {
            result = 31 * result + this.alternateOutputs.hashCode();
        }
        if (this.secondaryOutputs != null && !this.secondaryOutputs.isEmpty()) {
            result = 31 * result + this.secondaryOutputs.hashCode();
        }
        return result;
    }

    private boolean checkForFreeSpace(List<IItemHandler> handlers) {
        ArrayList<ItemStack> resultStacks = new ArrayList<ItemStack>();
        if (!this.secondaryOutputs.isEmpty()) {
            resultStacks.addAll(this.secondaryOutputs);
        } else {
            for (ItemStack stack : this.input) {
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                if (ItemStackUtils.isEmpty(container).booleanValue()) continue;
                container.func_190920_e(stack.func_190916_E());
                resultStacks.add(container);
            }
        }
        resultStacks.add(this.getPrimaryOutput());
        if (resultStacks.size() > this.getInput().size()) {
            int freeSpace = 0;
            for (IItemHandler handler : handlers) {
                freeSpace += handler.getSlots() - InventoryUtils.getAmountOfStacksInItemHandler(handler);
            }
            return freeSpace >= resultStacks.size() - this.getInput().size();
        }
        return true;
    }

    @Override
    public boolean fullfillRecipe(List<IItemHandler> handlers) {
        if (!this.checkForFreeSpace(handlers) || !this.canFullFillRecipe(1, Collections.emptyMap(), handlers.toArray(new IItemHandler[0]))) {
            return false;
        }
        for (ItemStorage storage : this.getCleanedInput()) {
            ItemStack stack = storage.getItemStack();
            int amountNeeded = storage.getAmount();
            if (amountNeeded == 0) break;
            for (IItemHandler handler : handlers) {
                int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, true));
                while (slotOfStack != -1 && amountNeeded > 0) {
                    int count = ItemStackUtils.getSize(handler.getStackInSlot(slotOfStack));
                    ItemStack extractedStack = handler.extractItem(slotOfStack, amountNeeded, false).func_77946_l();
                    if (ItemStackUtils.isEmpty(extractedStack).booleanValue()) {
                        handler.insertItem(slotOfStack, extractedStack, false);
                        return false;
                    }
                    if ((amountNeeded -= count) <= 0) continue;
                    slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(handler, itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, false, true));
                }
                if (amountNeeded > 0) continue;
                break;
            }
            if (amountNeeded <= 0) continue;
            return false;
        }
        this.insertCraftedItems(handlers, this.getPrimaryOutput());
        return true;
    }

    @Override
    public IToken<?> getToken() {
        return this.token;
    }

    private void insertCraftedItems(List<IItemHandler> handlers, ItemStack outputStack) {
        for (IItemHandler handler : handlers) {
            if (InventoryUtils.addItemStackToItemHandler(handler, outputStack.func_77946_l())) break;
        }
        ArrayList<ItemStack> secondaryStacks = new ArrayList<ItemStack>();
        if (!this.secondaryOutputs.isEmpty()) {
            secondaryStacks.addAll(this.secondaryOutputs);
        } else {
            for (ItemStack stack : this.input) {
                ItemStack container;
                if (stack.func_77973_b() == ModItems.buildTool || ItemStackUtils.isEmpty(container = stack.func_77973_b().getContainerItem(stack)).booleanValue()) continue;
                container.func_190920_e(stack.func_190916_E());
                secondaryStacks.add(container);
            }
        }
        for (ItemStack stack : secondaryStacks) {
            for (IItemHandler handler : handlers) {
                if (InventoryUtils.addItemStackToItemHandler(handler, stack.func_77946_l())) break;
            }
        }
    }

    @Override
    public RecipeStorage getClassicForMultiOutput(ItemStack requiredOutput) {
        return new RecipeStorage(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), this.input, this.gridSize, requiredOutput, this.intermediate, this.recipeSource, ModRecipeTypes.CLASSIC_ID, null, this.secondaryOutputs);
    }

    @Override
    public RecipeStorage getClassicForMultiOutput(Predicate<ItemStack> stackPredicate) {
        if (stackPredicate.test(this.getPrimaryOutput())) {
            return this.getClassicForMultiOutput(this.getPrimaryOutput());
        }
        for (ItemStack item : this.getAlternateOutputs()) {
            if (!stackPredicate.test(item)) continue;
            return this.getClassicForMultiOutput(item);
        }
        return null;
    }

    @Override
    public AbstractRecipeType<IRecipeStorage> getRecipeType() {
        return this.recipeType;
    }

    @Override
    public ResourceLocation getRecipeSource() {
        return this.recipeSource;
    }

    @Override
    public List<ItemStack> getAlternateOutputs() {
        return this.alternateOutputs;
    }

    @Override
    public List<ItemStack> getSecondaryOutputs() {
        return this.secondaryOutputs;
    }
}

