/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.PoweredRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class MinecoloniesMinecart
extends AbstractMinecartEntity {
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> MATRIX = (Map)Util.func_200696_a((Object)Maps.newEnumMap(RailShape.class), entry -> {
        Vec3i westVec = Direction.WEST.func_176730_m();
        Vec3i eastVec = Direction.EAST.func_176730_m();
        Vec3i northVec = Direction.NORTH.func_176730_m();
        Vec3i southVec = Direction.SOUTH.func_176730_m();
        entry.put(RailShape.NORTH_SOUTH, Pair.of((Object)northVec, (Object)southVec));
        entry.put(RailShape.EAST_WEST, Pair.of((Object)westVec, (Object)eastVec));
        entry.put(RailShape.ASCENDING_EAST, Pair.of((Object)westVec.func_177977_b(), (Object)eastVec));
        entry.put(RailShape.ASCENDING_WEST, Pair.of((Object)westVec, (Object)eastVec.func_177977_b()));
        entry.put(RailShape.ASCENDING_NORTH, Pair.of((Object)northVec, (Object)southVec.func_177977_b()));
        entry.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)northVec.func_177977_b(), (Object)southVec));
        entry.put(RailShape.SOUTH_EAST, Pair.of((Object)southVec, (Object)eastVec));
        entry.put(RailShape.SOUTH_WEST, Pair.of((Object)southVec, (Object)westVec));
        entry.put(RailShape.NORTH_WEST, Pair.of((Object)northVec, (Object)westVec));
        entry.put(RailShape.NORTH_EAST, Pair.of((Object)northVec, (Object)eastVec));
    });

    public MinecoloniesMinecart(EntityType<?> type, World world) {
        super(type, world);
    }

    protected void func_180460_a(BlockPos pos, BlockState state) {
        double tempVeloc;
        Vec3d tempMot;
        double xzDif;
        Entity entity;
        this.field_70143_R = 0.0f;
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        Vec3d posVec = this.func_70489_a(x, y, z);
        y = pos.func_177956_o();
        boolean isPowered = false;
        boolean flag = false;
        AbstractRailBlock abstractrailblock = (AbstractRailBlock)state.func_177230_c();
        if (abstractrailblock instanceof PoweredRailBlock && !((PoweredRailBlock)abstractrailblock).isActivatorRail()) {
            isPowered = (Boolean)state.func_177229_b((IProperty)PoweredRailBlock.field_176569_M);
            flag = !isPowered;
        }
        RailShape railshape = ((AbstractRailBlock)state.func_177230_c()).getRailDirection(state, (IBlockReader)this.field_70170_p, pos, (AbstractMinecartEntity)this);
        switch (railshape) {
            case ASCENDING_EAST: 
            case ASCENDING_WEST: 
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                y += 1.0;
                break;
            }
        }
        Vec3d motion = this.func_213322_ci();
        Pair<Vec3i, Vec3i> pair = MinecoloniesMinecart.getShapeMatrix(railshape);
        Vec3i vecIn = (Vec3i)pair.getFirst();
        Vec3i vecOut = (Vec3i)pair.getSecond();
        double xDif = vecOut.func_177958_n() - vecIn.func_177958_n();
        double zDif = vecOut.func_177952_p() - vecIn.func_177952_p();
        double difSq = Math.sqrt(xDif * xDif + zDif * zDif);
        double difMotion = motion.field_72450_a * xDif + motion.field_72449_c * zDif;
        if (difMotion < 0.0) {
            xDif = -xDif;
            zDif = -zDif;
        }
        double veloc = Math.min(2.0, Math.sqrt(MinecoloniesMinecart.func_213296_b((Vec3d)motion)));
        motion = new Vec3d(veloc * xDif / difSq, motion.field_72448_b, veloc * zDif / difSq);
        this.func_213317_d(motion);
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (entity instanceof PlayerEntity) {
            Vec3d mot = entity.func_213322_ci();
            double horMot = MinecoloniesMinecart.func_213296_b((Vec3d)mot);
            double tempMot2 = MinecoloniesMinecart.func_213296_b((Vec3d)this.func_213322_ci());
            if (horMot > 1.0E-4 && tempMot2 < 0.01) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(mot.field_72450_a * 0.1, 0.0, mot.field_72449_c * 0.1));
                flag = false;
            }
        }
        if (flag && this.shouldDoRailFunctions()) {
            double tempMot3 = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vec3d)this.func_213322_ci()));
            if (tempMot3 < 0.03) {
                this.func_213317_d(Vec3d.field_186680_a);
            } else {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, 0.0, 0.5));
            }
        }
        double xInDif = (double)pos.func_177958_n() + 0.5 + (double)vecIn.func_177958_n() * 0.5;
        double zInDif = (double)pos.func_177952_p() + 0.5 + (double)vecIn.func_177952_p() * 0.5;
        double xOutDif = (double)pos.func_177958_n() + 0.5 + (double)vecOut.func_177958_n() * 0.5;
        double zOutDif = (double)pos.func_177952_p() + 0.5 + (double)vecOut.func_177952_p() * 0.5;
        xDif = xOutDif - xInDif;
        zDif = zOutDif - zInDif;
        if (xDif == 0.0) {
            xzDif = z - (double)pos.func_177952_p();
        } else if (zDif == 0.0) {
            xzDif = x - (double)pos.func_177958_n();
        } else {
            double d15 = x - xInDif;
            double d16 = z - zInDif;
            xzDif = (d15 * xDif + d16 * zDif) * 2.0;
        }
        x = xInDif + xDif * xzDif;
        z = zInDif + zDif * xzDif;
        this.func_70107_b(x, y, z);
        this.moveMinecartOnRail(pos);
        if (vecIn.func_177956_o() != 0 && MathHelper.func_76128_c((double)this.func_226277_ct_()) - pos.func_177958_n() == vecIn.func_177958_n() && MathHelper.func_76128_c((double)this.func_226281_cx_()) - pos.func_177952_p() == vecIn.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)vecIn.func_177956_o(), this.func_226281_cx_());
        } else if (vecOut.func_177956_o() != 0 && MathHelper.func_76128_c((double)this.func_226277_ct_()) - pos.func_177958_n() == vecOut.func_177958_n() && MathHelper.func_76128_c((double)this.func_226281_cx_()) - pos.func_177952_p() == vecOut.func_177952_p()) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + (double)vecOut.func_177956_o(), this.func_226281_cx_());
        }
        this.func_94101_h();
        Vec3d newPos = this.func_70489_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        if (newPos != null && posVec != null) {
            double yMot = (posVec.field_72448_b - newPos.field_72448_b) * 0.05;
            tempMot = this.func_213322_ci();
            tempVeloc = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vec3d)tempMot));
            if (tempVeloc > 0.0) {
                this.func_213317_d(tempMot.func_216372_d((tempVeloc + yMot) / tempVeloc, 1.0, (tempVeloc + yMot) / tempVeloc));
            }
            this.func_70107_b(this.func_226277_ct_(), newPos.field_72448_b, this.func_226281_cx_());
        }
        int xFloor = MathHelper.func_76128_c((double)this.func_226277_ct_());
        int zFloor = MathHelper.func_76128_c((double)this.func_226281_cx_());
        if (xFloor != pos.func_177958_n() || zFloor != pos.func_177952_p()) {
            tempMot = this.func_213322_ci();
            double temoVeloc = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vec3d)tempMot));
            this.func_213293_j(temoVeloc * (double)(xFloor - pos.func_177958_n()), tempMot.field_72448_b, temoVeloc * (double)(zFloor - pos.func_177952_p()));
        }
        if (this.shouldDoRailFunctions()) {
            ((AbstractRailBlock)state.func_177230_c()).onMinecartPass(state, this.field_70170_p, pos, (AbstractMinecartEntity)this);
        }
        if (isPowered && this.shouldDoRailFunctions()) {
            tempMot = this.func_213322_ci();
            tempVeloc = Math.sqrt(MinecoloniesMinecart.func_213296_b((Vec3d)tempMot));
            if (tempVeloc > 0.01) {
                this.func_213317_d(tempMot.func_72441_c(tempMot.field_72450_a / tempVeloc * 0.06, 0.0, tempMot.field_72449_c / tempVeloc * 0.06));
            } else {
                Vec3d mot = this.func_213322_ci();
                double tempX = mot.field_72450_a;
                double tempZ = mot.field_72449_c;
                if (railshape == RailShape.EAST_WEST) {
                    if (this.isNormalCube(pos.func_177976_e())) {
                        tempX = 0.02;
                    } else if (this.isNormalCube(pos.func_177974_f())) {
                        tempX = -0.02;
                    }
                } else {
                    if (railshape != RailShape.NORTH_SOUTH) {
                        return;
                    }
                    if (this.isNormalCube(pos.func_177978_c())) {
                        tempZ = 0.02;
                    } else if (this.isNormalCube(pos.func_177968_d())) {
                        tempZ = -0.02;
                    }
                }
                this.func_213293_j(tempX, mot.field_72448_b, tempZ);
            }
        }
    }

    private boolean isNormalCube(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_215686_e((IBlockReader)this.field_70170_p, pos);
    }

    private static Pair<Vec3i, Vec3i> getShapeMatrix(RailShape p_226573_0_) {
        return MATRIX.get(p_226573_0_);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70114_g(@NotNull Entity entityIn) {
        return null;
    }

    public boolean func_70067_L() {
        return false;
    }

    @NotNull
    public AbstractMinecartEntity.Type func_184264_v() {
        return AbstractMinecartEntity.Type.RIDEABLE;
    }

    public void func_70108_f(@NotNull Entity entityIn) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 19 && this.func_184188_bt().isEmpty()) {
            this.func_70106_y();
        }
    }

    @NotNull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

