/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.client.render.modeltype.IModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.SoundUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ShieldItem;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityCitizen
extends AbstractCivilianEntity
implements INamedContainerProvider {
    private Map<String, String> textureMapping = new HashMap<String, String>();
    public static final DataParameter<Integer> DATA_LEVEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_TEXTURE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_IS_FEMALE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_COLONY_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_CITIZEN_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> DATA_MODEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_RENDER_METADATA = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> DATA_IS_ASLEEP = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> DATA_IS_CHILD = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<BlockPos> DATA_BED_POS = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<String> DATA_STYLE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_TEXTURE_SUFFIX = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    private IModelType modelId = BipedModelType.SETTLER;
    private int textureId;
    private String renderMetadata = "";
    private boolean female;
    private ResourceLocation texture;
    private boolean textureDirty = true;
    private AbstractAdvancedPathNavigate pathNavigate;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;

    public AbstractEntityCitizen(EntityType<? extends AgeableEntity> type, World world) {
        super(type, world);
    }

    public GoalSelector getTasks() {
        return this.field_70714_bg;
    }

    public int getTicksExisted() {
        return this.field_70173_aa;
    }

    public Entity changeDimension(DimensionType dimensionIn, ITeleporter teleporter) {
        return null;
    }

    @NotNull
    public BlockPos func_180425_c() {
        return new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public boolean func_98052_bS() {
        return true;
    }

    public float getPreviousRotationPitch() {
        return this.field_70127_C;
    }

    public float getPreviousRotationYaw() {
        return this.field_70126_B;
    }

    public float getPreviousRenderYawOffset() {
        return this.field_70760_ar;
    }

    public float getRenderYawOffset() {
        return this.field_70761_aq;
    }

    public double getPreviousPosX() {
        return this.field_70169_q;
    }

    public double getPreviousPosY() {
        return this.field_70167_r;
    }

    public double getPreviousPosZ() {
        return this.field_70166_s;
    }

    @NotNull
    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (!player.field_70170_p.func_201670_d()) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this), this.func_180425_c(), EventType.INTERACTION, this.getCitizenData());
        }
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void setTexture() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            return;
        }
        this.texture = this.getModelType().getTexture(this);
        this.textureDirty = false;
    }

    public abstract ICitizenDataView getCitizenDataView();

    @NotNull
    public ResourceLocation getTexture() {
        String renderMeta = this.getRenderMetadata();
        if (this.texture == null || this.textureDirty || !this.texture.func_110623_a().contains(renderMeta) || !this.texture.func_110623_a().contains(this.textureMapping.getOrDefault(this.func_184212_Q().func_187225_a(DATA_STYLE), "default")) || !this.texture.func_110623_a().contains((CharSequence)this.func_184212_Q().func_187225_a(DATA_TEXTURE_SUFFIX))) {
            this.setTexture();
        }
        return this.texture;
    }

    public void setTextureDirty() {
        this.textureDirty = true;
    }

    public void setTextureMapping(String style, String used) {
        this.textureMapping.put(style, used);
    }

    public IModelType getModelType() {
        return this.modelId;
    }

    @Nullable
    public AgeableEntity func_90011_a(@NotNull AgeableEntity child) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TEXTURE_SUFFIX, (Object)"_b");
        this.field_70180_af.func_187214_a(DATA_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(DATA_STYLE, (Object)"default");
        this.field_70180_af.func_187214_a(DATA_IS_FEMALE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_MODEL, (Object)BipedModelType.SETTLER.name());
        this.field_70180_af.func_187214_a(DATA_RENDER_METADATA, (Object)"");
        this.field_70180_af.func_187214_a(DATA_IS_ASLEEP, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_CHILD, (Object)false);
        this.field_70180_af.func_187214_a(DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigator() {
        if (this.pathNavigate == null) {
            this.pathNavigate = IPathNavigateRegistry.getInstance().getNavigateFor((MobEntity)this);
            this.field_70699_by = this.pathNavigate;
            this.pathNavigate.func_212239_d(true);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler().withTeleportOnFullStuck().withTeleportSteps(5));
        }
        return this.pathNavigate;
    }

    public void func_70108_f(@NotNull Entity entityIn) {
        if ((this.collisionCounter += 2) > 50) {
            if (this.collisionCounter > 100) {
                this.collisionCounter = 0;
            }
            return;
        }
        super.func_70108_f(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
    }

    public void setOwnRotation(float yaw, float pitch) {
        this.func_70101_b(yaw, pitch);
    }

    public void setModelId(IModelType model) {
        this.modelId = model;
    }

    public void setRenderMetadata(String renderMetadata) {
        if (renderMetadata.equals(this.getRenderMetadata())) {
            return;
        }
        this.renderMetadata = renderMetadata;
        this.field_70180_af.func_187227_b(DATA_RENDER_METADATA, (Object)this.getRenderMetadata());
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void setTextureId(int textureId) {
        this.textureId = textureId;
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)textureId);
    }

    public String getRenderMetadata() {
        return this.renderMetadata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
    }

    public Random getRandom() {
        return this.field_70146_Z;
    }

    public int getOffsetTicks() {
        return this.field_70173_aa + 7 * this.func_145782_y();
    }

    public boolean func_184585_cz() {
        return this.func_184607_cu().func_77973_b() instanceof ShieldItem;
    }

    public int getRecentlyHit() {
        return this.field_70718_bc;
    }

    protected void func_184231_a(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
        if (!this.field_70122_E) {
            int px = MathHelper.func_76128_c((double)this.func_226277_ct_());
            int py = (int)this.func_226278_cu_();
            int pz = MathHelper.func_76128_c((double)this.func_226281_cx_());
            this.field_70122_E = CompatibilityUtils.getWorldFromCitizen(this).func_180495_p(new BlockPos(px, py, pz)).func_177230_c().isLadder(this.field_70170_p.func_180495_p(new BlockPos(px, py, pz)), (IWorldReader)this.field_70170_p, new BlockPos(px, py, pz), (LivingEntity)this);
        }
        super.func_184231_a(y, onGroundIn, state, pos);
    }

    public void updateArmSwingProg() {
        this.func_82168_bl();
    }

    public boolean checkCanDropLoot() {
        return this.func_146066_aG();
    }

    public abstract ILocation getLocation();

    public abstract boolean isWorkerAtSiteWithMove(@NotNull BlockPos var1, int var2);

    @Nullable
    public abstract ICitizenData getCitizenData();

    @NotNull
    public abstract InventoryCitizen getInventoryCitizen();

    @NotNull
    public abstract IItemHandler getItemHandlerCitizen();

    @NotNull
    public abstract DesiredActivity getDesiredActivity();

    public abstract void setCitizensize(@NotNull float var1, @NotNull float var2);

    public abstract void setIsChild(boolean var1);

    public abstract void playMoveAwaySound();

    public abstract IWalkToProxy getProxy();

    public abstract void decreaseSaturationForAction();

    public abstract void decreaseSaturationForContinuousAction();

    public abstract ICitizenExperienceHandler getCitizenExperienceHandler();

    public abstract ICitizenChatHandler getCitizenChatHandler();

    public abstract ICitizenStatusHandler getCitizenStatusHandler();

    public abstract ICitizenItemHandler getCitizenItemHandler();

    public abstract ICitizenInventoryHandler getCitizenInventoryHandler();

    public abstract void setCitizenInventoryHandler(ICitizenInventoryHandler var1);

    public abstract ICitizenColonyHandler getCitizenColonyHandler();

    public abstract void setCitizenColonyHandler(ICitizenColonyHandler var1);

    public abstract ICitizenJobHandler getCitizenJobHandler();

    public abstract ICitizenSleepHandler getCitizenSleepHandler();

    public abstract ICitizenDiseaseHandler getCitizenDiseaseHandler();

    public abstract void setCitizenDiseaseHandler(ICitizenDiseaseHandler var1);

    public abstract boolean isOkayToEat();

    public abstract boolean shouldBeFed();

    public abstract boolean isIdlingAtJob();

    public abstract boolean isMourning();

    public abstract void setMourning(boolean var1);

    public abstract float getRotationYaw();

    public abstract float getRotationPitch();

    public abstract boolean isDead();

    public abstract void setCitizenSleepHandler(ICitizenSleepHandler var1);

    public abstract void setCitizenJobHandler(ICitizenJobHandler var1);

    public abstract void setCitizenItemHandler(ICitizenItemHandler var1);

    public abstract void setCitizenChatHandler(ICitizenChatHandler var1);

    public abstract void setCitizenExperienceHandler(ICitizenExperienceHandler var1);

    public abstract boolean isCurrentlyFleeing();

    public abstract void callForHelp(Entity var1, int var2);

    public abstract void setFleeingState(boolean var1);

    public void updatePose(Pose pose) {
        this.func_213301_b(pose);
    }
}

