/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs;

import com.google.common.collect.Multimap;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMob;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.api.entity.mobs.barbarians.IChiefBarbarianEntity;
import com.minecolonies.api.entity.mobs.barbarians.IMeleeBarbarianEntity;
import com.minecolonies.api.entity.mobs.egyptians.IPharaoEntity;
import com.minecolonies.api.entity.mobs.pirates.ICaptainPirateEntity;
import com.minecolonies.api.entity.mobs.pirates.IPirateEntity;
import com.minecolonies.api.entity.mobs.vikings.IMeleeNorsemenEntity;
import com.minecolonies.api.entity.mobs.vikings.INorsemenChiefEntity;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class RaiderMobUtils {
    public static double MOB_SPAWN_DEVIATION_STEPS = 0.3;
    public static final IAttribute MOB_ATTACK_DAMAGE = new RangedAttribute(null, "mc_mob_damage", 2.0, 1.0, 20.0);
    public static int DAMAGE_PER_X_RAID_LEVEL = 400;
    public static int MAX_RAID_LEVEL_DAMAGE = 3;

    private RaiderMobUtils() {
        throw new IllegalStateException("Tried to initialize: MobSpawnUtils but this is a Utility class.");
    }

    public static void setupMobAi(AbstractEntityMinecoloniesMob mob) {
        Multimap<Integer, Goal> aiTasks = IMinecoloniesAPI.getInstance().getMobAIRegistry().getEntityAiTasksForMobs(mob);
        aiTasks.keySet().forEach(priority -> aiTasks.get(priority).forEach(task -> mob.field_70714_bg.func_75776_a(priority.intValue(), task)));
        Multimap<Integer, Goal> aiTargetTasks = IMinecoloniesAPI.getInstance().getMobAIRegistry().getEntityAiTargetTasksForMobs(mob);
        aiTargetTasks.keySet().forEach(priority -> aiTargetTasks.get(priority).forEach(task -> mob.field_70715_bh.func_75776_a(priority.intValue(), task)));
    }

    public static void setMobAttributes(AbstractEntityMinecoloniesMob mob, IColony colony) {
        double difficultyModifier = colony.getRaiderManager().getRaidDifficultyModifier();
        mob.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(70.0);
        mob.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(difficultyModifier < 2.4 ? 0.25 : 0.3);
        int raidLevel = colony.getRaiderManager().getColonyRaidLevel();
        double attackDamage = 2.0 + difficultyModifier * (double)Math.min(raidLevel / DAMAGE_PER_X_RAID_LEVEL, MAX_RAID_LEVEL_DAMAGE);
        double baseHealth = RaiderMobUtils.getHealthBasedOnRaidLevel(raidLevel) * difficultyModifier;
        mob.initStatsFor(baseHealth, difficultyModifier, attackDamage);
    }

    public static double getHealthBasedOnRaidLevel(int raidLevel) {
        return Math.max(10.0, 10.0 + (double)raidLevel * 0.025);
    }

    public static void spawn(EntityType<?> entityToSpawn, int numberOfSpawns, BlockPos spawnLocation, World world, IColony colony, int eventID) {
        if (spawnLocation != null && entityToSpawn != null && world != null && numberOfSpawns > 0) {
            int x = spawnLocation.func_177958_n();
            int y = BlockPosUtil.getFloor(spawnLocation, world).func_177956_o();
            int z = spawnLocation.func_177952_p();
            double spawnDeviationX = 0.0;
            double spawnDeviationZ = 0.0;
            for (int i = 0; i < numberOfSpawns; ++i) {
                AbstractEntityMinecoloniesMob entity = (AbstractEntityMinecoloniesMob)entityToSpawn.func_200721_a(world);
                if (entity == null) continue;
                entity.func_70080_a((double)x + spawnDeviationX, (double)y + 1.0, (double)z + spawnDeviationZ, (float)MathHelper.func_76138_g((double)(world.field_73012_v.nextDouble() * 360.0)), 0.0f);
                CompatibilityUtils.addEntity(world, (Entity)entity);
                entity.setColony(colony);
                entity.setEventID(eventID);
                entity.registerWithColony();
                spawnDeviationZ += MOB_SPAWN_DEVIATION_STEPS;
                if (!(spawnDeviationZ > 2.0)) continue;
                spawnDeviationZ = 0.0;
                spawnDeviationX += MOB_SPAWN_DEVIATION_STEPS;
            }
        }
    }

    public static void setEquipment(AbstractEntityMinecoloniesMob mob) {
        if (mob instanceof IMeleeBarbarianEntity || mob instanceof IMeleeNorsemenEntity || mob instanceof INorsemenChiefEntity) {
            mob.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151049_t));
        } else if (mob instanceof IPharaoEntity) {
            mob.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.pharaoscepter));
        } else if (mob instanceof IArcherMobEntity) {
            mob.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151031_f));
        } else if (mob instanceof IChiefBarbarianEntity) {
            mob.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.chiefSword));
            mob.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151020_U));
            mob.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151023_V));
            mob.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151022_W));
            mob.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151029_X));
        } else if (mob instanceof IPirateEntity) {
            mob.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.scimitar));
            if (mob instanceof ICaptainPirateEntity) {
                if (new Random().nextBoolean()) {
                    mob.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.pirateHelmet_1));
                    mob.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModItems.pirateChest_1));
                    mob.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)ModItems.pirateLegs_1));
                    mob.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)ModItems.pirateBoots_1));
                } else {
                    mob.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.pirateHelmet_2));
                    mob.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModItems.pirateChest_2));
                    mob.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)ModItems.pirateLegs_2));
                    mob.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)ModItems.pirateBoots_2));
                }
            }
        }
    }

    public static List<AbstractEntityMinecoloniesMob> getBarbariansCloseToEntity(Entity entity, double distanceFromEntity) {
        return CompatibilityUtils.getWorldFromEntity(entity).func_175647_a(AbstractEntityMinecoloniesMob.class, entity.func_174813_aQ().func_72321_a(distanceFromEntity, 3.0, distanceFromEntity), Entity::func_70089_S);
    }
}

