/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.api;

import com.minecolonies.api.inventory.api.IWorldNameableModifiable;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CombinedItemHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundNBT>,
IWorldNameableModifiable {
    private static final String NBT_KEY_HANDLERS = "Handlers";
    private static final String NBT_KEY_HANDLERS_INDEXLIST = "Index";
    private static final String NBT_KEY_NAME = "Name";
    private final IItemHandlerModifiable[] handlers;
    @NotNull
    private String defaultName = "";
    @NotNull
    private String customName = "";

    public CombinedItemHandler(@NotNull String defaultName, IItemHandlerModifiable ... handlers) {
        this.handlers = handlers;
        this.defaultName = defaultName;
    }

    public CombinedItemHandler(@NotNull String defaultName, @NotNull String customName, IItemHandlerModifiable ... handlers) {
        this.handlers = handlers;
        this.customName = customName;
        this.defaultName = defaultName;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        int index = 0;
        ListNBT handlerList = new ListNBT();
        ListNBT indexList = new ListNBT();
        for (IItemHandlerModifiable handlerModifiable : this.handlers) {
            if (handlerModifiable instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)handlerModifiable;
                handlerList.add((Object)serializable.serializeNBT());
                indexList.add((Object)IntNBT.func_229692_a_((int)index));
            }
            ++index;
        }
        compound.func_218657_a(NBT_KEY_HANDLERS, (INBT)handlerList);
        compound.func_218657_a(NBT_KEY_HANDLERS_INDEXLIST, (INBT)indexList);
        if (this.customName != null) {
            compound.func_74778_a(NBT_KEY_NAME, this.customName);
        }
        return compound;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        ListNBT handlerList = nbt.func_150295_c(NBT_KEY_NAME, 10);
        ListNBT indexList = nbt.func_150295_c(NBT_KEY_HANDLERS_INDEXLIST, 3);
        if (handlerList.size() == this.handlers.length) {
            for (int i = 0; i < handlerList.size(); ++i) {
                CompoundNBT handlerCompound = handlerList.func_150305_b(i);
                IItemHandlerModifiable modifiable = this.handlers[indexList.func_186858_c(i)];
                if (!(modifiable instanceof INBTSerializable)) continue;
                INBTSerializable serializable = (INBTSerializable)modifiable;
                serializable.deserializeNBT((INBT)handlerCompound);
            }
        }
        this.setName(nbt.func_150296_c().contains(NBT_KEY_NAME) ? nbt.func_74779_i(NBT_KEY_NAME) : null);
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                modifiable.setStackInSlot(activeSlot, stack);
                return;
            }
            activeSlot -= modifiable.getSlots();
        }
    }

    public int getLastIndex(int slot) {
        int slots = 0;
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.getSlots() + slots;
            }
            slots += modifiable.getSlots();
            activeSlot -= modifiable.getSlots();
        }
        return 0;
    }

    public int getSlots() {
        int sum = 0;
        for (IItemHandlerModifiable handler : this.handlers) {
            if (handler == null) continue;
            sum += handler.getSlots();
        }
        return sum;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.getStackInSlot(activeSlot);
            }
            activeSlot -= modifiable.getSlots();
        }
        return ItemStack.field_190927_a;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        int activeSlot = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (activeSlot < modifiable.getSlots()) {
                return modifiable.insertItem(activeSlot, stack, simulate);
            }
            activeSlot -= modifiable.getSlots();
        }
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int checkedSlots = 0;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (modifiable.getSlots() + checkedSlots <= slot) {
                checkedSlots += modifiable.getSlots();
                continue;
            }
            int activeSlot = slot - checkedSlots;
            if (activeSlot >= modifiable.getSlots()) continue;
            return modifiable.extractItem(activeSlot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        int slotIndex = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (slotIndex >= modifiable.getSlots()) {
                slotIndex -= modifiable.getSlots();
                continue;
            }
            return modifiable.getSlotLimit(slotIndex);
        }
        return 0;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        int slotIndex = slot;
        for (IItemHandlerModifiable modifiable : this.handlers) {
            if (slotIndex >= modifiable.getSlots()) {
                slotIndex -= modifiable.getSlots();
                continue;
            }
            return modifiable.isItemValid(slotIndex, stack);
        }
        return false;
    }

    protected IItemHandlerModifiable[] getHandlers() {
        return (IItemHandlerModifiable[])this.handlers.clone();
    }

    @Override
    public void setName(@Nullable String name) {
        this.customName = name == null ? "" : name;
    }

    @NotNull
    public ITextComponent func_200200_C_() {
        return new StringTextComponent(this.customName.isEmpty() ? this.defaultName : this.customName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CombinedItemHandler that = (CombinedItemHandler)o;
        if (this.handlers.length != that.handlers.length) {
            return false;
        }
        int length = this.handlers.length;
        for (int i = 0; i < length; ++i) {
            if (this.handlers[i] == that.handlers[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Arrays.hashCode(this.handlers);
    }
}

