/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryFunctions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTileEntityColonyBuilding
extends TileEntityRack
implements IBlueprintDataProvider {
    private BlockPos corner1 = BlockPos.field_177992_a;
    private BlockPos corner2 = BlockPos.field_177992_a;
    private String schematicName = "";
    private Map<BlockPos, List<String>> tagPosMap = new HashMap<BlockPos, List<String>>();

    public AbstractTileEntityColonyBuilding(TileEntityType<? extends AbstractTileEntityColonyBuilding> type) {
        super((TileEntityType<? extends TileEntityRack>)type);
    }

    public static boolean isInTileEntity(ICapabilityProvider entity, @NotNull Predicate<ItemStack> itemStackSelectionPredicate) {
        return InventoryFunctions.matchFirstInProvider(entity, itemStackSelectionPredicate);
    }

    public abstract int getColonyId();

    public abstract IColony getColony();

    public abstract void setColony(IColony var1);

    public abstract BlockPos getPosition();

    @Nullable
    public abstract BlockPos getPositionOfChestWithItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract IBuildingContainer getBuilding();

    public abstract void setBuilding(IBuildingContainer var1);

    public abstract IBuildingView getBuildingView();

    public abstract boolean hasAccessPermission(PlayerEntity var1);

    public abstract void setMirror(boolean var1);

    public abstract boolean isMirrored();

    public abstract String getStyle();

    public abstract void setStyle(String var1);

    public abstract ResourceLocation getBuildingName();

    public String getSchematicName() {
        return this.schematicName;
    }

    public void setSchematicName(String name) {
        this.schematicName = name;
    }

    public Map<BlockPos, List<String>> getPositionedTags() {
        return this.tagPosMap;
    }

    public void setPositionedTags(Map<BlockPos, List<String>> positionedTags) {
        this.tagPosMap = positionedTags;
    }

    public Tuple<BlockPos, BlockPos> getCornerPositions() {
        if (this.corner1 == BlockPos.field_177992_a || this.corner2 == BlockPos.field_177992_a) {
            return new Tuple((Object)this.field_174879_c, (Object)this.field_174879_c);
        }
        return new Tuple((Object)this.corner1, (Object)this.corner2);
    }

    public void setCorners(BlockPos pos1, BlockPos pos2) {
        this.corner1 = pos1;
        this.corner2 = pos2;
    }

    @Override
    public void func_145839_a(@NotNull CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readSchematicDataFromNBT(compound);
    }

    @Override
    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        super.func_189515_b(compound);
        this.writeSchematicDataToNBT(compound);
        return compound;
    }

    public BlockPos getTilePos() {
        return this.field_174879_c;
    }
}

