/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityColonyFlag
extends TileEntity {
    private ListNBT flag = new ListNBT();
    private ListNBT patterns = new ListNBT();
    public int colonyId = -1;

    public TileEntityColonyFlag() {
        super(MinecoloniesTileEntities.COLONY_FLAG);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("colonyflag", (INBT)this.flag);
        compound.func_218657_a("Patterns", (INBT)this.patterns);
        compound.func_74768_a("colony", this.colonyId);
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.flag = compound.func_150295_c("colonyflag", 10);
        this.patterns = compound.func_150295_c("Patterns", 10);
        this.colonyId = compound.func_74762_e("colony");
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 6, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        CompoundNBT compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<BannerPattern, DyeColor>> getPatternList() {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.field_145850_b.field_73011_w.func_186058_p().func_186068_a());
        if (colony != null && this.flag != colony.getColonyFlag()) {
            this.flag = colony.getColonyFlag();
            this.func_70296_d();
        }
        return BannerTileEntity.func_230138_a_((DyeColor)DyeColor.WHITE, (ListNBT)(this.flag.size() > 1 ? this.flag : this.patterns));
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        ItemStack itemstack = new ItemStack(ModBlocks.blockColonyBanner);
        List<Pair<BannerPattern, DyeColor>> list = this.getPatternList();
        ListNBT nbt = new ListNBT();
        for (Pair<BannerPattern, DyeColor> pair : list) {
            CompoundNBT pairNBT = new CompoundNBT();
            pairNBT.func_74778_a("Pattern", ((BannerPattern)pair.getFirst()).func_190993_b());
            pairNBT.func_74768_a("Color", ((DyeColor)pair.getSecond()).func_196059_a());
            nbt.add((Object)pairNBT);
        }
        if (!nbt.isEmpty()) {
            itemstack.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)nbt);
        }
        return itemstack;
    }
}

