/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.Log;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;

public class ModTagsInitializer {
    private static final String REDUCEABLE = "reduceable";
    private static final String PRODUCT = "_product";
    private static final String PRODUCT_EXCLUDED = "_product_excluded";
    private static final String INGREDIENT = "_ingredient";
    private static final String INGREDIENT_EXCLUDED = "_ingredient_excluded";
    private static final ResourceLocation DECORATION_ITEMS = new ResourceLocation("minecolonies", "decoblocks");
    private static final ResourceLocation CONCRETE_POWDER = new ResourceLocation("minecolonies", "concrete_powder");
    private static final ResourceLocation CONCRETE_BLOCK = new ResourceLocation("minecolonies", "concrete");
    private static final ResourceLocation PATHING_BLOCKS = new ResourceLocation("minecolonies", "pathblocks");
    private static boolean loaded = false;

    public static void init() {
        if (loaded) {
            return;
        }
        loaded = true;
        ModTags.decorationItems = ModTagsInitializer.getBlockTags(DECORATION_ITEMS);
        ModTags.concretePowder = ModTagsInitializer.getItemTags(CONCRETE_POWDER);
        ModTags.concreteBlock = ModTagsInitializer.getBlockTags(CONCRETE_BLOCK);
        ModTags.pathingBlocks = ModTagsInitializer.getBlockTags(PATHING_BLOCKS);
        ModTagsInitializer.initCrafterRules("baker");
        ModTagsInitializer.initCrafterRules("blacksmith");
        ModTagsInitializer.initCrafterRules("chickenherder");
        ModTagsInitializer.initCrafterRules("concretemixer");
        ModTagsInitializer.initCrafterRules("cook");
        ModTagsInitializer.initCrafterRules("cowboy");
        ModTagsInitializer.initCrafterRules("crusher");
        ModTagsInitializer.initCrafterRules("dyer");
        ModTagsInitializer.initCrafterRules("farmer");
        ModTagsInitializer.initCrafterRules("fisherman");
        ModTagsInitializer.initCrafterRules("fletcher");
        ModTagsInitializer.initCrafterRules("glassblower");
        ModTagsInitializer.initCrafterRules("lumberjack");
        ModTagsInitializer.initCrafterRules("mechanic");
        ModTagsInitializer.initCrafterRules("plantation");
        ModTagsInitializer.initCrafterRules("rabbithutch");
        ModTagsInitializer.initCrafterRules("sawmill");
        ModTagsInitializer.initCrafterRules("shepherd");
        ModTagsInitializer.initCrafterRules("smelter");
        ModTagsInitializer.initCrafterRules("stonemason");
        ModTagsInitializer.initCrafterRules("stonesmeltery");
        ModTagsInitializer.initCrafterRules("swineherder");
        ModTagsInitializer.initCrafterRules(REDUCEABLE);
        Log.getLogger().info("Tags Loaded");
    }

    private static void initCrafterRules(String crafterName) {
        String lowerName = crafterName.toLowerCase();
        ResourceLocation products = new ResourceLocation("minecolonies", lowerName.concat(PRODUCT));
        ResourceLocation ingredients = new ResourceLocation("minecolonies", lowerName.concat(INGREDIENT));
        ResourceLocation productsExcluded = new ResourceLocation("minecolonies", lowerName.concat(PRODUCT_EXCLUDED));
        ResourceLocation ingredientsExcluded = new ResourceLocation("minecolonies", lowerName.concat(INGREDIENT_EXCLUDED));
        ModTags.crafterProduct.put(lowerName, ModTagsInitializer.getItemTags(products));
        ModTags.crafterProductExclusions.put(lowerName, ModTagsInitializer.getItemTags(productsExcluded));
        ModTags.crafterIngredient.put(lowerName, ModTagsInitializer.getItemTags(ingredients));
        ModTags.crafterIngredientExclusions.put(lowerName, ModTagsInitializer.getItemTags(ingredientsExcluded));
    }

    private static Tag<Item> getItemTags(ResourceLocation resourceLocation) {
        return ItemTags.func_199903_a().func_199915_b(resourceLocation);
    }

    private static Tag<Block> getBlockTags(ResourceLocation resourceLocation) {
        return BlockTags.func_199896_a().func_199915_b(resourceLocation);
    }
}

