/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.coremod.client.gui.AbstractHutFilterableLists;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ViewFilterableList {
    private static final String INPUT_NAME = "input";
    public static final String DESC_LABEL = "desc";
    public static final String BUTTON_SWITCH = "switch";
    public static final String ON = LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]);
    public static final String OFF = LanguageHandler.format((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]);
    private final List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList resourceList;
    protected final AbstractFilterableListsView building;
    private final AbstractHutFilterableLists parent;
    private String filter = "";
    private final boolean isInverted;
    private final View window;
    private final String id;

    public ViewFilterableList(View window, AbstractHutFilterableLists parent, AbstractFilterableListsView building, String desc, String id, boolean isInverted) {
        this.window = window;
        this.id = id;
        this.resourceList = (ScrollingList)window.findPaneOfTypeByID("resources", ScrollingList.class);
        ((Label)window.findPaneOfTypeByID(DESC_LABEL, Label.class)).setLabelText(desc);
        this.building = building;
        this.isInverted = isInverted;
        this.parent = parent;
    }

    public void onButtonClick(Button button) {
        if (Objects.equals(button.getID(), BUTTON_SWITCH)) {
            this.switchClicked(button);
        }
    }

    private void switchClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        if (button.getLabel().equals(ON)) {
            button.setLabel(OFF);
            if (this.isInverted) {
                this.building.addItem(this.id, this.allItems.get(row));
            } else {
                this.building.removeItem(this.id, this.allItems.get(row));
            }
        } else {
            button.setLabel(ON);
            if (this.isInverted) {
                this.building.removeItem(this.id, this.allItems.get(row));
            } else {
                this.building.addItem(this.id, this.allItems.get(row));
            }
        }
        this.resourceList.refreshElementPanes();
    }

    public void onOpened() {
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_200301_q().func_150254_d().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.allItems.addAll(this.getExceptions().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList()));
        this.updateResourceList();
    }

    private Collection<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate) {
        return this.parent.getBlockList(filterPredicate, this.id);
    }

    private List<ItemStorage> getExceptions() {
        return Collections.emptyList();
    }

    public void onKeyTyped() {
        this.filter = ((TextField)this.window.findPaneOfTypeByID(INPUT_NAME, TextField.class)).getText();
        this.updateResources();
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<ItemStorage> tempRes = new ArrayList<ItemStorage>(this.allItems);
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ItemStorage)tempRes.get(index)).getItemStack();
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_200301_q().func_150254_d());
                resourceLabel.setColor(7, 7);
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
                Button switchButton = (Button)rowPane.findPaneOfTypeByID(ViewFilterableList.BUTTON_SWITCH, Button.class);
                if (ViewFilterableList.this.isInverted && !ViewFilterableList.this.building.isAllowedItem(ViewFilterableList.this.id, new ItemStorage(resource)) || !ViewFilterableList.this.isInverted && ViewFilterableList.this.building.isAllowedItem(ViewFilterableList.this.id, new ItemStorage(resource))) {
                    switchButton.setLabel(ON);
                } else {
                    switchButton.setLabel(OFF);
                }
            }
        });
    }
}

