/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.event.HighlightManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class WindowHutAllInventory
extends AbstractWindowSkeleton {
    List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList stackList;
    private String filter = "";
    private int sortDescriptor = 0;
    private final IBuildingView building;
    private final Window prev;

    public WindowHutAllInventory(IBuildingView b, Window prev) {
        super("minecolonies:gui/windowhutallinventory.xml");
        this.building = b;
        this.registerButton("sortStorageFilter", this::setSortFlag);
        this.registerButton("back", this::back);
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("allinventorylist", ScrollingList.class);
        this.updateResources();
        this.registerButton("locate", this::locate);
        this.prev = prev;
    }

    private void locate(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStorage storage = this.allItems.get(row);
        List<BlockPos> containerList = this.building.getContainerList();
        for (BlockPos blockPos : containerList) {
            TileEntity rack = Minecraft.func_71410_x().field_71441_e.func_175625_s(blockPos);
            if (!(rack instanceof TileEntityRack) || !((TileEntityRack)rack).hasItemStack(storage.getItemStack(), 1, false)) continue;
            HighlightManager.HIGHLIGHT_MAP.put("inventoryHighlight", new Tuple<BlockPos, Long>(blockPos, Minecraft.func_71410_x().field_71441_e.func_82737_E() + 2400L));
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.locating", new Object[0]));
            this.close();
            return;
        }
    }

    private void back() {
        this.close();
        this.prev.open();
    }

    private void setSortFlag() {
        ++this.sortDescriptor;
        if (this.sortDescriptor > 4) {
            this.sortDescriptor = 0;
        }
        switch (this.sortDescriptor) {
            case 0: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setLabel("v^");
                break;
            }
            case 1: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setLabel("A^");
                break;
            }
            case 2: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setLabel("Av");
                break;
            }
            case 3: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setLabel("1^");
                break;
            }
            case 4: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setLabel("1v");
                break;
            }
        }
        this.updateResources();
    }

    private void updateResources() {
        List<BlockPos> containerList = this.building.getContainerList();
        HashMap<ItemStorage, Integer> storedItems = new HashMap<ItemStorage, Integer>();
        World world = this.building.getColony().getWorld();
        containerList.add(this.building.getPosition());
        for (BlockPos blockPos : containerList) {
            TileEntity rack = world.func_175625_s(blockPos);
            if (!(rack instanceof TileEntityRack)) continue;
            Map<ItemStorage, Integer> rackStorage = ((TileEntityRack)rack).getAllContent();
            for (Map.Entry<ItemStorage, Integer> entry : rackStorage.entrySet()) {
                if (storedItems.containsKey(entry.getKey())) {
                    storedItems.put(entry.getKey(), (Integer)storedItems.get(entry.getKey()) + entry.getValue());
                    continue;
                }
                storedItems.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList filterItems = new ArrayList();
        storedItems.forEach((storage, amount) -> {
            storage.setAmount((int)amount);
            filterItems.add(storage);
        });
        Predicate<ItemStorage> filterPredicate = stack -> this.filter.isEmpty() || stack.getItemStack().func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getItemStack().func_200301_q().func_150254_d().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        if (this.filter.isEmpty()) {
            this.allItems.addAll(filterItems);
        } else {
            this.allItems.addAll(filterItems.stream().filter(filterPredicate).collect(Collectors.toList()));
        }
        Comparator<ItemStorage> compareByName = Comparator.comparing(o -> o.getItemStack().func_200301_q().func_150254_d());
        Comparator<ItemStorage> compareByCount = Comparator.comparingInt(ItemStorage::getAmount);
        switch (this.sortDescriptor) {
            case 0: {
                break;
            }
            case 1: {
                this.allItems.sort(compareByName);
                break;
            }
            case 2: {
                this.allItems.sort(compareByName.reversed());
                break;
            }
            case 3: {
                this.allItems.sort(compareByCount);
                break;
            }
            case 4: {
                this.allItems.sort(compareByCount.reversed());
                break;
            }
        }
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutAllInventory.this.allItems.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = WindowHutAllInventory.this.allItems.get(index);
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("ressourceStackName", Label.class);
                String name = resource.getItemStack().func_200301_q().func_150254_d();
                resourceLabel.setLabelText(name.substring(0, Math.min(17, name.length())));
                Label qtys = (Label)rowPane.findPaneOfTypeByID("quantities", Label.class);
                if (!Screen.hasShiftDown()) {
                    qtys.setLabelText(Utils.format(resource.getAmount()));
                } else {
                    qtys.setLabelText(Integer.toString(resource.getAmount()));
                }
                Item imagesrc = resource.getItemStack().func_77973_b();
                ItemStack image = new ItemStack((IItemProvider)imagesrc, 1);
                image.func_77982_d(resource.getItemStack().func_77978_p());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(image);
            }
        });
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        if (result) {
            this.filter = ((TextField)this.findPaneOfTypeByID("names", TextField.class)).getText();
            this.updateResources();
        }
        return result;
    }
}

