/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.View;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractHutFilterableLists;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.network.messages.server.colony.building.RemoveMinimumStockFromBuildingMessage;
import com.minecolonies.coremod.util.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class WindowHutCook
extends AbstractHutFilterableLists {
    private static final String RESOURCE_STRING = ":gui/windowhutcook.xml";
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private static final String PAGE_ITEMS_VIEW = "fuel";
    private final ScrollingList resourceList;

    public WindowHutCook(BuildingCook.View building) {
        super(building, "minecolonies:gui/windowhutcook.xml", new Tuple[0]);
        ViewFilterableList win = new ViewFilterableList((View)this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class), this, building, LanguageHandler.format((String)"com.minecolonies.coremod.request.burnable", (Object[])new Object[0]), PAGE_ITEMS_VIEW, false);
        this.views.put(PAGE_ITEMS_VIEW, win);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.registerButton("addStock", this::addStock);
        if (building.hasReachedLimit()) {
            ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
            button.setLabel(LanguageHandler.format((String)LABEL_LIMIT_REACHED, (Object[])new Object[0]));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_dark.png"));
        }
        this.registerButton("removeStock", this::removeStock);
    }

    @Override
    public List<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate, String id) {
        return ImmutableList.copyOf((Collection)IColonyManager.getInstance().getCompatibilityManager().getFuel().stream().filter(item -> filterPredicate.test(item.getItemStack())).collect(Collectors.toList()));
    }

    private void removeStock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        com.minecolonies.api.util.Tuple<ItemStorage, Integer> tuple = ((BuildingCook.View)this.building).getStock().get(row);
        ((BuildingCook.View)this.building).getStock().remove(row);
        Network.getNetwork().sendToServer(new RemoveMinimumStockFromBuildingMessage(this.building, tuple.getA().getItemStack()));
        this.updateStockList();
    }

    private void addStock() {
        if (!((BuildingCook.View)this.building).hasReachedLimit()) {
            new WindowSelectRes(this, this.building, itemStack -> ItemStackUtils.CAN_EAT.test((ItemStack)itemStack) || ItemStackUtils.CAN_EAT.test(FurnaceRecipes.getInstance().getSmeltingResult((ItemStack)itemStack))).open();
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<com.minecolonies.api.util.Tuple<ItemStorage, Integer>> tempRes = new ArrayList<com.minecolonies.api.util.Tuple<ItemStorage, Integer>>(((BuildingCook.View)this.building).getStock());
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ItemStorage)((com.minecolonies.api.util.Tuple)tempRes.get(index)).getA()).getItemStack().func_77946_l();
                resource.func_190920_e(resource.func_77976_d());
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_200301_q().func_150254_d());
                Label quantityLabel = (Label)rowPane.findPaneOfTypeByID("resourceQty", Label.class);
                quantityLabel.setLabelText(String.valueOf(((com.minecolonies.api.util.Tuple)tempRes.get(index)).getB()));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    @Override
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.cook";
    }
}

