/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.client.gui.WindowSelectRes;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.RemoveMinimumStockFromBuildingMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.warehouse.SortWarehouseMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.warehouse.UpgradeWarehouseMessage;
import java.util.ArrayList;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowHutWareHouse
extends AbstractWindowBuilding<BuildingWareHouse.View> {
    private final BuildingWareHouse.View building;
    private static final int BUILDING_LEVEL_FOR_SORTING = 3;
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private boolean allowMoreStorageUpgrades = false;
    private final ScrollingList resourceList;

    public WindowHutWareHouse(BuildingWareHouse.View building) {
        super(building, "minecolonies:gui/windowhutwarehouse.xml");
        this.building = building;
        this.registerButton("resourceAdd", this::transferItems);
        this.registerButton("sort", this::sortWarehouse);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        if (building.isBuildingMaxLevel() && building.canUpgradeStorage()) {
            this.allowMoreStorageUpgrades = true;
        }
        this.registerButton("addStock", this::addStock);
        if (building.hasReachedLimit()) {
            ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
            button.setLabel(LanguageHandler.format((String)LABEL_LIMIT_REACHED, (Object[])new Object[0]));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_dark.png"));
        }
        this.registerButton("removeStock", this::removeStock);
    }

    private void removeStock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        Tuple<ItemStorage, Integer> tuple = this.building.getStock().get(row);
        this.building.getStock().remove(row);
        Network.getNetwork().sendToServer(new RemoveMinimumStockFromBuildingMessage(this.building, tuple.getA().getItemStack()));
        this.updateStockList();
    }

    private void addStock() {
        if (!this.building.hasReachedLimit()) {
            new WindowSelectRes(this, this.building, stack -> true).open();
        }
    }

    @Override
    public void onOpened() {
        if (this.building.getBuildingLevel() < 3) {
            ((ButtonImage)this.findPaneOfTypeByID("sort", ButtonImage.class)).hide();
        }
        super.onOpened();
        this.updateResourcePane();
        this.updateStockList();
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.building));
    }

    private void updateResourcePane() {
        BuildingBuilderResource resource = new BuildingBuilderResource(new ItemStack((IItemProvider)Blocks.field_150475_bE, 1), 1);
        PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
        boolean isCreative = this.mc.field_71439_g.func_184812_l_();
        int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), resource.getItem());
        resource.setPlayerAmount(amountToSet);
        Label resourceLabel = (Label)this.findPaneOfTypeByID("resourceName", Label.class);
        Label resourceMissingLabel = (Label)this.findPaneOfTypeByID("resourceMissing", Label.class);
        Label neededLabel = (Label)this.findPaneOfTypeByID("resourceAvailableNeeded", Label.class);
        Button addButton = (Button)this.findPaneOfTypeByID("resourceAdd", Button.class);
        BuildingBuilderResource.RessourceAvailability availability = resource.getAvailabilityStatus();
        if (!this.allowMoreStorageUpgrades) {
            availability = BuildingBuilderResource.RessourceAvailability.NOT_NEEDED;
        }
        switch (availability) {
            case DONT_HAVE: {
                addButton.disable();
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case NEED_MORE: {
                addButton.enable();
                resourceLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                resourceMissingLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                neededLabel.setColor(WindowHutBuilder.RED, WindowHutBuilder.RED);
                break;
            }
            case HAVE_ENOUGH: {
                addButton.enable();
                resourceLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                resourceMissingLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                neededLabel.setColor(WindowHutBuilder.DARKGREEN, WindowHutBuilder.DARKGREEN);
                break;
            }
            default: {
                addButton.disable();
                resourceLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                resourceMissingLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
                neededLabel.setColor(WindowHutBuilder.BLACK, WindowHutBuilder.BLACK);
            }
        }
        resourceLabel.setLabelText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setLabelText(Integer.toString(missing));
        } else {
            resourceMissingLabel.setLabelText("");
        }
        neededLabel.setLabelText(resource.getAvailable() + " / " + resource.getAmount());
        ((Label)this.findPaneOfTypeByID("resourceQuantity", Label.class)).setLabelText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack image = new ItemStack((IItemProvider)resource.getItem(), 1);
        image.func_77982_d(resource.getItemStack().func_77978_p());
        ((ItemIcon)this.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(image);
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        final ArrayList<Tuple<ItemStorage, Integer>> tempRes = new ArrayList<Tuple<ItemStorage, Integer>>(this.building.getStock());
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((ItemStorage)((Tuple)tempRes.get(index)).getA()).getItemStack().func_77946_l();
                resource.func_190920_e(resource.func_77976_d());
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_200301_q().func_150254_d());
                Label quantityLabel = (Label)rowPane.findPaneOfTypeByID("resourceQty", Label.class);
                quantityLabel.setLabelText(String.valueOf(((Tuple)tempRes.get(index)).getB()));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    private void transferItems() {
        Network.getNetwork().sendToServer(new UpgradeWarehouseMessage(this.building));
        this.allowMoreStorageUpgrades = false;
        this.updateResourcePane();
    }

    private void sortWarehouse() {
        Network.getNetwork().sendToServer(new SortWarehouseMessage(this.building));
        LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"com.minecolonies.coremod.gui.warehouse.sorted", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerhuts.buildingWareHouse";
    }
}

