/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.controls.TextField;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowRequestTree;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.postbox.PostBoxRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WindowPostBox
extends AbstractWindowRequestTree {
    private static final String TAG_BUTTON_DELIVER_AVAILABLE = "deliverAvailable";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList stackList;
    private final AbstractBuildingView buildingView;
    private String filter = "";
    private boolean deliverAvailable;

    public WindowPostBox(AbstractBuildingView buildingView) {
        super(buildingView.getID(), "minecolonies:gui/windowpostbox.xml", buildingView.getColony());
        this.buildingView = buildingView;
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("request", this::requestClicked);
        this.registerButton(TAG_BUTTON_DELIVER_AVAILABLE, this::deliverPartialClicked);
    }

    private void inventoryClicked() {
        Network.getNetwork().sendToServer(new OpenInventoryMessage(this.buildingView));
    }

    private void requestClicked(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStack stack = this.allItems.get(row);
        int qty = stack.func_77976_d();
        for (Pane child : button.getParent().getChildren()) {
            if (!child.getID().equals("qty")) continue;
            try {
                qty = Integer.parseInt(((TextField)child).getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        Network.getNetwork().sendToServer(new PostBoxRequestMessage(this.buildingView, stack.func_77946_l(), qty, this.deliverAvailable));
    }

    private void deliverPartialClicked(@NotNull Button button) {
        if (button.getLabel().equals(RED_X)) {
            button.setLabel(APPROVE);
            this.deliverAvailable = true;
        } else {
            button.setLabel(RED_X);
            this.deliverAvailable = false;
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_DELIVER_AVAILABLE, Button.class)).setLabel(RED_X);
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.func_77977_a().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.func_200301_q().func_150254_d().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.updateResourceList();
    }

    private Collection<? extends ItemStack> getBlockList(Predicate<ItemStack> filterPredicate) {
        if (this.filter.isEmpty()) {
            return IColonyManager.getInstance().getCompatibilityManager().getBlockList();
        }
        return IColonyManager.getInstance().getCompatibilityManager().getBlockList().stream().filter(filterPredicate).collect(Collectors.toList());
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Label resourceLabel = (Label)rowPane.findPaneOfTypeByID("resourceName", Label.class);
                resourceLabel.setLabelText(resource.func_200301_q().func_150254_d());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean result = super.onKeyTyped(ch, key);
        this.filter = ((TextField)this.findPaneOfTypeByID("name", TextField.class)).getText();
        this.updateResources();
        return result;
    }
}

