/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Gradient;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Label;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.ZoomDragView;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.WindowHutUniversity;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.coremod.network.messages.server.colony.building.university.TryResearchMessage;
import com.minecolonies.coremod.research.BuildingResearchRequirement;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowResearchTree
extends AbstractWindowSkeleton {
    private final String branch;
    private final BuildingUniversity.View building;
    private final WindowHutUniversity last;
    private boolean hasMax;

    public WindowResearchTree(String branch, BuildingUniversity.View building, WindowHutUniversity last) {
        super("minecolonies:gui/windowresearch.xml", last);
        this.branch = branch;
        this.building = building;
        this.last = last;
        this.hasMax = false;
        List<String> researchList = IGlobalResearchTree.getInstance().getPrimaryResearch(branch);
        this.hasMax = building.getColony().getResearchManager().getResearchTree().branchFinishedHighestLevel(branch);
        ZoomDragView view = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        this.drawTree(0, 0, view, researchList, building.getColony().getResearchManager().getResearchTree(), true, false, 0);
        for (int i = 1; i <= 6; ++i) {
            Label timeLabel = new Label();
            timeLabel.setLabelText(Math.pow(2.0, i - 1) + "h");
            timeLabel.setPosition((i - 1) * 215 + 87, 10);
            timeLabel.setColor(Color.rgbaToInt((int)218, (int)202, (int)171, (int)255));
            view.addChild((Pane)timeLabel);
        }
    }

    private boolean isResearchFulfilled(BuildingResearchRequirement researchRequirement) {
        List<IBuildingView> buildings = this.building.getColony().getBuildings();
        int levels = 0;
        if (researchRequirement == null) {
            return true;
        }
        for (IBuildingView building : buildings) {
            if (!building.getSchematicName().equals(researchRequirement.getBuilding())) continue;
            levels += building.getBuildingLevel();
        }
        return levels >= researchRequirement.getBuildingLevel();
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, button.getID());
        if (research != null && this.building.getBuildingLevel() > this.building.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() && (this.building.getBuildingLevel() >= research.getDepth() || this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) && research.hasEnoughResources((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by)) || research != null && this.mc.field_71439_g.func_184812_l_()) {
            Network.getNetwork().sendToServer(new TryResearchMessage(this.building, research.getId(), research.getBranch()));
            this.close();
        }
        if (button.getID().equals("cancel")) {
            this.close();
            this.last.open();
        }
    }

    public int drawTree(int height, int depth, ZoomDragView view, List<String> researchList, ILocalResearchTree tree, boolean parentResearched, boolean abandoned, int parentHeight) {
        int nextHeight = height;
        for (int i = 0; i < researchList.size(); ++i) {
            boolean lastSibling;
            String researchLabel = researchList.get(i);
            int offsetX = depth * 215;
            IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, researchLabel);
            ILocalResearch localResearch = tree.getResearch(this.branch, research.getId());
            ResearchState state = localResearch == null ? ResearchState.NOT_STARTED : localResearch.getState();
            IGlobalResearch parentResearch = IGlobalResearchTree.getInstance().getResearch(this.branch, research.getParent());
            boolean trueAbandoned = abandoned;
            if (depth != 0 && !abandoned && state == ResearchState.NOT_STARTED && parentResearch.hasResearchedChild(tree) && parentResearch.hasOnlyChild()) {
                trueAbandoned = true;
            }
            Gradient gradient = new Gradient();
            gradient.setSize(175, 50);
            gradient.setPosition(offsetX + 10, (nextHeight + Math.min(i, 1)) * 70 + 20);
            if (state == ResearchState.IN_PROGRESS) {
                gradient.setGradientStart(227, 249, 184, 255);
                gradient.setGradientEnd(227, 249, 184, 255);
                view.addChild((Pane)gradient);
            } else if (trueAbandoned && state != ResearchState.FINISHED) {
                gradient.setGradientStart(191, 184, 172, 255);
                gradient.setGradientEnd(191, 184, 172, 255);
                view.addChild((Pane)gradient);
            } else if (!parentResearched) {
                gradient.setGradientStart(239, 230, 215, 255);
                gradient.setGradientEnd(239, 230, 215, 255);
                view.addChild((Pane)gradient);
            } else if (state != ResearchState.FINISHED) {
                gradient.setGradientStart(102, 204, 255, 255);
                gradient.setGradientEnd(102, 204, 255, 255);
                view.addChild((Pane)gradient);
            }
            Box box = new Box();
            box.setColor(218, 202, 171);
            box.setSize(175, 50);
            box.setPosition(gradient.getX(), gradient.getY());
            view.addChild((Pane)box);
            Label nameLabel = new Label();
            nameLabel.setLabelText(research.getDesc());
            nameLabel.setPosition(offsetX + 10 + 50, (nextHeight + Math.min(i, 1)) * 70 + 20 + 10);
            nameLabel.setColor(Color.rgbaToInt((int)160, (int)160, (int)160, (int)255));
            view.addChild((Pane)nameLabel);
            if (state == ResearchState.IN_PROGRESS) {
                if (this.mc.field_71439_g.func_184812_l_() && (double)localResearch.getProgress() < 144.0 * Math.pow(2.0, depth - 1)) {
                    Network.getNetwork().sendToServer(new TryResearchMessage(this.building, research.getId(), research.getBranch()));
                }
                double progressRatio = (double)(localResearch.getProgress() + 1) / (Math.pow(2.0, localResearch.getDepth() - 1) * 144.0) * 100.0;
                Image xpBar = new Image();
                xpBar.setImage(Screen.GUI_ICONS_LOCATION, 0, 64, 91, 5, false);
                xpBar.setPosition(offsetX + 40 + 5, nameLabel.getY() + nameLabel.getHeight() + 30);
                Image xpBar2 = new Image();
                xpBar2.setImage(Screen.GUI_ICONS_LOCATION, 172, 64, 10, 5, false);
                xpBar2.setPosition(90 + offsetX + 40 + 5, nameLabel.getY() + nameLabel.getHeight() + 30);
                view.addChild((Pane)xpBar);
                view.addChild((Pane)xpBar2);
                if (progressRatio > 0.0) {
                    Image xpBarFull = new Image();
                    xpBarFull.setImage(Screen.GUI_ICONS_LOCATION, 0, 69, (int)progressRatio, 5, false);
                    xpBarFull.setPosition(offsetX + 40 + 5, nameLabel.getY() + nameLabel.getHeight() + 30);
                    view.addChild((Pane)xpBarFull);
                }
            } else if (research.getResearchRequirement() != null && state != ResearchState.FINISHED) {
                Label requirementLabel = new Label();
                requirementLabel.setLabelText(research.getResearchRequirement().getDesc().func_150254_d());
                requirementLabel.setPosition(offsetX + 10 + 5, nameLabel.getY() + nameLabel.getHeight() + 10);
                requirementLabel.setColor(Color.rgbaToInt((int)160, (int)160, (int)160, (int)255));
                view.addChild((Pane)requirementLabel);
            }
            Label effectLabel = new Label();
            effectLabel.setLabelText(research.getEffect().getDesc().func_150254_d());
            effectLabel.setPosition(offsetX + 10 + 5, nameLabel.getY() + nameLabel.getHeight() * 2 + 10 + 10);
            effectLabel.setColor(Color.rgbaToInt((int)160, (int)160, (int)160, (int)255));
            view.addChild((Pane)effectLabel);
            if (parentResearched && state == ResearchState.NOT_STARTED && !trueAbandoned) {
                ButtonImage buttonImage = new ButtonImage();
                buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
                buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research", (Object[])new Object[0]));
                buttonImage.setTextColor(Color.getByName((String)"black", (int)0));
                buttonImage.setSize(129, 17);
                buttonImage.setPosition(effectLabel.getX(), effectLabel.getY() + effectLabel.getHeight() + 10);
                buttonImage.setID(research.getId());
                if (this.mc.field_71439_g.func_184812_l_()) {
                    if (research.getDepth() == 6 && this.hasMax) {
                        buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                        buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research.maxunlocked", (Object[])new Object[0]));
                    }
                } else if (this.building.getBuildingLevel() <= this.building.getColony().getResearchManager().getResearchTree().getResearchInProgress().size()) {
                    buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                    buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research.toomanyinprogress", (Object[])new Object[0]));
                } else if (!this.isResearchFulfilled((BuildingResearchRequirement)research.getResearchRequirement())) {
                    buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                    buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research.missingrequirements", (Object[])new Object[0]));
                } else if (!research.hasEnoughResources((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by))) {
                    buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                    buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research.notenoughresources", (Object[])new Object[0]));
                } else if (research.getDepth() > this.building.getBuildingLevel() && this.building.getBuildingLevel() != this.building.getBuildingMaxLevel()) {
                    buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                    buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research.buildingleveltoolow", (Object[])new Object[0]));
                } else if (research.getDepth() == 6 && this.building.getBuildingLevel() == this.building.getBuildingMaxLevel() && this.hasMax) {
                    buttonImage.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                    buttonImage.setLabel(LanguageHandler.format((String)"com.minecolonies.coremod.research.research.maxunlocked", (Object[])new Object[0]));
                }
                view.addChild((Pane)buttonImage);
                int storageOffset = 2;
                for (ItemStorage storage : research.getCostList()) {
                    ItemStack stack = storage.getItemStack().func_77946_l();
                    stack.func_190920_e(storage.getAmount());
                    ItemIcon icon = new ItemIcon();
                    icon.setItem(stack);
                    icon.setPosition(buttonImage.getX() + buttonImage.getWidth() + storageOffset, effectLabel.getY() + effectLabel.getHeight() + 10);
                    icon.setSize(16, 16);
                    view.addChild((Pane)icon);
                    storageOffset += 20;
                }
            } else if (!parentResearched && !trueAbandoned) {
                Image lockIcon = new Image();
                lockIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/locked_icon.png"));
                lockIcon.setSize(15, 17);
                lockIcon.setPosition(effectLabel.getX() + 129, effectLabel.getY() + effectLabel.getHeight() + 10);
                view.addChild((Pane)lockIcon);
            }
            boolean firstSibling = i == 0;
            boolean secondSibling = i >= 1;
            boolean bl = lastSibling = i + 1 >= researchList.size();
            if (!research.getParent().isEmpty()) {
                Image corner;
                if (firstSibling && lastSibling) {
                    corner = new Image();
                    corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right.png"));
                    corner.setSize(40, 50);
                    corner.setPosition(gradient.getX() - 40, gradient.getY());
                    view.addChild((Pane)corner);
                } else {
                    Image corner2;
                    if (secondSibling) {
                        for (int dif = 1; dif < nextHeight - parentHeight + 1; ++dif) {
                            corner2 = new Image();
                            corner2.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_down.png"));
                            corner2.setSize(40, 70);
                            corner2.setPosition(gradient.getX() - 40, gradient.getY() - dif * corner2.getHeight());
                            view.addChild((Pane)corner2);
                        }
                    }
                    if (firstSibling) {
                        corner = new Image();
                        corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_down.png"));
                        corner.setSize(40, 70);
                        corner.setPosition(gradient.getX() - 40, gradient.getY());
                        view.addChild((Pane)corner);
                    } else if (IGlobalResearchTree.getInstance().getResearch(this.branch, research.getParent()).hasOnlyChild()) {
                        Label orLabel = new Label();
                        orLabel.setColor(Color.getByName((String)"black", (int)0));
                        orLabel.setLabelText("or");
                        orLabel.setPosition(gradient.getX() - 40 + 14, gradient.getY() + 10);
                        view.addChild((Pane)orLabel);
                        if (lastSibling) {
                            Image circle = new Image();
                            circle.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_or.png"));
                            circle.setSize(40, 50);
                            circle.setPosition(gradient.getX() - 40, gradient.getY());
                            view.addChild((Pane)circle);
                        } else {
                            corner2 = new Image();
                            corner2.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_or_down.png"));
                            corner2.setSize(40, 70);
                            corner2.setPosition(gradient.getX() - 40, gradient.getY());
                            view.addChild((Pane)corner2);
                        }
                    } else if (lastSibling) {
                        corner = new Image();
                        corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_and.png"));
                        corner.setSize(40, 50);
                        corner.setPosition(gradient.getX() - 40, gradient.getY());
                        view.addChild((Pane)corner);
                    } else {
                        corner = new Image();
                        corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_and_more.png"));
                        corner.setSize(40, 70);
                        corner.setPosition(gradient.getX() - 40, gradient.getY());
                        view.addChild((Pane)corner);
                    }
                }
            }
            if (!research.getChilds().isEmpty()) {
                nextHeight = this.drawTree(nextHeight + Math.min(i, 1), depth + 1, view, (List<String>)research.getChilds(), tree, state == ResearchState.FINISHED, trueAbandoned, nextHeight + Math.min(i, 1));
                continue;
            }
            nextHeight += Math.min(i, 1);
        }
        return nextHeight;
    }
}

