/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.render;

import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityEnchanter;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityEnchanterRenderer
extends TileEntityRenderer<TileEntityColonyBuilding> {
    public static final Material TEXTURE_BOOK = new Material(AtlasTexture.field_110575_b, new ResourceLocation("minecolonies", "blocks/enchanting_table_book"));
    private final BookModel modelBook = new BookModel();

    public TileEntityEnchanterRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(@NotNull TileEntityColonyBuilding ent, float partialTicks, @NotNull MatrixStack matrixStack, @NotNull IRenderTypeBuffer renderTypeBuffer, int lightA, int lightB) {
        if (ent instanceof TileEntityEnchanter) {
            TileEntityEnchanter entity = (TileEntityEnchanter)ent;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.75, 0.5);
            float tick = (float)entity.tickCount + partialTicks;
            matrixStack.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76126_a((float)(tick * 0.1f)) * 0.01f), 0.0);
            double rotVPrev = entity.bookRotation - entity.bookRotationPrev;
            float circleRot = (float)(rotVPrev + Math.PI - Math.PI);
            float tickBasedRot = entity.bookRotationPrev + circleRot * partialTicks;
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-tickBasedRot));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(80.0f));
            float pageFlip = MathHelper.func_219799_g((float)partialTicks, (float)entity.pageFlipPrev, (float)entity.pageFlip);
            float flipA = MathHelper.func_226164_h_((float)(pageFlip + 0.25f)) * 1.6f - 0.3f;
            float flipB = MathHelper.func_226164_h_((float)(pageFlip + 0.75f)) * 1.6f - 0.3f;
            float bookSpread = MathHelper.func_219799_g((float)partialTicks, (float)entity.bookSpreadPrev, (float)entity.bookSpread);
            this.modelBook.func_228247_a_(tick, MathHelper.func_76131_a((float)flipA, (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)flipB, (float)0.0f, (float)1.0f), bookSpread);
            IVertexBuilder vertexConsumer = TEXTURE_BOOK.func_229311_a_(renderTypeBuffer, RenderType::func_228634_a_);
            this.modelBook.func_228249_b_(matrixStack, vertexConsumer, lightA, lightB, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.func_227865_b_();
        }
    }
}

