/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.IWorkerLivingBuilding;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeDataManager;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeRegistry;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutGuardTower;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.coremod.entity.ai.citizen.guard.AbstractEntityAIGuard;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.coremod.items.ItemBannerRallyGuards;
import com.minecolonies.coremod.network.messages.client.colony.building.guard.GuardMobAttackListMessage;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Future;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingGuards
extends AbstractBuildingWorker
implements IGuardBuilding,
IWorkerLivingBuilding {
    private static final String NBT_TASK = "TASK";
    private static final String NBT_JOB = "guardType";
    private static final String NBT_ASSIGN = "assign";
    private static final String NBT_RETRIEVE = "retrieve";
    private static final String NBT_PATROL = "patrol";
    private static final String NBT_TIGHT_GROUPING = "tightGrouping";
    private static final String NBT_PATROL_TARGETS = "patrol targets";
    private static final String NBT_TARGET = "target";
    private static final String NBT_GUARD = "guard";
    private static final String NBT_MOBS = "mobs";
    private static final String NBT_MOB_VIEW = "mobview";
    private static final String NBT_RECRUIT = "recruitTrainees";
    private static final int PATROL_BASE_DIST = 50;
    private static final int BONUS_HEALTH_PER_LEVEL = 2;
    private final AttributeModifier healthModConfig;
    private static final int VISION_RANGE_PER_LEVEL = 3;
    private static final int BASE_VISION_RANGE = 15;
    private boolean assignManually;
    private boolean retrieveOnLowHealth;
    protected boolean patrolManually;
    private GuardTask task;
    private BlockPos guardPos;
    private GuardType job;
    protected List<BlockPos> patrolTargets;
    private Map<ResourceLocation, MobEntryView> mobsToAttack;
    private PlayerEntity followPlayer;
    private ILocation rallyLocation;
    private boolean tightGrouping;
    protected BlockPos tempNextPatrolPoint;
    private boolean hireTrainees;
    private Future<Path> pathingFuture;
    private final Set<AbstractEntityCitizen> arrivedAtPatrol;
    private BlockPos lastPatrolPoint;
    private int patrolTimer;

    public AbstractBuildingGuards(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.healthModConfig = new AttributeModifier("MinecoloniesGuardConfigHP", (Double)MineColonies.getConfig().getCommon().guardHealthMult.get() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.assignManually = false;
        this.retrieveOnLowHealth = true;
        this.patrolManually = false;
        this.task = GuardTask.PATROL;
        this.guardPos = this.getID();
        this.job = null;
        this.patrolTargets = new ArrayList<BlockPos>();
        this.mobsToAttack = new HashMap<ResourceLocation, MobEntryView>();
        this.tempNextPatrolPoint = null;
        this.hireTrainees = true;
        this.arrivedAtPatrol = new HashSet<AbstractEntityCitizen>();
        this.patrolTimer = 0;
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.BOW, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.doesItemServeAsWeapon(itemStack), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ArmorItem && ((ArmorItem)itemStack.func_77973_b()).func_185083_B_() == EquipmentSlotType.FEET, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> {
            if (ItemStackUtils.isEmpty(itemStack).booleanValue() || !(itemStack.func_77973_b() instanceof ArrowItem)) {
                return false;
            }
            UnlockAbilityResearchEffect arrowItemEffect = this.getColony().getResearchManager().getResearchEffects().getEffect("Consume Arrows", UnlockAbilityResearchEffect.class);
            return arrowItemEffect != null && arrowItemEffect.getEffect() != false && this.getGuardType() == ModGuardTypes.ranger;
        }, new Tuple((Object)128, (Object)true));
        this.calculateMobs();
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.getGuardType();
        if (this.getAssignedEntities() != null) {
            for (Optional<AbstractEntityCitizen> optCitizen : this.getAssignedEntities()) {
                if (!optCitizen.isPresent()) continue;
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), AttributeModifier.Operation.ADDITION);
                AttributeModifierUtils.addHealthModifier((LivingEntity)optCitizen.get(), healthModBuildingHP);
            }
        }
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding building;
            Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
            if (optCitizen.isPresent()) {
                AbstractEntityCitizen citizenEntity = optCitizen.get();
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), AttributeModifier.Operation.ADDITION);
                AttributeModifierUtils.addHealthModifier((LivingEntity)citizenEntity, healthModBuildingHP);
                AttributeModifierUtils.addHealthModifier((LivingEntity)citizenEntity, this.healthModConfig);
            }
            if ((building = citizen.getHomeBuilding()) != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            this.patrolTimer = 5;
            return true;
        }
        return false;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.task = GuardTask.values()[compound.func_74762_e(NBT_TASK)];
        ResourceLocation jobName = new ResourceLocation(compound.func_74779_i(NBT_JOB));
        this.job = IGuardTypeDataManager.getInstance().getFrom(jobName);
        this.assignManually = compound.func_74767_n(NBT_ASSIGN);
        this.retrieveOnLowHealth = compound.func_74767_n(NBT_RETRIEVE);
        this.patrolManually = compound.func_74767_n(NBT_PATROL);
        if (compound.func_74764_b(NBT_RECRUIT)) {
            this.hireTrainees = compound.func_74767_n(NBT_RECRUIT);
        }
        this.tightGrouping = compound.func_150296_c().contains(NBT_TIGHT_GROUPING) ? compound.func_74767_n(NBT_TIGHT_GROUPING) : true;
        ListNBT wayPointTagList = compound.func_150295_c(NBT_PATROL_TARGETS, 10);
        for (int i = 0; i < wayPointTagList.size(); ++i) {
            CompoundNBT blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.read(blockAtPos, NBT_TARGET);
            this.patrolTargets.add(pos);
        }
        ListNBT mobsTagList = compound.func_150295_c(NBT_MOBS, 10);
        for (int i = 0; i < mobsTagList.size(); ++i) {
            CompoundNBT mobCompound = mobsTagList.func_150305_b(i);
            MobEntryView mobEntry = MobEntryView.read(mobCompound, NBT_MOB_VIEW);
            if (mobEntry.getEntityEntry() == null) continue;
            this.mobsToAttack.put(mobEntry.getEntityEntry().getRegistryName(), mobEntry);
        }
        this.guardPos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(NBT_GUARD));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74768_a(NBT_TASK, this.task.ordinal());
        compound.func_74778_a(NBT_JOB, this.job == null ? "" : this.job.getRegistryName().toString());
        compound.func_74757_a(NBT_ASSIGN, this.assignManually);
        compound.func_74757_a(NBT_RETRIEVE, this.retrieveOnLowHealth);
        compound.func_74757_a(NBT_PATROL, this.patrolManually);
        compound.func_74757_a(NBT_TIGHT_GROUPING, this.tightGrouping);
        compound.func_74757_a(NBT_RECRUIT, this.hireTrainees);
        ListNBT wayPointTagList = new ListNBT();
        for (BlockPos pos : this.patrolTargets) {
            CompoundNBT wayPointCompound = new CompoundNBT();
            BlockPosUtil.write(wayPointCompound, NBT_TARGET, pos);
            wayPointTagList.add((Object)wayPointCompound);
        }
        compound.func_218657_a(NBT_PATROL_TARGETS, (INBT)wayPointTagList);
        ListNBT mobsTagList = new ListNBT();
        for (MobEntryView entry : this.mobsToAttack.values()) {
            CompoundNBT mobCompound = new CompoundNBT();
            MobEntryView.write(mobCompound, NBT_MOB_VIEW, entry);
            mobsTagList.add((Object)mobCompound);
        }
        compound.func_218657_a(NBT_MOBS, (INBT)mobsTagList);
        compound.func_218657_a(NBT_GUARD, (INBT)NBTUtil.func_186859_a((BlockPos)this.guardPos));
        return compound;
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen != null) {
            Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
            if (optCitizen.isPresent()) {
                AttributeModifierUtils.removeAllHealthModifiers((LivingEntity)optCitizen.get());
                optCitizen.get().func_184201_a(EquipmentSlotType.CHEST, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.FEET, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.LEGS, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.MAINHAND, ItemStackUtils.EMPTY);
                optCitizen.get().func_184201_a(EquipmentSlotType.OFFHAND, ItemStackUtils.EMPTY);
            }
            citizen.setHomeBuilding(null);
        }
        super.removeCitizen(citizen);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.assignManually);
        buf.writeBoolean(this.retrieveOnLowHealth);
        buf.writeBoolean(this.patrolManually);
        buf.writeBoolean(this.tightGrouping);
        buf.writeBoolean(this.hireTrainees);
        buf.writeInt(this.task.ordinal());
        buf.func_180714_a(this.job == null ? "" : this.job.getRegistryName().toString());
        buf.writeInt(this.patrolTargets.size());
        for (BlockPos pos : this.patrolTargets) {
            buf.func_179255_a(pos);
        }
        if (this.mobsToAttack.isEmpty()) {
            this.calculateMobs();
        }
        buf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack.values()) {
            MobEntryView.writeToByteBuf(buf, entry);
        }
        buf.func_179255_a(this.guardPos);
        buf.writeInt(this.getAssignedCitizen().size());
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public GuardTask getTask() {
        return this.task;
    }

    @Override
    public void setTask(GuardTask task) {
        this.task = task;
        this.markDirty();
    }

    @Override
    @Nullable
    public PlayerEntity getPlayerToFollowOrRally() {
        return this.rallyLocation != null && this.rallyLocation instanceof EntityLocation ? ((EntityLocation)this.rallyLocation).getPlayerEntity() : this.followPlayer;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        boolean hiredFromTraining = false;
        if (this.hireTrainees && !this.isFull() && this.getBuildingLevel() > 0 && this.isBuilt() && (this.getHiringMode() == HiringMode.DEFAULT && !this.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            ICitizenData trainingCitizen = null;
            int maxSkill = 0;
            for (ICitizenData trainee : colony.getCitizenManager().getCitizens()) {
                if ((this.getGuardType() != ModGuardTypes.ranger || !(trainee.getJob() instanceof JobArcherTraining)) && (this.getGuardType() != ModGuardTypes.knight || !(trainee.getJob() instanceof JobCombatTraining) || trainee.getCitizenSkillHandler().getLevel(this.job.getPrimarySkill()) <= maxSkill)) continue;
                maxSkill = trainee.getCitizenSkillHandler().getLevel(this.job.getPrimarySkill());
                trainingCitizen = trainee;
            }
            if (trainingCitizen != null) {
                hiredFromTraining = true;
                this.assignCitizen(trainingCitizen);
            }
        }
        if (!hiredFromTraining) {
            super.onColonyTick(colony);
        }
        if (this.patrolTimer > 0 && this.task == GuardTask.PATROL) {
            --this.patrolTimer;
            if (this.patrolTimer <= 0 && !this.getAssignedCitizen().isEmpty()) {
                this.startPatrolNext();
            }
        }
    }

    @Override
    public boolean requiresManualTarget() {
        return false;
    }

    @Override
    public void arrivedAtPatrolPoint(AbstractEntityCitizen guard) {
        if (this.arrivedAtPatrol.isEmpty()) {
            this.patrolTimer = 1;
        }
        this.arrivedAtPatrol.add(guard);
        if (this.getAssignedCitizen().size() <= this.arrivedAtPatrol.size() || this.patrolTimer <= 0) {
            this.startPatrolNext();
        }
    }

    private void startPatrolNext() {
        this.getNextPatrolTarget(true);
        this.patrolTimer = 5;
        for (ICitizenData curguard : this.getAssignedCitizen()) {
            if (!curguard.getEntity().isPresent() || !(curguard.getEntity().get().getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard)) continue;
            ((AbstractEntityAIGuard)((Object)curguard.getEntity().get().getCitizenJobHandler().getColonyJob().getWorkerAI())).setNextPatrolTarget(this.lastPatrolPoint);
        }
        this.arrivedAtPatrol.clear();
    }

    @Override
    @Nullable
    public BlockPos getNextPatrolTarget(boolean newTarget) {
        if (!newTarget && this.lastPatrolPoint != null) {
            return this.lastPatrolPoint;
        }
        if (this.tempNextPatrolPoint != null) {
            this.lastPatrolPoint = this.tempNextPatrolPoint;
            this.tempNextPatrolPoint = null;
            return this.lastPatrolPoint;
        }
        if (this.lastPatrolPoint == null) {
            this.lastPatrolPoint = this.getAssignedCitizen().get(0).getLastPosition();
            return this.lastPatrolPoint;
        }
        if (!this.patrolManually || this.patrolTargets == null || this.patrolTargets.isEmpty()) {
            BlockPos pos = null;
            if (this.pathingFuture != null && this.pathingFuture.isDone()) {
                try {
                    pos = this.pathingFuture.get().func_224770_k();
                }
                catch (Exception e) {
                    Log.getLogger().warn("Guard pathing interrupted", (Throwable)e);
                }
                this.pathingFuture = null;
            } else if (this.colony.getWorld().field_73012_v.nextBoolean() || this.pathingFuture != null && this.pathingFuture.isCancelled()) {
                this.pathingFuture = Pathfinding.enqueue(new PathJobRandomPos(this.colony.getWorld(), this.lastPatrolPoint, 10, 30, null));
            } else {
                pos = this.colony.getBuildingManager().getRandomBuilding(b -> true);
            }
            if (pos != null) {
                if (BlockPosUtil.getDistance2D(pos, this.getPosition()) > (long)this.getPatrolDistance()) {
                    this.lastPatrolPoint = this.getPosition();
                    return this.lastPatrolPoint;
                }
                this.lastPatrolPoint = pos;
            }
            return this.lastPatrolPoint;
        }
        if (this.patrolTargets.contains(this.lastPatrolPoint)) {
            int index = this.patrolTargets.indexOf(this.lastPatrolPoint) + 1;
            if (index >= this.patrolTargets.size()) {
                index = 0;
            }
            this.lastPatrolPoint = this.patrolTargets.get(index);
            return this.lastPatrolPoint;
        }
        this.lastPatrolPoint = this.patrolTargets.get(0);
        return this.lastPatrolPoint;
    }

    @Override
    public int getPatrolDistance() {
        return 50 + this.getBuildingLevel() * 30;
    }

    public void setTempNextPatrolPoint(BlockPos pos) {
        this.tempNextPatrolPoint = pos;
    }

    @Override
    public GuardType getGuardType() {
        if (this.job == null) {
            ArrayList guardTypes = new ArrayList(IGuardTypeRegistry.getInstance().getValues());
            this.job = (GuardType)((Object)guardTypes.get(new Random().nextInt(guardTypes.size())));
        }
        return this.job;
    }

    @Override
    public void setGuardType(GuardType job) {
        this.job = job;
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            this.cancelAllRequestsOfCitizen(citizen);
            citizen.setJob(this.createJob(citizen));
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return this.getGuardType().getGuardJobProducer().apply(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return this.getGuardType().getJobTranslationKey();
    }

    @Override
    public List<BlockPos> getPatrolTargets() {
        return new ArrayList<BlockPos>(this.patrolTargets);
    }

    @Override
    public boolean shallRetrieveOnLowHealth() {
        return this.retrieveOnLowHealth;
    }

    @Override
    public void setRetrieveOnLowHealth(boolean retrieve) {
        this.retrieveOnLowHealth = retrieve;
    }

    @Override
    public boolean shallPatrolManually() {
        return this.patrolManually;
    }

    @Override
    public void setPatrolManually(boolean patrolManually) {
        this.patrolManually = patrolManually;
    }

    @Override
    public boolean shallAssignManually() {
        return this.assignManually;
    }

    @Override
    public void setAssignManually(boolean assignManually) {
        this.assignManually = assignManually;
    }

    @Override
    public boolean isTightGrouping() {
        return this.tightGrouping;
    }

    @Override
    public void setTightGrouping(boolean tightGrouping) {
        this.tightGrouping = tightGrouping;
    }

    @Override
    public BlockPos getGuardPos() {
        return this.guardPos;
    }

    @Override
    public void setGuardPos(BlockPos guardPos) {
        this.guardPos = guardPos;
    }

    @Override
    public Map<ResourceLocation, MobEntryView> getMobsToAttack() {
        return this.mobsToAttack;
    }

    @Override
    public void setMobsToAttack(List<MobEntryView> list) {
        this.mobsToAttack = new HashMap<ResourceLocation, MobEntryView>();
        for (MobEntryView entry : list) {
            this.mobsToAttack.put(entry.getEntityEntry().getRegistryName(), entry);
        }
    }

    @Override
    public BlockPos getPositionToFollow() {
        if (this.task.equals((Object)GuardTask.FOLLOW) && this.followPlayer != null) {
            return this.followPlayer.func_180425_c();
        }
        return this.getPosition();
    }

    @Override
    @Nullable
    public ILocation getRallyLocation() {
        if (this.rallyLocation == null) {
            return null;
        }
        boolean outOfRange = false;
        IColony colonyAtPosition = IColonyManager.getInstance().getColonyByPosFromDim(this.rallyLocation.getDimension(), this.rallyLocation.getInDimensionLocation());
        if (colonyAtPosition == null || colonyAtPosition.getID() != this.colony.getID()) {
            outOfRange = true;
        }
        if (this.rallyLocation instanceof EntityLocation) {
            PlayerEntity player = ((EntityLocation)this.rallyLocation).getPlayerEntity();
            if (player == null) {
                this.setRallyLocation(null);
                return null;
            }
            if (outOfRange) {
                LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.banner_rally_guards.outofrange", (Object[])new Object[0]);
                this.setRallyLocation(null);
                return null;
            }
            int size = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemBannerRallyGuards) || !((ItemBannerRallyGuards)stack.func_77973_b()).isActiveForGuardTower(stack, this)) continue;
                return this.rallyLocation;
            }
            return null;
        }
        return this.rallyLocation;
    }

    @Override
    public void setRallyLocation(ILocation location) {
        boolean reduceSaturation = false;
        if (this.rallyLocation != null && location == null) {
            reduceSaturation = true;
        }
        this.rallyLocation = location;
        for (ICitizenData iCitizenData : this.getAssignedCitizen()) {
            AbstractJobGuard job;
            if (reduceSaturation && iCitizenData.getSaturation() < 3.0) {
                iCitizenData.decreaseSaturation(3.0);
            }
            if ((job = iCitizenData.getJob(AbstractJobGuard.class)) == null || job.getWorkerAI() == null) continue;
            job.getWorkerAI().registerTarget(new AIOneTimeEventTarget(AIWorkerState.GUARD_DECIDE));
        }
    }

    @Override
    public void setPlayerToFollow(PlayerEntity player) {
        this.followPlayer = player;
        for (ICitizenData iCitizenData : this.getAssignedCitizen()) {
            AbstractJobGuard job = iCitizenData.getJob(AbstractJobGuard.class);
            if (job == null || job.getWorkerAI() == null) continue;
            job.getWorkerAI().registerTarget(new AIOneTimeEventTarget(AIWorkerState.DECIDE));
        }
    }

    protected int getBonusHealth() {
        return this.getBuildingLevel() * 2;
    }

    @Override
    public void addPatrolTargets(BlockPos target) {
        this.patrolTargets.add(target);
        this.markDirty();
    }

    @Override
    public void resetPatrolTargets() {
        this.patrolTargets = new ArrayList<BlockPos>();
        this.markDirty();
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return this.job.getPrimarySkill();
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return this.job.getSecondarySkill();
    }

    @Override
    public int getBonusVision() {
        return 15 + this.getBuildingLevel() * 3;
    }

    @Override
    public void calculateMobs() {
        this.mobsToAttack = new HashMap<ResourceLocation, MobEntryView>();
        int i = 0;
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            if (((EntityType)entry.getValue()).func_220339_d() == EntityClassification.MONSTER) {
                this.mobsToAttack.put((ResourceLocation)entry.getKey(), new MobEntryView((ResourceLocation)entry.getKey(), true, ++i));
                continue;
            }
            for (String location : (List)MineColonies.getConfig().getCommon().guardResourceLocations.get()) {
                if (entry.getKey() == null || !((ResourceLocation)entry.getKey()).toString().equals(location)) continue;
                this.mobsToAttack.put((ResourceLocation)entry.getKey(), new MobEntryView((ResourceLocation)entry.getKey(), true, ++i));
            }
        }
        this.getColony().getPackageManager().getCloseSubscribers().forEach(player -> Network.getNetwork().sendToPlayer(new GuardMobAttackListMessage(this.getColony().getID(), this.getID(), new ArrayList<MobEntryView>(this.mobsToAttack.values())), (ServerPlayerEntity)player));
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    public boolean isHireTrainees() {
        return this.hireTrainees;
    }

    public void setHireTrainees(boolean hireTrainees) {
        this.hireTrainees = hireTrainees;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean assignManually = false;
        private boolean retrieveOnLowHealth = false;
        private boolean patrolManually = false;
        private GuardTask task = GuardTask.PATROL;
        private BlockPos guardPos = this.getID();
        private GuardType guardType = null;
        private boolean tightGrouping = true;
        private boolean hireTrainees = true;
        private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
        private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();
        @NotNull
        private final List<Integer> guards = new ArrayList<Integer>();

        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutGuardTower(this);
        }

        @NotNull
        public List<Integer> getGuards() {
            return Collections.unmodifiableList(this.guards);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.assignManually = buf.readBoolean();
            this.retrieveOnLowHealth = buf.readBoolean();
            this.patrolManually = buf.readBoolean();
            this.tightGrouping = buf.readBoolean();
            this.hireTrainees = buf.readBoolean();
            this.task = GuardTask.values()[buf.readInt()];
            ResourceLocation jobId = new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE));
            this.guardType = (GuardType)IGuardTypeRegistry.getInstance().getValue(jobId);
            int targetSize = buf.readInt();
            this.patrolTargets = new ArrayList<BlockPos>();
            for (int i = 0; i < targetSize; ++i) {
                this.patrolTargets.add(buf.func_179259_c());
            }
            this.mobsToAttack.clear();
            int mobSize = buf.readInt();
            for (int i = 0; i < mobSize; ++i) {
                MobEntryView mobEntry = MobEntryView.readFromByteBuf(buf);
                this.mobsToAttack.add(mobEntry);
            }
            this.guardPos = buf.func_179259_c();
            this.guards.clear();
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.guards.add(buf.readInt());
            }
        }

        @Override
        @NotNull
        public Skill getPrimarySkill() {
            return this.getGuardType().getPrimarySkill();
        }

        @Override
        @NotNull
        public Skill getSecondarySkill() {
            return this.getGuardType().getSecondarySkill();
        }

        public void setAssignManually(boolean assignManually) {
            this.assignManually = assignManually;
        }

        public boolean isAssignManually() {
            return this.assignManually;
        }

        public void setRetrieveOnLowHealth(boolean retrieveOnLowHealth) {
            this.retrieveOnLowHealth = retrieveOnLowHealth;
        }

        public boolean isRetrieveOnLowHealth() {
            return this.retrieveOnLowHealth;
        }

        public void setTightGrouping(boolean tightGrouping) {
            this.tightGrouping = tightGrouping;
        }

        public boolean isTightGrouping() {
            return this.tightGrouping;
        }

        public boolean isHireTrainees() {
            return this.hireTrainees;
        }

        public void setHireTrainees(boolean hireTrainees) {
            this.hireTrainees = hireTrainees;
        }

        public void setPatrolManually(boolean patrolManually) {
            this.patrolManually = patrolManually;
        }

        public void setMobsToAttack(List<MobEntryView> mobsToAttack) {
            this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
        }

        public boolean isPatrolManually() {
            return this.patrolManually;
        }

        public void setTask(GuardTask task) {
            this.task = task;
            this.getColony().markDirty();
        }

        public GuardTask getTask() {
            return this.task;
        }

        public BlockPos getGuardPos() {
            return this.guardPos;
        }

        public GuardType getGuardType() {
            return this.guardType;
        }

        public void setGuardType(GuardType job) {
            this.guardType = job;
        }

        public List<BlockPos> getPatrolTargets() {
            return new ArrayList<BlockPos>(this.patrolTargets);
        }

        public List<MobEntryView> getMobsToAttack() {
            return new ArrayList<MobEntryView>(this.mobsToAttack);
        }
    }
}

