/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.utils.BuilderBucket;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingStructureBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final int COUNT_TO_STORE_POS = 50;
    private BlockPos progressPos;
    private BuildingStructureHandler.Stage progressStage;
    private Map<String, BuildingBuilderResource> neededResources = new LinkedHashMap<String, BuildingBuilderResource>();
    private Deque<BuilderBucket> buckets = new ArrayDeque<BuilderBucket>();
    private int progressCounter = 0;
    private Map<Integer, List<BlockPos>> fluidsToRemove = new LinkedHashMap<Integer, List<BlockPos>>();
    private int totalStages = 0;
    private int currentStage = 0;

    public AbstractBuildingStructureBuilder(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public int getResourceBatchMultiplier() {
        return 1;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        if (inventory) {
            int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
            String key = stack.func_77977_a() + "-" + hashCode;
            if (this.getRequiredResources() != null && this.getRequiredResources().getResourceMap().containsKey(key)) {
                int qtyToKeep = this.getRequiredResources().getResourceMap().get(key);
                if (localAlreadyKept.contains(new ItemStorage(stack))) {
                    for (ItemStorage storage : localAlreadyKept) {
                        if (!storage.equals(new ItemStorage(stack))) continue;
                        if (storage.getAmount() >= qtyToKeep) {
                            return stack.func_190916_E();
                        }
                        int kept = storage.getAmount();
                        if (qtyToKeep >= kept + stack.func_190916_E()) {
                            storage.setAmount(kept + stack.func_190916_E());
                            return 0;
                        }
                        storage.setAmount(qtyToKeep);
                        return qtyToKeep - kept - stack.func_190916_E();
                    }
                } else {
                    if (qtyToKeep >= stack.func_190916_E()) {
                        localAlreadyKept.add(new ItemStorage(stack));
                        return 0;
                    }
                    localAlreadyKept.add(new ItemStorage(stack, qtyToKeep, false));
                    return stack.func_190916_E() - qtyToKeep;
                }
                if (this.checkIfShouldKeepTool(ToolType.PICKAXE, stack, localAlreadyKept) || this.checkIfShouldKeepTool(ToolType.SHOVEL, stack, localAlreadyKept) || this.checkIfShouldKeepTool(ToolType.AXE, stack, localAlreadyKept)) {
                    return 0;
                }
                return stack.func_190916_E();
            }
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory);
    }

    private boolean checkIfShouldKeepTool(ToolType type, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        if (ItemStackUtils.hasToolLevel(stack, type, 0, this.getMaxToolLevel())) {
            for (ItemStorage storage : localAlreadyKept) {
                if (!ItemStackUtils.hasToolLevel(storage.getItemStack(), ToolType.PICKAXE, 0, this.getMaxToolLevel())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<Predicate<ItemStack>, net.minecraft.util.Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, net.minecraft.util.Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, net.minecraft.util.Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (BuildingBuilderResource stack : this.neededResources.values()) {
            toKeep.put(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack.getItemStack(), itemstack, true, false), (net.minecraft.util.Tuple<Integer, Boolean>)new net.minecraft.util.Tuple((Object)stack.getAmount(), (Object)true));
        }
        return toKeep;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            this.markDirty();
        }
        return itemStack;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b("newProgressPos")) {
            this.progressPos = BlockPosUtil.read(compound, "newProgressPos");
            this.progressStage = BuildingStructureHandler.Stage.values()[compound.func_74762_e("newProgressStage")];
        }
        if (compound.func_74764_b("fluidsToRemove")) {
            this.fluidsToRemove.clear();
            ListNBT fluidsToRemove = (ListNBT)compound.func_74781_a("fluidsToRemove");
            fluidsToRemove.forEach(fluidsRemove -> {
                int y = ((CompoundNBT)fluidsRemove).func_74762_e("yLevel");
                ListNBT positions = (ListNBT)((CompoundNBT)fluidsRemove).func_74781_a("positions");
                ArrayList<BlockPos> fluids = new ArrayList<BlockPos>();
                for (int i = 0; i < positions.size(); ++i) {
                    fluids.add(BlockPosUtil.readFromListNBT(positions, i));
                }
                this.fluidsToRemove.put(y, fluids);
            });
        }
        this.currentStage = compound.func_74762_e("currStage");
        this.totalStages = compound.func_74762_e("totalStages");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.progressPos != null) {
            BlockPosUtil.write(compound, "newProgressPos", this.progressPos);
            compound.func_74768_a("newProgressStage", this.progressStage.ordinal());
        }
        ListNBT fluidsToRemove = new ListNBT();
        this.fluidsToRemove.forEach((y, fluids) -> {
            CompoundNBT fluidsRemove = new CompoundNBT();
            ListNBT positions = new ListNBT();
            fluids.forEach(fluid -> BlockPosUtil.writeToListNBT(positions, fluid));
            fluidsRemove.func_218657_a("positions", (INBT)positions);
            fluidsRemove.func_74768_a("yLevel", y.intValue());
            fluidsToRemove.add((Object)fluidsRemove);
        });
        compound.func_218657_a("fluidsToRemove", (INBT)fluidsToRemove);
        compound.func_74768_a("totalStages", this.totalStages);
        compound.func_74768_a("currStage", this.currentStage);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        double qty = 0.0;
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            buf.func_150788_a(resource.getItemStack());
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
            qty += (double)resource.getAmount();
        }
        ICitizenData data = this.getMainCitizen();
        if (data != null && data.getJob() instanceof AbstractJobStructure) {
            AbstractJobStructure structureBuilderJob = (AbstractJobStructure)data.getJob();
            WorkOrderBuildDecoration workOrderBuildDecoration = structureBuilderJob.getWorkOrder();
            if (workOrderBuildDecoration != null) {
                String desc;
                BlockPos pos = workOrderBuildDecoration.getBuildingLocation();
                String name = workOrderBuildDecoration instanceof WorkOrderBuild ? ((WorkOrderBuild)workOrderBuildDecoration).getUpgradeName() : workOrderBuildDecoration.getName();
                buf.func_180714_a(name);
                if (pos.equals((Object)this.getPosition())) {
                    desc = "here";
                } else {
                    BlockPos relativePos = this.getPosition().func_177973_b((Vec3i)pos);
                    Direction facingX = Direction.func_176737_a((float)relativePos.func_177958_n(), (float)0.0f, (float)0.0f);
                    Direction facingZ = Direction.func_176737_a((float)0.0f, (float)0.0f, (float)relativePos.func_177952_p());
                    desc = relativePos.func_177958_n() + " " + facingX + " " + relativePos.func_177952_p() + " " + facingZ;
                }
                buf.func_180714_a(desc);
                buf.writeDouble(workOrderBuildDecoration.getAmountOfRes() == 0 ? 0.0 : qty / (double)workOrderBuildDecoration.getAmountOfRes());
                buf.writeInt(this.totalStages);
                buf.writeInt(this.currentStage);
            } else {
                buf.func_180714_a("-");
                buf.func_180714_a("");
                buf.writeDouble(0.0);
                buf.writeInt(0);
                buf.writeInt(0);
            }
        } else {
            buf.func_180714_a("-");
            buf.func_180714_a("");
            buf.writeDouble(0.0);
            buf.writeInt(0);
            buf.writeInt(0);
        }
        buf.func_180714_a(this.getMainCitizen() == null || this.colony.getCitizenManager().getCivilian(this.getMainCitizen().getId()) == null ? "" : this.getMainCitizen().getName());
    }

    private void updateAvailableResources() {
        this.getMainCitizenEntity().ifPresent(structureBuilder -> {
            InventoryCitizen structureBuilderInventory = this.getMainCitizen().getInventory();
            if (structureBuilderInventory == null) {
                return;
            }
            for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
                BuildingBuilderResource resource = entry.getValue();
                resource.setAvailable(0);
                if (structureBuilderInventory != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)structureBuilderInventory, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if (this.getTileEntity() == null) continue;
                resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
            }
        });
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    @Nullable
    public BuilderBucket getRequiredResources() {
        return this.buckets.isEmpty() ? null : this.buckets.getFirst();
    }

    public BuildingBuilderResource getResourceFromIdentifier(String res) {
        return this.neededResources.get(res);
    }

    public boolean hasResourceInBucket(ItemStack stack) {
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        String key = stack.func_77977_a() + "-" + hashCode;
        return this.getRequiredResources() != null && this.getRequiredResources().getResourceMap().containsKey(key);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        String key = res.func_77977_a() + "-" + hashCode;
        BuildingBuilderResource resource = this.neededResources.get(key);
        if (resource == null) {
            resource = new BuildingBuilderResource(res, amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(key, resource);
        BuilderBucket last = this.buckets.isEmpty() ? null : this.buckets.removeLast();
        int stacks = (int)Math.ceil((double)amount / (double)res.func_77976_d());
        int max = this.getMainCitizen().getInventory().getSlots() - 9;
        if (last == null || last.getTotalStacks() >= max || last.getTotalStacks() + stacks >= max) {
            if (last != null) {
                this.buckets.add(last);
            }
            last = new BuilderBucket();
            last.setTotalStacks(stacks);
            last.addOrAdjustResource(key, amount);
            this.buckets.add(last);
        } else {
            int currentQty = last.getResourceMap().getOrDefault(key, 0);
            int currentStacks = (int)Math.ceil((double)currentQty / (double)res.func_77976_d());
            int newStacks = (int)Math.ceil((double)(currentQty + amount) / (double)res.func_77976_d());
            Map<String, Integer> map = last.getResourceMap();
            last.setTotalStacks(last.getTotalStacks() + newStacks - currentStacks);
            last.addOrAdjustResource(key, currentQty + amount);
            this.buckets.add(last);
        }
        this.markDirty();
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        BuilderBucket last;
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        String name = res.func_77977_a() + "-" + hashCode;
        BuilderBucket builderBucket = last = this.buckets.isEmpty() ? null : this.getRequiredResources();
        if (last != null) {
            Map<String, Integer> map = last.getResourceMap();
            if (map.containsKey(name)) {
                int qty = map.get(name) - amount;
                if (qty > 0) {
                    last.addOrAdjustResource(name, map.get(name) - amount);
                } else {
                    last.removeResources(name);
                }
            }
            if (map.isEmpty()) {
                this.buckets.remove();
            }
        }
        int preAmount = 0;
        if (this.neededResources.containsKey(name)) {
            preAmount = this.neededResources.get(name).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(name);
        } else {
            this.neededResources.get(name).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap<String, BuildingBuilderResource>();
        this.buckets.clear();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        return this.neededResources.containsKey(stack.func_77977_a() + "-" + hashCode);
    }

    public abstract void searchWorkOrder();

    public void setProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
        this.progressPos = blockPos;
        if (this.progressCounter > 50 || blockPos == null || stage != this.progressStage) {
            this.markDirty();
            this.progressCounter = 0;
        } else {
            ++this.progressCounter;
        }
        this.progressStage = stage;
    }

    @Nullable
    public Tuple<BlockPos, BuildingStructureHandler.Stage> getProgress() {
        if (this.progressPos == null) {
            return null;
        }
        return new Tuple<BlockPos, BuildingStructureHandler.Stage>(this.progressPos, this.progressStage);
    }

    public Map<Integer, List<BlockPos>> getFluidsToRemove() {
        return this.fluidsToRemove;
    }

    public void checkOrRequestBucket(@Nullable BuilderBucket requiredResources, ICitizenData worker, boolean workerInv) {
        if (requiredResources == null) {
            return;
        }
        ImmutableList list = this.getOpenRequestsOfType(worker, TypeToken.of(Stack.class));
        for (Map.Entry<String, Integer> entry : requiredResources.getResourceMap().entrySet()) {
            int requestCount;
            ItemStorage itemStack = this.neededResources.get(entry.getKey());
            if (itemStack == null) continue;
            boolean hasOpenRequest = false;
            int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null), stack -> stack.func_77969_a(itemStack.getItemStack()));
            int totalAmount = this.neededResources.containsKey(entry.getKey()) ? this.neededResources.get(entry.getKey()).getAmount() : 0;
            int workerInvCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventory(), stack -> stack.func_77969_a(itemStack.getItemStack()));
            if ((!workerInv || count + workerInvCount >= entry.getValue()) && (count >= entry.getValue() || count + workerInvCount >= totalAmount) || (requestCount = entry.getValue() - count - (workerInv ? workerInvCount : 0)) <= 0) continue;
            for (IRequest request : list) {
                if (!((Stack)request.getRequest()).getStack().func_77969_a(itemStack.getItemStack())) continue;
                hasOpenRequest = true;
                break;
            }
            if (hasOpenRequest) break;
            worker.createRequestAsync(new Stack(itemStack.getItemStack(), requestCount * this.getResourceBatchMultiplier(), requestCount));
        }
    }

    public void nextStage() {
        if (this.currentStage + 1 > this.totalStages) {
            ++this.totalStages;
        }
        ++this.currentStage;
    }

    public void setTotalStages(int total) {
        this.totalStages = total;
        this.currentStage = 0;
    }

    @Nullable
    public BuilderBucket getNextBucket() {
        Iterator<BuilderBucket> iterator = this.buckets.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

