/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.IBuildingWorkerView;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ClassicRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.MultiOutputRecipe;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PrivateWorkerCraftingRequestResolver;
import com.minecolonies.coremod.network.messages.server.colony.building.worker.BuildingHiringModeMessage;
import com.minecolonies.coremod.research.MultiplierModifierResearchEffect;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingWorker
extends AbstractBuilding
implements IBuildingWorker {
    private static final double BASE_CHANCE = 0.0625;
    private static final int EXTRA_RECIPE_MULTIPLIER = 5;
    private static final String REDUCEABLE = "reduceable";
    protected final List<IToken<?>> recipes = new ArrayList();
    private HiringMode hiringMode = HiringMode.DEFAULT;
    private String jobDisplayName = "";

    public AbstractBuildingWorker(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return false;
        }
        for (ICitizenData data : this.getAssignedCitizen()) {
            for (IRequest request : this.getOpenRequests(data)) {
                for (ItemStack deliveryStack : request.getDeliveries()) {
                    if (!deliveryStack.func_185136_b(stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        this.markDirty();
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        toKeep.put(ItemStackUtils.CAN_EAT, (Tuple<Integer, Boolean>)new Tuple((Object)(this.getBuildingLevel() * 2), (Object)true));
        return toKeep;
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack stack) {
        return this.getFirstRecipe((ItemStack itemStack) -> !itemStack.func_190926_b() && itemStack.func_77969_a(stack));
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        IRecipeStorage foundRecipe = null;
        HashMap<IRecipeStorage, Integer> candidates = new HashMap<IRecipeStorage, Integer>();
        for (IToken<?> iToken : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(iToken);
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput()) && !storage.getAlternateOutputs().stream().anyMatch(i -> stackPredicate.test((ItemStack)i))) continue;
            if (foundRecipe == null) {
                foundRecipe = storage;
            }
            candidates.put(storage, 0);
        }
        if (candidates.size() > 1) {
            for (Map.Entry entry : candidates.entrySet()) {
                ItemStorage checkItem = ((IRecipeStorage)entry.getKey()).getCleanedInput().stream().max(Comparator.comparingInt(ItemStorage::getAmount)).get();
                candidates.put((IRecipeStorage)entry.getKey(), this.getWarehouseCount(checkItem));
            }
            foundRecipe = (IRecipeStorage)candidates.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
        }
        if (foundRecipe != null && foundRecipe.getRecipeType() instanceof MultiOutputRecipe) {
            foundRecipe = foundRecipe.getClassicForMultiOutput(stackPredicate);
        }
        return foundRecipe;
    }

    protected int getWarehouseCount(ItemStorage item) {
        int count = 0;
        List<IWareHouse> wareHouses = this.colony.getBuildingManager().getWareHouses();
        for (IWareHouse wareHouse : wareHouses) {
            count += InventoryUtils.getCountFromBuilding((IBuilding)wareHouse, item);
        }
        return count;
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(ItemStack tempStack, boolean considerReservation) {
        return this.getFirstFullFillableRecipe(tempStack, tempStack.func_190916_E(), considerReservation);
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(ItemStack tempStack, int count, boolean considerReservation) {
        return this.getFirstFullFillableRecipe((ItemStack itemStack) -> !itemStack.func_190926_b() && itemStack.func_77969_a(tempStack), count * tempStack.func_190916_E(), considerReservation);
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
        for (IToken<?> token : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput()) && !storage.getAlternateOutputs().stream().anyMatch(i -> stackPredicate.test((ItemStack)i))) continue;
            List<IItemHandler> handlers = this.getHandlers();
            IRecipeStorage toTest = storage.getRecipeType() instanceof MultiOutputRecipe ? storage.getClassicForMultiOutput(stackPredicate) : storage;
            if (!toTest.canFullFillRecipe(count, Collections.emptyMap(), handlers.toArray(new IItemHandler[0]))) continue;
            return toTest;
        }
        return null;
    }

    @Override
    public boolean fullFillRecipe(IRecipeStorage storage) {
        List<IItemHandler> handlers = this.getHandlers();
        return storage.fullfillRecipe(handlers);
    }

    @Override
    public void switchIndex(int i, int j) {
        if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IToken<?> storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
        }
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> ignored) {
        return this.hasSpaceForMoreRecipes();
    }

    protected Optional<Boolean> canRecipeBeAddedBasedOnTags(IToken<?> token) {
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        return this.canRecipeBeAddedBasedOnTags(storage);
    }

    protected Optional<Boolean> canRecipeBeAddedBasedOnTags(IRecipeStorage storage) {
        if (storage == null) {
            return Optional.of(false);
        }
        String crafterName = this.getJobName().toLowerCase();
        if (ModTags.crafterProductExclusions.containsKey(crafterName) && ModTags.crafterProductExclusions.get(crafterName).func_199685_a_((Object)storage.getPrimaryOutput().func_77973_b())) {
            return Optional.of(false);
        }
        if (ModTags.crafterProduct.containsKey(crafterName) && ModTags.crafterProduct.get(crafterName).func_199685_a_((Object)storage.getPrimaryOutput().func_77973_b())) {
            return Optional.of(true);
        }
        for (ItemStack stack : storage.getInput()) {
            if (!ModTags.crafterIngredientExclusions.containsKey(crafterName) || !ModTags.crafterIngredientExclusions.get(crafterName).func_199685_a_((Object)stack.func_77973_b())) continue;
            return Optional.of(false);
        }
        for (ItemStack stack : storage.getInput()) {
            if (!ModTags.crafterIngredient.containsKey(crafterName) || !ModTags.crafterIngredient.get(crafterName).func_199685_a_((Object)stack.func_77973_b())) continue;
            return Optional.of(true);
        }
        return Optional.empty();
    }

    public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
        List inputs = recipe.getCleanedInput().stream().sorted(Comparator.comparingInt(ItemStorage::getAmount).reversed()).collect(Collectors.toList());
        double actualChance = Math.min(5.0, 0.0625 * (double)count + 0.0625 * (double)citizen.getCitizenSkillHandler().getLevel(this.getRecipeImprovementSkill()));
        double roll = citizen.getRandom().nextDouble() * 100.0;
        ItemStack reducedItem = null;
        if (roll <= actualChance && ModTags.crafterProductExclusions.containsKey(REDUCEABLE) && !ModTags.crafterProductExclusions.get(REDUCEABLE).func_199685_a_((Object)recipe.getPrimaryOutput().func_77973_b())) {
            ArrayList<ItemStack> newRecipe = new ArrayList<ItemStack>();
            boolean didReduction = false;
            for (ItemStorage input : inputs) {
                if (input.getAmount() > 1 && ModTags.crafterIngredient.containsKey(REDUCEABLE) && ModTags.crafterIngredient.get(REDUCEABLE).func_199685_a_((Object)input.getItem())) {
                    reducedItem = input.getItemStack();
                    reducedItem.func_190920_e(input.getAmount() - 1);
                    newRecipe.add(reducedItem);
                    didReduction = true;
                    continue;
                }
                newRecipe.add(input.getItemStack());
            }
            if (didReduction) {
                IRecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{newRecipe, 1, recipe.getPrimaryOutput(), Blocks.field_150350_a});
                this.replaceRecipe(recipe.getToken(), IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(storage));
                TranslationTextComponent message = new TranslationTextComponent("com.minecolonies.coremod.crafters.recipeimproved." + citizen.getRandom().nextInt(3), new Object[]{new TranslationTextComponent(citizen.getJob().getName().toLowerCase(), new Object[0]), recipe.getPrimaryOutput().func_200301_q(), reducedItem.func_200301_q(), citizen.getName()});
                for (PlayerEntity player : this.colony.getMessagePlayerEntities()) {
                    player.func_145747_a((ITextComponent)message);
                }
            }
        }
    }

    @Override
    @NotNull
    public Skill getRecipeImprovementSkill() {
        return this.getSecondarySkill();
    }

    @Override
    public boolean isRecipeAlterationAllowed() {
        return true;
    }

    private boolean hasSpaceForMoreRecipes() {
        return this.getMaxRecipes() > this.getRecipes().size();
    }

    protected int getMaxRecipes() {
        double increase = 1.0;
        MultiplierModifierResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Recipes", MultiplierModifierResearchEffect.class);
        if (effect != null) {
            increase = 1.0 + effect.getEffect();
        }
        if (this.canCraftComplexRecipes()) {
            increase *= 5.0;
        }
        return (int)(Math.pow(2.0, this.getBuildingLevel()) * increase);
    }

    @Override
    public List<IToken<?>> getRecipes() {
        return new ArrayList(this.recipes);
    }

    @Override
    public List<IItemHandler> getHandlers() {
        IColony colony = this.getColony();
        if (this.getAssignedEntities().isEmpty() || colony == null || colony.getWorld() == null) {
            return Collections.emptyList();
        }
        HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
        for (ICitizenData workerEntity : this.getAssignedCitizen()) {
            handlers.add(workerEntity.getInventory());
        }
        for (BlockPos pos : this.getContainers()) {
            TileEntity entity = colony.getWorld().func_175625_s(pos);
            if (entity == null) continue;
            LazyOptional handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            handler.ifPresent(handlers::add);
        }
        return ImmutableList.copyOf(handlers);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            citizen.getWorkBuilding().removeCitizen(citizen);
        }
        if (!super.assignCitizen(citizen)) {
            Log.getLogger().warn("Unable to assign citizen:" + citizen.getName() + " to building:" + this.getSchematicName() + " jobname:" + this.getJobName());
            return false;
        }
        if (citizen != null) {
            citizen.setWorkBuilding(this);
            citizen.getJob().onLevelUp();
            this.colony.getProgressManager().progressEmploy(this.colony.getCitizenManager().getCitizens().stream().filter(citizenData -> citizenData.getJob() != null).collect(Collectors.toList()).size());
        }
        return true;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        int i;
        super.deserializeNBT(compound);
        if (compound.func_150296_c().contains("worker")) {
            try {
                ListNBT workersTagList = compound.func_150295_c("worker", 10);
                for (i = 0; i < workersTagList.size(); ++i) {
                    ICitizenData data = workersTagList.func_150305_b(i).func_150296_c().contains("id") ? this.getColony().getCitizenManager().getCivilian(workersTagList.func_150305_b(i).func_74762_e("id")) : (workersTagList.func_150305_b(i).func_150296_c().contains("workerId") ? this.getColony().getCitizenManager().getCivilian(workersTagList.func_150305_b(i).func_74762_e("workerId")) : null);
                    if (data == null) continue;
                    this.assignCitizen(data);
                }
            }
            catch (Exception e) {
                Log.getLogger().warn("Warning: Updating data structures:", (Throwable)e);
                ICitizenData worker = this.getColony().getCitizenManager().getCivilian(compound.func_74762_e("worker"));
                this.assignCitizen(worker);
            }
        }
        this.hiringMode = HiringMode.values()[compound.func_74762_e("buildingHiringMode")];
        ListNBT recipesTags = compound.func_150295_c("recipes", 10);
        for (i = 0; i < recipesTags.size(); ++i) {
            IToken token = (IToken)StandardFactoryController.getInstance().deserialize(recipesTags.func_150305_b(i));
            if (this.recipes.contains(token)) continue;
            this.recipes.add(token);
            IColonyManager.getInstance().getRecipeManager().registerUse(token);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT workersTagList = new ListNBT();
        for (ICitizenData data : this.getAssignedCitizen()) {
            if (data == null) continue;
            CompoundNBT idCompound = new CompoundNBT();
            idCompound.func_74768_a("workerId", data.getId());
            workersTagList.add((Object)idCompound);
        }
        compound.func_218657_a("worker", (INBT)workersTagList);
        compound.func_74768_a("buildingHiringMode", this.hiringMode.ordinal());
        ListNBT recipesTagList = this.recipes.stream().map(iToken -> StandardFactoryController.getInstance().serialize(iToken)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("recipes", (INBT)recipesTagList);
        return compound;
    }

    @Override
    public void onWakeUp() {
    }

    @Override
    public boolean addRecipe(IToken<?> token) {
        if (this.canRecipeBeAdded(token)) {
            this.addRecipeToList(token);
            this.markDirty();
            IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (recipeStorage != null) {
                this.colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
            }
            return true;
        }
        return false;
    }

    public void addRecipeToList(IToken<?> token) {
        if (!this.recipes.contains(token)) {
            this.recipes.add(token);
        }
    }

    @Override
    public void removeRecipe(IToken<?> token) {
        if (this.recipes.remove(token)) {
            this.markDirty();
        } else {
            Log.getLogger().warn("Failure to remove recipe, please tell the mod authors about this");
            this.recipes.clear();
        }
    }

    public void replaceRecipe(IToken<?> oldRecipe, IToken<?> newRecipe) {
        if (this.recipes.contains(oldRecipe)) {
            int oldIndex = this.recipes.indexOf(oldRecipe);
            this.recipes.add(oldIndex, newRecipe);
            this.recipes.remove(oldRecipe);
            this.markDirty();
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        ICitizenData joblessCitizen;
        super.onColonyTick(colony);
        this.checkForWorkerSpecificRecipes();
        if (!this.isFull() && (this.getBuildingLevel() > 0 && this.isBuilt() || this instanceof BuildingBuilder) && (this.hiringMode == HiringMode.DEFAULT && !this.getColony().isManualHiring() || this.hiringMode == HiringMode.AUTO) && (joblessCitizen = this.getColony().getCitizenManager().getJoblessCitizen()) != null) {
            this.assignCitizen(joblessCitizen);
        }
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (this.isCitizenAssigned(citizen)) {
            super.removeCitizen(citizen);
            citizen.setWorkBuilding(null);
            this.cancelAllRequestsOfCitizen(citizen);
            citizen.setVisibleStatus(null);
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.getAssignedCitizen().size());
        for (ICitizenData data : this.getAssignedCitizen()) {
            buf.writeInt(data == null ? 0 : data.getId());
        }
        ArrayList<IRecipeStorage> storages = new ArrayList<IRecipeStorage>();
        for (IToken<?> token : new ArrayList(this.recipes)) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (storage == null) {
                this.removeRecipe(token);
                continue;
            }
            storages.add(storage);
        }
        buf.writeInt(storages.size());
        for (IRecipeStorage storage : storages) {
            buf.func_150786_a(StandardFactoryController.getInstance().serialize(storage));
        }
        buf.writeBoolean(this.canCraftComplexRecipes());
        buf.writeInt(this.hiringMode.ordinal());
        buf.func_180714_a(this.getJobName());
        buf.writeInt(this.getMaxInhabitants());
        buf.writeInt(this.getPrimarySkill().ordinal());
        buf.writeInt(this.getSecondarySkill().ordinal());
        buf.writeInt(this.getMaxInhabitants());
        buf.writeBoolean(this.isRecipeAlterationAllowed());
        buf.func_180714_a(this.jobDisplayName);
        buf.writeInt(this.getMaxRecipes());
    }

    @Override
    public int getMaxToolLevel() {
        if (this.getBuildingLevel() >= this.getMaxBuildingLevel()) {
            return 32;
        }
        if (this.getBuildingLevel() <= 0) {
            return 0;
        }
        return this.getBuildingLevel() - 0;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return this.getBuildingLevel() >= this.getMaxBuildingLevel();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of((Object)new BuildingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), (Object)new PrivateWorkerCraftingRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)), (Object)new PrivateWorkerCraftingProductionResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return false;
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBoolean(AbstractBuildingWorker.this.canCraftComplexRecipes());
                buffer.func_179255_a(AbstractBuildingWorker.this.getID());
                return new ContainerCrafting(id, inv, buffer);
            }
        }, buffer -> new PacketBuffer(buffer.writeBoolean(this.canCraftComplexRecipes())).func_179255_a(this.getID()));
    }

    @Override
    public void onBuildingMove(IBuilding oldBuilding) {
        super.onBuildingMove(oldBuilding);
        List<ICitizenData> workers = oldBuilding.getAssignedCitizen();
        for (ICitizenData citizen : workers) {
            citizen.setWorkBuilding(null);
            citizen.setWorkBuilding(this);
            this.assignCitizen(citizen);
        }
    }

    @Override
    public boolean canEat(ItemStack stack) {
        return true;
    }

    public void checkForWorkerSpecificRecipes() {
        for (CustomRecipe newRecipe : CustomRecipeManager.getInstance().getRecipes(this.getJobName())) {
            IRecipeStorage recipeStorage = newRecipe.getRecipeStorage();
            IToken<?> recipeToken = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(recipeStorage);
            if (newRecipe.isValidForBuilding(this)) {
                IToken<?> duplicateFound = null;
                boolean forceReplace = false;
                for (IToken<?> token : this.recipes) {
                    if (token == recipeToken) {
                        duplicateFound = token;
                        break;
                    }
                    IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                    if (storage == null || !storage.getPrimaryOutput().equals(recipeStorage.getPrimaryOutput(), true)) continue;
                    List<ItemStorage> recipeInput1 = storage.getCleanedInput();
                    List<ItemStorage> recipeInput2 = recipeStorage.getCleanedInput();
                    if (recipeInput1.size() != recipeInput2.size()) continue;
                    if (recipeInput1.size() > 1) {
                        recipeInput1.sort(Comparator.comparing(item -> Objects.hash(item.hashCode(), item.getAmount())));
                        recipeInput2.sort(Comparator.comparing(item -> Objects.hash(item.hashCode(), item.getAmount())));
                    }
                    boolean allMatch = true;
                    for (int i = 0; i < recipeInput1.size(); ++i) {
                        if (recipeInput1.get(i).getItem().equals(recipeInput2.get(i).getItem())) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    duplicateFound = token;
                    if (storage.getRecipeType() instanceof ClassicRecipe && recipeStorage.getRecipeType() instanceof MultiOutputRecipe) {
                        forceReplace = true;
                    }
                    if (storage.getRecipeSource() == null || !storage.getRecipeSource().equals((Object)recipeStorage.getRecipeSource())) break;
                    forceReplace = true;
                    break;
                }
                if (duplicateFound == null) {
                    this.addRecipeToList(recipeToken);
                    this.colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
                    continue;
                }
                if (!forceReplace && !newRecipe.getMustExist() || duplicateFound == recipeToken) continue;
                this.replaceRecipe(duplicateFound, recipeToken);
                this.colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
                List<ItemStack> alternates = recipeStorage.getAlternateOutputs();
                for (IToken<?> token : this.getRecipes()) {
                    IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
                    if (!(storage.getRecipeType() instanceof ClassicRecipe) || !ItemStackUtils.compareItemStackListIgnoreStackSize(alternates, storage.getPrimaryOutput(), false, true)) continue;
                    this.removeRecipe(token);
                }
                this.colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && recipeStorage.getAlternateOutputs().stream().anyMatch(i -> ((IDeliverable)request.getRequest()).matches((ItemStack)i)));
                continue;
            }
            if (!this.recipes.contains(recipeToken)) continue;
            this.removeRecipe(recipeToken);
        }
        this.markDirty();
    }

    public String getJobDisplayName() {
        return this.jobDisplayName;
    }

    public void setJobDisplayName(String jobDisplayName) {
        if (this.jobDisplayName.isEmpty()) {
            this.jobDisplayName = jobDisplayName;
        }
    }

    public static class View
    extends AbstractBuildingView
    implements IBuildingWorkerView {
        private final Set<Integer> workerIDs = new HashSet<Integer>();
        private final List<IRecipeStorage> recipes = new ArrayList<IRecipeStorage>();
        private boolean canCraftComplexRecipes;
        private HiringMode hiringMode;
        private String jobName;
        private int maxInhabitants = 1;
        private Skill primary = Skill.Intelligence;
        private Skill secondary = Skill.Intelligence;
        private int maxRecipes;
        private boolean isRecipeAlterationAllowed;
        private String jobDisplayName;

        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        public List<Integer> getWorkerId() {
            return new ArrayList<Integer>(this.workerIDs);
        }

        @Override
        public void addWorkerId(int workerId) {
            this.workerIDs.add(workerId);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            this.workerIDs.clear();
            for (int i = 0; i < size; ++i) {
                this.workerIDs.add(buf.readInt());
            }
            this.recipes.clear();
            int recipesSize = buf.readInt();
            for (int i = 0; i < recipesSize; ++i) {
                IRecipeStorage storage = (IRecipeStorage)StandardFactoryController.getInstance().deserialize(buf.func_150793_b());
                if (storage == null) continue;
                this.recipes.add(storage);
            }
            this.canCraftComplexRecipes = buf.readBoolean();
            this.hiringMode = HiringMode.values()[buf.readInt()];
            this.jobName = buf.func_150789_c(Short.MAX_VALUE);
            this.maxInhabitants = buf.readInt();
            this.primary = Skill.values()[buf.readInt()];
            this.secondary = Skill.values()[buf.readInt()];
            this.maxInhabitants = buf.readInt();
            this.isRecipeAlterationAllowed = buf.readBoolean();
            this.jobDisplayName = buf.func_218666_n();
            this.maxRecipes = buf.readInt();
        }

        @Override
        public List<IRecipeStorage> getRecipes() {
            return new ArrayList<IRecipeStorage>(this.recipes);
        }

        @Override
        public void removeRecipe(int i) {
            if (i < this.recipes.size() && i >= 0) {
                this.recipes.remove(i);
            }
        }

        @Override
        public void switchIndex(int i, int j) {
            if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
                IRecipeStorage storage = this.recipes.get(i);
                this.recipes.set(i, this.recipes.get(j));
                this.recipes.set(j, storage);
            }
        }

        @Override
        @NotNull
        public Skill getPrimarySkill() {
            return this.primary;
        }

        @Override
        @NotNull
        public Skill getSecondarySkill() {
            return this.secondary;
        }

        @Override
        public void removeWorkerId(int id) {
            this.workerIDs.remove(id);
        }

        @Override
        public boolean hasEnoughWorkers() {
            return !this.workerIDs.isEmpty();
        }

        @Override
        public boolean canCraftComplexRecipes() {
            return this.canCraftComplexRecipes;
        }

        @Override
        public boolean canRecipeBeAdded() {
            return this.getMaxRecipes() > this.getRecipes().size();
        }

        public int getMaxRecipes() {
            return this.maxRecipes;
        }

        @Override
        public boolean isRecipeAlterationAllowed() {
            return this.isRecipeAlterationAllowed;
        }

        @Override
        public HiringMode getHiringMode() {
            return this.hiringMode;
        }

        @Override
        public void setHiringMode(HiringMode hiringMode) {
            this.hiringMode = hiringMode;
            Network.getNetwork().sendToServer(new BuildingHiringModeMessage(this, hiringMode));
        }

        @Override
        public String getJobName() {
            return this.jobName;
        }

        public boolean canAssign(ICitizenDataView citizenDataView) {
            return true;
        }

        public int getMaxInhabitants() {
            return this.maxInhabitants;
        }

        @Override
        public String getJobDisplayName() {
            return this.jobDisplayName;
        }
    }
}

