/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFilterableListBuilding
extends AbstractBuildingWorker {
    private static final String TAG_ITEMLIST = "itemList";
    private final Map<String, List<ItemStorage>> itemsAllowed = new HashMap<String, List<ItemStorage>>();

    public AbstractFilterableListBuilding(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT filterableList = compound.func_150295_c(TAG_ITEMLIST, 10);
        for (int i = 0; i < filterableList.size(); ++i) {
            try {
                CompoundNBT listItem = filterableList.func_150305_b(i);
                String id = listItem.func_74779_i("id");
                ListNBT filterableItems = listItem.func_150295_c(TAG_ITEMLIST, 10);
                ArrayList<ItemStorage> items = new ArrayList<ItemStorage>();
                for (int j = 0; j < filterableItems.size(); ++j) {
                    items.add(new ItemStorage(ItemStack.func_199557_a((CompoundNBT)filterableItems.func_150305_b(j))));
                }
                if (items.isEmpty()) continue;
                this.itemsAllowed.put(id, items);
                continue;
            }
            catch (Exception e) {
                Log.getLogger().info("Removing incompatible stack");
            }
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT filterableListCompound = new ListNBT();
        for (Map.Entry<String, List<ItemStorage>> entry : this.itemsAllowed.entrySet()) {
            CompoundNBT listCompound = new CompoundNBT();
            listCompound.func_74778_a("id", entry.getKey());
            ListNBT filteredItems = new ListNBT();
            for (ItemStorage item : entry.getValue()) {
                CompoundNBT itemCompound = new CompoundNBT();
                item.getItemStack().func_77955_b(itemCompound);
                filteredItems.add((Object)itemCompound);
            }
            listCompound.func_218657_a(TAG_ITEMLIST, (INBT)filteredItems);
            filterableListCompound.add((Object)listCompound);
        }
        compound.func_218657_a(TAG_ITEMLIST, (INBT)filterableListCompound);
        return compound;
    }

    public void addItem(String id, ItemStorage item) {
        if (this.itemsAllowed.containsKey(id)) {
            if (!this.itemsAllowed.get(id).contains(item)) {
                List<ItemStorage> list = this.itemsAllowed.get(id);
                list.add(item);
                this.itemsAllowed.put(id, list);
            }
        } else {
            ArrayList<ItemStorage> list = new ArrayList<ItemStorage>();
            list.add(item);
            this.itemsAllowed.put(id, list);
        }
        this.markDirty();
    }

    public boolean isAllowedItem(String id, ItemStorage item) {
        return this.itemsAllowed.containsKey(id) && this.itemsAllowed.get(id).contains(item);
    }

    public void removeItem(String id, ItemStorage item) {
        if (this.itemsAllowed.containsKey(id) && this.itemsAllowed.get(id).contains(item)) {
            List<ItemStorage> list = this.itemsAllowed.get(id);
            list.remove(item);
            this.itemsAllowed.put(id, list);
        }
        this.markDirty();
    }

    public Map<String, List<ItemStorage>> getCopyOfAllowedItems() {
        return new HashMap<String, List<ItemStorage>>(this.itemsAllowed);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeInt(this.itemsAllowed.size());
        for (Map.Entry<String, List<ItemStorage>> entry : this.itemsAllowed.entrySet()) {
            buf.func_180714_a(entry.getKey());
            buf.writeInt(entry.getValue().size());
            for (ItemStorage item : entry.getValue()) {
                buf.func_150788_a(item.getItemStack());
            }
        }
    }
}

