/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.util.BuildingUtils;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class AbstractSchematicProvider
implements ISchematicProvider {
    private final IColony colony;
    private final BlockPos location;
    private int buildingLevel = 0;
    private boolean isBuildingMirrored = false;
    private String style = "wooden";
    private int height;
    private boolean isDeconstructed;
    private int cornerX1;
    private int cornerX2;
    private int cornerZ1;
    private int cornerZ2;
    public int cachedRotation = -1;
    private AxisAlignedBB buildingArea = null;
    private boolean dirty = false;

    public AbstractSchematicProvider(BlockPos pos, IColony colony) {
        this.location = pos;
        this.colony = colony;
    }

    public int hashCode() {
        return (int)(31L * this.getID().func_218275_a());
    }

    public boolean equals(Object o) {
        return o instanceof AbstractBuilding && ((IBuilding)o).getID().equals((Object)this.getID());
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }

    @Override
    public void setDeconstructed() {
        this.isDeconstructed = true;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        BlockPosUtil.write(compound, "location", this.location);
        StructureName structureName = new StructureName("schematics", this.style, this.getSchematicName() + this.buildingLevel);
        if (Structures.hasMD5((StructureName)structureName)) {
            compound.func_74778_a("schematicMD5", Structures.getMD5((String)structureName.toString()));
        }
        compound.func_74768_a("level", this.buildingLevel);
        compound.func_74778_a("style", this.style);
        compound.func_74757_a("mirror", this.isBuildingMirrored);
        compound.func_74768_a("corner1", this.cornerX1);
        compound.func_74768_a("corner2", this.cornerX2);
        compound.func_74768_a("corner3", this.cornerZ1);
        compound.func_74768_a("corner4", this.cornerZ2);
        compound.func_74768_a("height", this.height);
        compound.func_74768_a("rotation", this.getRotation());
        compound.func_74757_a("deconstructed", this.isDeconstructed);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.buildingLevel = compound.func_74762_e("level");
        this.style = compound.func_74779_i("style");
        this.deserializerStructureInformationFrom(compound);
        this.isBuildingMirrored = compound.func_74767_n("mirror");
        if (compound.func_150296_c().contains("corner1")) {
            this.cornerX1 = compound.func_74762_e("corner1");
            this.cornerX2 = compound.func_74762_e("corner2");
            this.cornerZ1 = compound.func_74762_e("corner3");
            this.cornerZ2 = compound.func_74762_e("corner4");
        }
        if (compound.func_74764_b("height")) {
            this.height = compound.func_74762_e("height");
        }
        if (compound.func_74764_b("rotation")) {
            this.cachedRotation = compound.func_74762_e("rotation");
        }
        this.isDeconstructed = compound.func_74764_b("deconstructed") ? compound.func_74767_n("deconstructed") : false;
    }

    private void deserializerStructureInformationFrom(CompoundNBT compound) {
        StructureName newStructureName;
        String md5 = compound.func_74779_i("schematicMD5");
        int testLevel = this.buildingLevel == 0 ? 1 : this.buildingLevel;
        StructureName sn = new StructureName("schematics", this.style, this.getSchematicName() + testLevel);
        if (!Structures.hasMD5((StructureName)sn) && (newStructureName = Structures.getStructureNameByMD5((String)md5)) != null && newStructureName.getPrefix().equals(sn.getPrefix()) && newStructureName.getSchematic().equals(sn.getSchematic())) {
            this.style = newStructureName.getStyle();
            Log.getLogger().warn(String.format("AbstractBuilding.readFromNBT: %s have been moved to %s", sn, newStructureName));
        }
        if (this.style.isEmpty()) {
            Log.getLogger().warn("Loaded empty style, setting to wooden");
            this.style = "wooden";
        }
    }

    @Override
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    public void setCorners(int x1, int x2, int z1, int z2) {
        this.cornerX1 = x1;
        this.cornerX2 = x2;
        this.cornerZ1 = z1;
        this.cornerZ2 = z2;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Tuple<Tuple<Integer, Integer>, Tuple<Integer, Integer>> getCorners() {
        return new Tuple((Object)new Tuple((Object)this.cornerX1, (Object)this.cornerX2), (Object)new Tuple((Object)this.cornerZ1, (Object)this.cornerZ2));
    }

    @Override
    public BlockPos getID() {
        return this.location;
    }

    @Override
    public AxisAlignedBB getTargetableArea(World world) {
        if (this.buildingArea == null) {
            this.buildingArea = BuildingUtils.getTargetAbleArea(world, this);
        }
        return this.buildingArea;
    }

    @Override
    public int getRotation() {
        if (this.cachedRotation != -1) {
            return this.cachedRotation;
        }
        StructureName structureName = new StructureName("schematics", this.style, this.getSchematicName() + Math.max(1, this.buildingLevel));
        try {
            BlockState structureState;
            LoadOnlyStructureHandler structure = new LoadOnlyStructureHandler(this.colony.getWorld(), this.getPosition(), structureName.toString(), new PlacementSettings(), true);
            Blueprint blueprint = structure.getBluePrint();
            if (blueprint != null && (structureState = ((BlockInfo)structure.getBluePrint().getBlockInfoAsMap().get(structure.getBluePrint().getPrimaryBlockOffset())).getState()) != null) {
                int worldRotation;
                if (!(structureState.func_177230_c() instanceof AbstractBlockHut) || !(this.colony.getWorld().func_180495_p(this.location).func_177230_c() instanceof AbstractBlockHut)) {
                    Log.getLogger().error(String.format("Schematic %s doesn't have a correct Primary Offset", structureName.toString()));
                    return 0;
                }
                int structureRotation = ((Direction)structureState.func_177229_b((IProperty)AbstractBlockHut.FACING)).func_176736_b();
                this.cachedRotation = structureRotation <= (worldRotation = ((Direction)this.colony.getWorld().func_180495_p(this.location).func_177229_b((IProperty)AbstractBlockHut.FACING)).func_176736_b()) ? worldRotation - structureRotation : 4 + worldRotation - structureRotation;
                return this.cachedRotation;
            }
        }
        catch (Exception e) {
            Log.getLogger().error(String.format("Failed to get rotation for %s: ", structureName.toString()), (Throwable)e);
            return 0;
        }
        return 0;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
        this.cachedRotation = -1;
        this.markDirty();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public void setBuildingLevel(int level) {
        if (level > this.getMaxBuildingLevel()) {
            return;
        }
        this.isDeconstructed = false;
        this.buildingLevel = level;
        this.markDirty();
    }

    @Override
    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public void setIsMirrored(boolean isMirrored) {
        this.isBuildingMirrored = isMirrored;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }
}

