/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.views;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.HutRenameMessage;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingView
implements IBuildingView {
    private final IColonyView colony;
    @NotNull
    private final BlockPos location;
    private int buildingLevel = 0;
    private int buildingMaxLevel = 0;
    private int buildingDmPrio = 1;
    private int rotation;
    private boolean isBuildingMirrored;
    private int workOrderLevel = -1;
    private ImmutableCollection<IToken<?>> resolvers;
    private IToken<?> requesterId;
    @NotNull
    private IToken<?> rsDataStoreToken;
    private String schematicName;
    private String style;
    private String customName = "";
    private int claimRadius = 0;
    private List<BlockPos> containerlist = new ArrayList<BlockPos>();
    private List<Tuple<ItemStorage, Integer>> minimumStock = new ArrayList<Tuple<ItemStorage, Integer>>();
    private boolean reachedLimit = false;
    private boolean isDeconstructed;

    protected AbstractBuildingView(IColonyView c, @NotNull BlockPos l) {
        this.colony = c;
        this.location = new BlockPos((Vec3i)l);
    }

    @Override
    @NotNull
    public BlockPos getID() {
        return this.location;
    }

    @Override
    @NotNull
    public BlockPos getPosition() {
        return this.location;
    }

    @Override
    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public int getBuildingMaxLevel() {
        return this.buildingMaxLevel;
    }

    @Override
    public boolean isBuildingMaxLevel() {
        return this.buildingLevel >= this.buildingMaxLevel;
    }

    @Override
    public int getCurrentWorkOrderLevel() {
        return this.workOrderLevel;
    }

    @Override
    public String getSchematicName() {
        return this.schematicName;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isMirrored() {
        return this.isBuildingMirrored;
    }

    @Override
    public boolean hasWorkOrder() {
        return this.workOrderLevel != -1;
    }

    @Override
    public boolean isBuilding() {
        return this.workOrderLevel != 0 && this.workOrderLevel != -1 && this.workOrderLevel > this.buildingLevel;
    }

    @Override
    public boolean isRepairing() {
        return this.workOrderLevel != 0 && this.workOrderLevel != -1 && this.workOrderLevel == this.buildingLevel;
    }

    @Override
    public boolean isDeconstructing() {
        return this.workOrderLevel == 0;
    }

    @Override
    public int getClaimRadius() {
        return this.claimRadius;
    }

    @Override
    public List<BlockPos> getContainerList() {
        return new ArrayList<BlockPos>(this.containerlist);
    }

    @Override
    public void openGui(boolean shouldOpenInv) {
        if (shouldOpenInv) {
            Network.getNetwork().sendToServer(new OpenInventoryMessage(this));
        } else {
            Window window = this.getWindow();
            if (window != null) {
                window.open();
            }
        }
    }

    @Override
    @Nullable
    public Window getWindow() {
        return null;
    }

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        this.buildingLevel = buf.readInt();
        this.buildingMaxLevel = buf.readInt();
        this.buildingDmPrio = buf.readInt();
        this.workOrderLevel = buf.readInt();
        this.style = buf.func_150789_c(Short.MAX_VALUE);
        this.schematicName = buf.func_150789_c(Short.MAX_VALUE);
        this.customName = buf.func_150789_c(Short.MAX_VALUE);
        this.rotation = buf.readInt();
        this.isBuildingMirrored = buf.readBoolean();
        this.claimRadius = buf.readInt();
        ArrayList list = new ArrayList();
        int resolverSize = buf.readInt();
        for (int i = 0; i < resolverSize; ++i) {
            CompoundNBT compound = buf.func_150793_b();
            if (compound == null) continue;
            list.add(StandardFactoryController.getInstance().deserialize(compound));
        }
        this.resolvers = ImmutableList.copyOf(list);
        CompoundNBT compound = buf.func_150793_b();
        if (compound != null) {
            this.requesterId = (IToken)StandardFactoryController.getInstance().deserialize(compound);
        }
        this.containerlist.clear();
        int racks = buf.readInt();
        for (int i = 0; i < racks; ++i) {
            this.containerlist.add(buf.func_179259_c());
        }
        this.loadRequestSystemFromNBT(buf.func_150793_b());
        this.minimumStock.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.minimumStock.add(new Tuple<ItemStorage, Integer>(new ItemStorage(buf.func_150791_c()), buf.readInt()));
        }
        this.reachedLimit = buf.readBoolean();
        this.isDeconstructed = buf.readBoolean();
    }

    public List<Tuple<ItemStorage, Integer>> getStock() {
        return this.minimumStock;
    }

    public boolean hasReachedLimit() {
        return this.reachedLimit;
    }

    private void loadRequestSystemFromNBT(CompoundNBT compound) {
        this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    @Override
    public Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    protected Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(@NotNull ICitizenDataView citizenData, Class<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf((Type)requestType)).map(request -> request).iterator());
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequests(@NotNull ICitizenDataView data) {
        if (data == null || this.getColony() == null || this.getColony().getRequestManager() == null) {
            return ImmutableList.of();
        }
        if (!this.getOpenRequestsByCitizen().containsKey(data.getId())) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> list = this.getOpenRequestsByCitizen().get(data.getId());
        if (list == null || list.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(list.stream().filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public ImmutableList<IRequest<?>> getOpenRequestsOfBuilding() {
        return ImmutableList.copyOf(this.getOpenRequestsByCitizen().values().stream().flatMap(Collection::stream).filter(Objects::nonNull).map(this.getColony().getRequestManager()::getRequestForToken).filter(Objects::nonNull).iterator());
    }

    @Override
    public IColonyView getColony() {
        return this.colony;
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenDataView citizenData, Class<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf((Type)requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public IToken<?> getId() {
        return this.requesterId;
    }

    @Override
    @NotNull
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    @NotNull
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        Integer citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
        if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
            this.getOpenRequestsByCitizen().remove(citizenThatRequested);
        }
    }

    @Override
    @NotNull
    public ITextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        try {
            if (this.getColony() == null || !this.getCitizensByRequest().containsKey(request.getId()) || this.getColony().getCitizen(this.getCitizensByRequest().get(request.getId())) == null) {
                return new TranslationTextComponent(this.getCustomName().isEmpty() ? this.getSchematicName() : this.getCustomName(), new Object[0]);
            }
            return new StringTextComponent(this.getColony().getCitizen(this.getCitizensByRequest().get(request.getId())).getName());
        }
        catch (Exception ex) {
            Log.getLogger().warn((Object)ex);
            return new StringTextComponent("");
        }
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return null;
    }

    @Override
    public int getBuildingDmPrio() {
        return this.buildingDmPrio;
    }

    @Override
    public ImmutableCollection<IToken<?>> getResolverIds() {
        return this.resolvers;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
        Network.getNetwork().sendToServer(new HutRenameMessage(this, name));
    }

    @Override
    public boolean isDeconstructed() {
        return this.isDeconstructed;
    }
}

