/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingBedProvider;
import com.minecolonies.api.colony.buildings.IWorkerLivingBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingArchery
extends AbstractBuildingWorker
implements IBuildingBedProvider,
IWorkerLivingBuilding {
    private static final String SCHEMATIC_NAME = "archery";
    private static final String DESC = "archery";
    private final List<BlockPos> shootingStands = new ArrayList<BlockPos>();
    private final List<BlockPos> shootingTargets = new ArrayList<BlockPos>();
    @NotNull
    private final List<BlockPos> bedList = new ArrayList<BlockPos>();

    public BuildingArchery(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobArcherTraining(citizen);
    }

    @Override
    @NotNull
    public List<BlockPos> getBedList() {
        return new ArrayList<BlockPos>(this.bedList);
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding building = citizen.getHomeBuilding();
            if (building != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            return true;
        }
        return false;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block == Blocks.field_150407_cf && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof FenceBlock) {
            this.shootingTargets.add(pos);
        } else if (block == Blocks.field_150426_aN) {
            this.shootingStands.add(pos);
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Archery", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.shootingTargets.clear();
        this.shootingStands.clear();
        ListNBT targetList = compound.func_150295_c("archeryTargets", 10);
        this.shootingTargets.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListNBT standTagList = compound.func_150295_c("archeryStands", 10);
        this.shootingStands.addAll(NBTUtils.streamCompound(standTagList).map(targetCompound -> BlockPosUtil.read(targetCompound, "stand")).collect(Collectors.toList()));
        ListNBT bedTagList = compound.func_150295_c("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundNBT bedCompound = bedTagList.func_150305_b(i);
            BlockPos bedPos = NBTUtil.func_186861_c((CompoundNBT)bedCompound);
            if (this.bedList.contains(bedPos)) continue;
            this.bedList.add(bedPos);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT targetList = this.shootingTargets.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "target", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("archeryTargets", (INBT)targetList);
        ListNBT standTagList = this.shootingStands.stream().map(target -> BlockPosUtil.write(new CompoundNBT(), "stand", target)).collect(NBTUtils.toListNBT());
        compound.func_218657_a("archeryStands", (INBT)standTagList);
        if (!this.bedList.isEmpty()) {
            ListNBT bedTagList = new ListNBT();
            for (BlockPos pos : this.bedList) {
                bedTagList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            compound.func_218657_a("beds", (INBT)bedTagList);
        }
        return compound;
    }

    @Override
    public String getSchematicName() {
        return "archery";
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public String getJobName() {
        return "archer";
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Agility;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Adaptability;
    }

    @Override
    public int getMaxInhabitants() {
        return this.getBuildingLevel();
    }

    public BlockPos getRandomShootingStandPosition(Random random) {
        if (!this.shootingStands.isEmpty()) {
            return this.shootingStands.get(random.nextInt(this.shootingStands.size()));
        }
        return null;
    }

    public BlockPos getRandomShootingTarget(Random random) {
        if (!this.shootingTargets.isEmpty()) {
            return this.shootingTargets.get(random.nextInt(this.shootingTargets.size()));
        }
        return null;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.func_177230_c() instanceof BedBlock) {
            if (blockState.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.FOOT) {
                registrationPosition = registrationPosition.func_177972_a((Direction)blockState.func_177229_b((IProperty)BedBlock.field_185512_D));
            }
            if (!this.bedList.contains(registrationPosition)) {
                this.bedList.add(registrationPosition);
            }
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.archery;
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        World world = this.getColony().getWorld();
        if (world == null) {
            return;
        }
        for (BlockPos pos : this.bedList) {
            BlockState state = world.func_180495_p(pos);
            if (!((state = state.func_177230_c().getExtendedState(state, (IBlockReader)world, pos)).func_177230_c() instanceof BedBlock) || !((Boolean)state.func_177229_b((IProperty)BedBlock.field_176471_b)).booleanValue() || !((BedPart)state.func_177229_b((IProperty)BedBlock.field_176472_a)).equals((Object)BedPart.HEAD)) continue;
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BedBlock.field_176471_b, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, "archery");
        }

        @Override
        public boolean hasEnoughWorkers() {
            return this.getWorkerId().size() >= this.getBuildingLevel();
        }
    }
}

