/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutBeekeeper;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobBeekeeper;
import com.minecolonies.coremod.network.messages.server.colony.building.beekeeper.BeekeeperSetHarvestHoneycombsMessage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingBeekeeper
extends AbstractBuildingWorker {
    private static final String BEEKEEPER = "beekeeper";
    private Set<BlockPos> hives = new HashSet<BlockPos>();
    private boolean harvestHoneycombs = true;

    public BuildingBeekeeper(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> Items.field_151097_aZ == stack.func_77973_b(), new Tuple((Object)1, (Object)true));
        this.keepX.put(stack -> Items.field_151069_bo == stack.func_77973_b(), new Tuple((Object)4, (Object)true));
    }

    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobBeekeeper(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BEEKEEPER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Dexterity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Adaptability;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.beekeeper;
    }

    @Override
    public String getSchematicName() {
        return BEEKEEPER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        NBTUtils.streamCompound(compound.func_150295_c("hives", 10)).map(NBTUtil::func_186861_c).forEach(this.hives::add);
        this.harvestHoneycombs = compound.func_74767_n("harvest_honeycombs");
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = super.serializeNBT();
        nbt.func_218657_a("hives", (INBT)this.hives.stream().map(NBTUtil::func_186859_a).collect(NBTUtils.toListNBT()));
        nbt.func_74757_a("harvest_honeycombs", this.harvestHoneycombs);
        return nbt;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.harvestHoneycombs);
    }

    public Set<BlockPos> getHives() {
        return Collections.unmodifiableSet(this.hives);
    }

    public void removeHive(BlockPos pos) {
        this.hives.remove(pos);
    }

    public void addHive(BlockPos pos) {
        this.hives.add(pos);
    }

    public void setHives(Set<BlockPos> hives) {
        this.hives = hives;
    }

    public void setHarvestHoneycombs(boolean harvestHoneycombs) {
        this.harvestHoneycombs = harvestHoneycombs;
    }

    public boolean shouldHarvestHoneycombs() {
        return this.harvestHoneycombs;
    }

    public int getMaximumHives() {
        return (int)Math.pow(2.0, this.getBuildingLevel() - 1);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean harvestHoneycombs = true;

        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @Nullable
        public Window getWindow() {
            return new WindowHutBeekeeper(this);
        }

        public boolean isHarvestHoneycombs() {
            return this.harvestHoneycombs;
        }

        public void setHarvestHoneycombs(boolean harvestHoneycombs) {
            Network.getNetwork().sendToServer(new BeekeeperSetHarvestHoneycombsMessage(this, harvestHoneycombs));
            this.harvestHoneycombs = harvestHoneycombs;
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.harvestHoneycombs = buf.readBoolean();
        }
    }
}

