/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.client.gui.WindowHutBuilder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.jobs.JobBuilder;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.ChestBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilder
extends AbstractBuildingStructureBuilder {
    private static final String BUILDER = "builder";
    private static final String TAG_PURGE_MOBS = "purgedMobs";
    private boolean purgedMobsToday = false;

    public BuildingBuilder(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.builder;
    }

    @Override
    public void onWakeUp() {
        this.purgedMobsToday = false;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof ChestBlock || block instanceof BlockMinecoloniesRack) {
            this.addContainerPosition(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.purgedMobsToday = compound.func_74767_n(TAG_PURGE_MOBS);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a(TAG_PURGE_MOBS, this.purgedMobsToday);
        return compound;
    }

    public void setPurgedMobsToday(boolean purgedMobsToday) {
        this.purgedMobsToday = purgedMobsToday;
    }

    public boolean hasPurgedMobsToday() {
        return this.purgedMobsToday;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobBuilder(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return BUILDER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Adaptability;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Athletics;
    }

    @Override
    public void searchWorkOrder() {
        ICitizenData citizen = this.getMainCitizen();
        if (citizen == null) {
            return;
        }
        ArrayList<WorkOrderBuildDecoration> list = new ArrayList<WorkOrderBuildDecoration>();
        list.addAll(this.getColony().getWorkManager().getOrderedList(WorkOrderBuildRemoval.class, this.getPosition()));
        list.addAll(this.getColony().getWorkManager().getOrderedList(WorkOrderBuildDecoration.class, this.getPosition()));
        list.removeIf(order -> order instanceof WorkOrderBuildMiner);
        WorkOrderBuildDecoration order2 = list.stream().filter(w -> w.getClaimedBy() != null && w.getClaimedBy().equals((Object)this.getPosition())).findFirst().orElse(null);
        if (order2 != null) {
            citizen.getJob(JobBuilder.class).setWorkOrder(order2);
            order2.setClaimedBy(citizen);
            return;
        }
        for (WorkOrderBuildDecoration wo : list) {
            double distanceToBuilder = Double.MAX_VALUE;
            if (wo instanceof WorkOrderBuild && !(wo instanceof WorkOrderBuildRemoval) && !((WorkOrderBuild)wo).canBuild(citizen)) continue;
            for (ICitizenData otherBuilder : this.getColony().getCitizenManager().getCitizens()) {
                double distance;
                JobBuilder job = otherBuilder.getJob(JobBuilder.class);
                if (job == null || otherBuilder.getWorkBuilding() == null || citizen.getId() == otherBuilder.getId() || job.hasWorkOrder() || !(wo instanceof WorkOrderBuild) || !((WorkOrderBuild)wo).canBuild(otherBuilder) || !((distance = otherBuilder.getWorkBuilding().getID().func_177951_i((Vec3i)wo.getBuildingLocation())) < distanceToBuilder)) continue;
                distanceToBuilder = distance;
            }
            if (!(citizen.getWorkBuilding().getID().func_177951_i((Vec3i)wo.getBuildingLocation()) < distanceToBuilder)) continue;
            citizen.getJob(JobBuilder.class).setWorkOrder(wo);
            wo.setClaimedBy(citizen);
            return;
        }
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return this.getBuildingLevel() + 1 == newLevel;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (this.requiresResourceForBuilding(stack)) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingBuilderView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutBuilder(this);
        }
    }
}

