/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.WindowHutDyer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.jobs.JobDyer;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BuildingDyer
extends AbstractBuildingSmelterCrafter {
    private static final String DYER = "dyer";

    public BuildingDyer(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return DYER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobDyer(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return DYER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Creativity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags(token);
        return isRecipeAllowed.orElse(false);
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBoolean(BuildingDyer.this.canCraftComplexRecipes());
                buffer.func_179255_a(BuildingDyer.this.getID());
                return new ContainerCrafting(id, inv, buffer);
            }
        }, buffer -> new PacketBuffer(buffer.writeBoolean(this.canCraftComplexRecipes())).func_179255_a(this.getID()));
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.dyer;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Dyer", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    @Override
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        IRecipeStorage recipe = super.getFirstRecipe(stackPredicate);
        if (recipe == null && stackPredicate.test(new ItemStack((IItemProvider)Items.field_221603_aE))) {
            HashMap<ItemStorage, Integer> inventoryCounts = new HashMap<ItemStorage, Integer>();
            if (!this.colony.getBuildingManager().hasWarehouse()) {
                return null;
            }
            List woolItems = ItemTags.field_199904_a.func_199885_a().stream().filter(item -> !item.equals(Items.field_221603_aE)).map(i -> new ItemStorage(new ItemStack((IItemProvider)i))).collect(Collectors.toList());
            for (ItemStorage color : woolItems) {
                for (IBuilding iBuilding : this.colony.getBuildingManager().getWareHouses()) {
                    int colorCount = InventoryUtils.getCountFromBuilding(iBuilding, color);
                    inventoryCounts.put(color, inventoryCounts.getOrDefault(color, 0) + colorCount);
                }
            }
            ItemStorage woolToUse = (ItemStorage)inventoryCounts.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
            recipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{ImmutableList.of((Object)woolToUse.getItemStack(), (Object)new ItemStack((IItemProvider)Items.field_222069_lA, 1)), 1, new ItemStack((IItemProvider)Items.field_221603_aE, 1), Blocks.field_150350_a});
        }
        return recipe;
    }

    @Override
    public IRecipeStorage getFirstFullFillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
        IRecipeStorage storage;
        IRecipeStorage recipe = super.getFirstFullFillableRecipe(stackPredicate, count, considerReservation);
        if (recipe == null && (storage = this.getFirstRecipe(stackPredicate)) != null && stackPredicate.test(storage.getPrimaryOutput())) {
            List<IItemHandler> handlers = this.getHandlers();
            if (storage.canFullFillRecipe(count, Collections.emptyMap(), handlers.toArray(new IItemHandler[0]))) {
                return storage;
            }
        }
        return recipe;
    }

    public static class View
    extends AbstractBuildingSmelterCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutDyer(this);
        }
    }
}

