/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutFarmer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignFieldMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.AssignmentModeMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.farmer.RequestFertilizerMessage;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingFarmer
extends AbstractBuildingCrafter {
    private static final String FARMER = "farmer";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_FIELDS = "fields";
    private static final String TAG_FIELDS_BLOCKPOS = "fieldsPos";
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private static final String TAG_REQUEST_FERTILIZER = "requestFert";
    private static final int BLOCK_UPDATE_FLAG = 3;
    private static final String LAST_FIELD_TAG = "lastField";
    private static final int SEEDS_TO_KEEP = 64;
    private final Set<BlockPos> farmerFields = new HashSet<BlockPos>();
    @Nullable
    private BlockPos currentField;
    @Nullable
    private BlockPos lastField;
    private boolean shouldAssignManually = false;
    private boolean shouldRequestFertilizer = true;

    public BuildingFarmer(IColony c, BlockPos l) {
        super(c, l);
        ItemStack stackSeed = new ItemStack((IItemProvider)Items.field_151014_N);
        ItemStack stackCarrot = new ItemStack((IItemProvider)Items.field_151172_bF);
        ItemStack stackPotatoe = new ItemStack((IItemProvider)Items.field_151174_bG);
        ItemStack stackReed = new ItemStack((IItemProvider)Items.field_185163_cU);
        this.keepX.put(arg_0 -> ((ItemStack)stackSeed).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackCarrot).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackPotatoe).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackReed).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.HOE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @NotNull
    public List<BlockPos> getFarmerFields() {
        return new ArrayList<BlockPos>(this.farmerFields);
    }

    public boolean hasNoFields() {
        return this.farmerFields.isEmpty();
    }

    public void addFarmerFields(BlockPos field) {
        TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
        if (scareCrow instanceof ScarecrowTileEntity) {
            this.farmerFields.add(field);
            this.markDirty();
        }
    }

    @Nullable
    public BlockPos getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(@Nullable BlockPos currentField) {
        this.currentField = currentField;
    }

    @Nullable
    public BlockPos getFieldToWorkOn(World world) {
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>(this.farmerFields);
        Collections.shuffle(fields);
        if (!fields.isEmpty()) {
            if (((BlockPos)fields.get(0)).equals((Object)this.lastField)) {
                Collections.shuffle(fields);
            }
            this.lastField = (BlockPos)fields.get(0);
        }
        for (BlockPos field : fields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity) || !((ScarecrowTileEntity)scareCrow).needsWork()) continue;
            this.currentField = field;
            return field;
        }
        return null;
    }

    @Override
    @NotNull
    public IJob<?> createJob(@NotNull ICitizenData citizen) {
        if (!this.farmerFields.isEmpty()) {
            for (BlockPos field : this.farmerFields) {
                TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
                if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
                ((ScarecrowTileEntity)scareCrow).setOwner(citizen.getId());
            }
        }
        return new JobFarmer(citizen);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT fieldTagList = compound.func_150295_c(TAG_FIELDS, 10);
        for (int i = 0; i < fieldTagList.size(); ++i) {
            CompoundNBT fieldCompound = fieldTagList.func_150305_b(i);
            BlockPos fieldLocation = BlockPosUtil.read(fieldCompound, TAG_FIELDS_BLOCKPOS);
            this.farmerFields.add(fieldLocation);
        }
        this.shouldAssignManually = compound.func_74767_n(TAG_ASSIGN_MANUALLY);
        if (compound.func_150296_c().contains(TAG_REQUEST_FERTILIZER)) {
            this.shouldRequestFertilizer = compound.func_74767_n(TAG_REQUEST_FERTILIZER);
        }
        if (compound.func_150296_c().contains(LAST_FIELD_TAG)) {
            BlockPos pos;
            this.lastField = pos = BlockPosUtil.read(compound, LAST_FIELD_TAG);
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT fieldTagList = new ListNBT();
        for (BlockPos f : this.farmerFields) {
            CompoundNBT fieldCompound = new CompoundNBT();
            BlockPosUtil.write(fieldCompound, TAG_FIELDS_BLOCKPOS, f);
            fieldTagList.add((Object)fieldCompound);
        }
        compound.func_218657_a(TAG_FIELDS, (INBT)fieldTagList);
        compound.func_74757_a(TAG_ASSIGN_MANUALLY, this.shouldAssignManually);
        compound.func_74757_a(TAG_REQUEST_FERTILIZER, this.shouldRequestFertilizer);
        if (this.lastField != null) {
            BlockPosUtil.write(compound, LAST_FIELD_TAG, this.lastField);
        }
        return compound;
    }

    @Override
    public void onDestroyed() {
        super.onDestroyed();
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            ((ScarecrowTileEntity)scareCrow).setTaken(false);
            ((ScarecrowTileEntity)scareCrow).setOwner(0);
            this.getColony().getWorld().func_184138_a(scareCrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scareCrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scareCrow.func_174877_v()), 3);
        }
    }

    @Override
    @NotNull
    public String getJobName() {
        return FARMER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Stamina;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Athletics;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        return isRecipeAllowed.orElse(false);
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity) || ItemStackUtils.isEmpty(((ScarecrowTileEntity)scareCrow).getSeed()).booleanValue()) continue;
            ItemStack seedStack = ((ScarecrowTileEntity)scareCrow).getSeed();
            toKeep.put(arg_0 -> ((ItemStack)seedStack).func_77969_a(arg_0), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
        }
        return toKeep;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.farmer;
    }

    @Override
    public void onWakeUp() {
        this.resetFields();
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return FARMER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.shouldAssignManually);
        buf.writeBoolean(this.shouldRequestFertilizer);
        int size = 0;
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>(this.getColony().getBuildingManager().getFields());
        ArrayList<BlockPos> cleanList = new ArrayList<BlockPos>();
        for (BlockPos field : fields) {
            TileEntity scareCrow;
            if (!this.colony.getWorld().isAreaLoaded(field, 1) || !((scareCrow = this.getColony().getWorld().func_175625_s(field)) instanceof ScarecrowTileEntity)) continue;
            if (((ScarecrowTileEntity)scareCrow).isTaken()) {
                if (!this.getAssignedCitizen().isEmpty() && ((ScarecrowTileEntity)scareCrow).getOwnerId() != this.getMainCitizen().getId()) continue;
                cleanList.add(field);
                ++size;
                continue;
            }
            ++size;
            cleanList.add(field);
        }
        buf.writeInt(size);
        for (BlockPos field : cleanList) {
            buf.func_179255_a(field);
        }
        for (BlockPos pos : this.farmerFields) {
            if (cleanList.contains(pos)) continue;
            Log.getLogger().warn("Owning field not considered because not loaded: " + pos.toString());
        }
        buf.writeInt(this.farmerFields.size());
    }

    public void resetFields() {
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            ((ScarecrowTileEntity)scareCrow).setNeedsWork(true);
        }
    }

    public void syncWithColony(@NotNull World world) {
        if (!this.farmerFields.isEmpty()) {
            ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.farmerFields);
            for (BlockPos field : tempFields) {
                TileEntity scarecrow = world.func_175625_s(field);
                if (scarecrow instanceof ScarecrowTileEntity) {
                    this.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
                    ((ScarecrowTileEntity)scarecrow).setTaken(true);
                    ((ScarecrowTileEntity)scarecrow).setOwner(this.getMainCitizen() != null ? this.getMainCitizen().getId() : 0);
                    ((ScarecrowTileEntity)scarecrow).setColony(this.colony);
                    continue;
                }
                this.farmerFields.remove(field);
                if (this.currentField == null || !this.currentField.equals((Object)field)) continue;
                this.currentField = null;
            }
        }
    }

    public boolean assignManually() {
        return this.shouldAssignManually;
    }

    public void freeField(BlockPos position) {
        TileEntity scarecrow = this.getColony().getWorld().func_175625_s(position);
        if (scarecrow instanceof ScarecrowTileEntity) {
            this.farmerFields.remove(position);
            ((ScarecrowTileEntity)scarecrow).setTaken(false);
            ((ScarecrowTileEntity)scarecrow).setOwner(0);
            this.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
        }
    }

    public void assignField(BlockPos position) {
        TileEntity scarecrow = this.getColony().getWorld().func_175625_s(position);
        if (scarecrow instanceof ScarecrowTileEntity) {
            ((ScarecrowTileEntity)scarecrow).setTaken(true);
            if (this.getMainCitizen() != null) {
                ((ScarecrowTileEntity)scarecrow).setOwner(this.getMainCitizen().getId());
            }
            this.farmerFields.add(position);
        }
    }

    public void setAssignManually(boolean assignManually) {
        this.shouldAssignManually = assignManually;
    }

    public boolean requestFertilizer() {
        return this.shouldRequestFertilizer;
    }

    public void setRequestFertilizer(boolean shouldRequestFertilizer) {
        this.shouldRequestFertilizer = shouldRequestFertilizer;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151015_O) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private boolean shouldAssignFieldManually;
        private boolean shouldRequestFertilizer;
        @NotNull
        private List<BlockPos> fields = new ArrayList<BlockPos>();
        private int amountOfFields;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutFarmer(this);
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            this.fields = new ArrayList<BlockPos>();
            super.deserialize(buf);
            this.shouldAssignFieldManually = buf.readBoolean();
            this.shouldRequestFertilizer = buf.readBoolean();
            int size = buf.readInt();
            for (int i = 1; i <= size; ++i) {
                BlockPos pos = buf.func_179259_c();
                this.fields.add(pos);
            }
            this.amountOfFields = buf.readInt();
        }

        public boolean assignFieldManually() {
            return this.shouldAssignFieldManually;
        }

        public boolean requestFertilizer() {
            return this.shouldRequestFertilizer;
        }

        @NotNull
        public List<BlockPos> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public int getAmountOfFields() {
            return this.amountOfFields;
        }

        public void setAssignFieldManually(boolean assignFieldManually) {
            Network.getNetwork().sendToServer(new AssignmentModeMessage(this, assignFieldManually));
            this.shouldAssignFieldManually = assignFieldManually;
        }

        public void setRequestFertilizer(boolean shouldRequestFertilizer) {
            Network.getNetwork().sendToServer(new RequestFertilizerMessage(this, shouldRequestFertilizer));
            this.shouldRequestFertilizer = shouldRequestFertilizer;
        }

        public void changeFields(BlockPos id, boolean addNewField, ScarecrowTileEntity scarecrowTileEntity) {
            Network.getNetwork().sendToServer(new AssignFieldMessage(this, addNewField, id));
            scarecrowTileEntity.setTaken(addNewField);
            if (addNewField && !this.getWorkerId().isEmpty()) {
                scarecrowTileEntity.setOwner(this.getWorkerId().get(0), this.getColony());
                ++this.amountOfFields;
            } else {
                scarecrowTileEntity.setOwner(0, this.getColony());
                --this.amountOfFields;
            }
        }
    }
}

