/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.client.gui.WindowHutGlassblower;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingSmelterCrafter;
import com.minecolonies.coremod.colony.jobs.JobGlassblower;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import com.minecolonies.coremod.util.FurnaceRecipes;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class BuildingGlassblower
extends AbstractBuildingSmelterCrafter {
    private static final String GLASS_BLOWER = "glassblower";

    public BuildingGlassblower(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> this.isAllowedFuel((ItemStack)stack), new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return GLASS_BLOWER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobGlassblower(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return GLASS_BLOWER;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Creativity;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Focus;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        this.checkForWorkerSpecificRecipes();
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags(token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        return false;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
    }

    @Override
    public void checkForWorkerSpecificRecipes() {
        ArrayList tokens = new ArrayList();
        for (Item item : Tags.Items.SAND.func_199885_a()) {
            ItemStack stack = new ItemStack((IItemProvider)item);
            ItemStack output = FurnaceRecipes.getInstance().getSmeltingResult(stack);
            if (!Tags.Items.GLASS.func_199685_a_((Object)output.func_77973_b())) continue;
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            list.add(stack);
            IRecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{list, 1, output, Blocks.field_150460_al});
            IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(storage);
            if (this.recipes.contains(token)) {
                return;
            }
            tokens.add(token);
        }
        this.recipes.addAll(tokens);
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public void openCraftingContainer(ServerPlayerEntity player) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Crafting GUI");
            }

            @NotNull
            public Container createMenu(int id, @NotNull PlayerInventory inv, @NotNull PlayerEntity player) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                buffer.writeBoolean(BuildingGlassblower.this.canCraftComplexRecipes());
                buffer.func_179255_a(BuildingGlassblower.this.getID());
                return new ContainerCrafting(id, inv, buffer);
            }
        }, buffer -> new PacketBuffer(buffer.writeBoolean(this.canCraftComplexRecipes())).func_179255_a(this.getID()));
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.glassblower;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        super.requestUpgrade(player, builder);
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Glassblower", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingSmelterCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutGlassblower(this);
        }
    }
}

