/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowHutPlantation;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobPlanter;
import com.minecolonies.coremod.network.messages.server.colony.building.plantation.PlantationSetPhaseMessage;
import com.minecolonies.coremod.research.UnlockAbilityResearchEffect;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class BuildingPlantation
extends AbstractBuildingCrafter {
    private static final String PLANTATION = "plantation";
    private List<BlockPos> sand = new ArrayList<BlockPos>();
    private Item currentPhase = Items.field_222065_kN;
    private Item setting = Items.field_222065_kN;
    private final List<Item> settings = Arrays.asList(Items.field_222065_kN, Items.field_221774_cw, Items.field_222068_kQ);

    public BuildingPlantation(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return PLANTATION;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        Block down;
        super.registerBlockPosition(block, pos, world);
        if (block == Blocks.field_150354_m && ((down = world.func_180495_p(pos.func_177977_b()).func_177230_c()) == Blocks.field_150347_e || down == Blocks.field_196696_di)) {
            this.sand.add(pos);
        }
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT sandPos = compound.func_150295_c("plantGround", 10);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.sand.add(NBTUtil.func_186861_c((CompoundNBT)sandPos.func_150305_b(i).func_74775_l("pos")));
        }
        this.currentPhase = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("currentPhase")).func_77973_b();
        this.setting = compound.func_150296_c().contains("setting") ? ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("setting")).func_77973_b() : this.currentPhase;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT sandCompoundList = new ListNBT();
        for (BlockPos entry : this.sand) {
            CompoundNBT sandCompound = new CompoundNBT();
            sandCompound.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)entry));
            sandCompoundList.add((Object)sandCompound);
        }
        compound.func_218657_a("plantGround", (INBT)sandCompoundList);
        compound.func_218657_a("currentPhase", (INBT)new ItemStack((IItemProvider)this.currentPhase).func_77955_b(new CompoundNBT()));
        compound.func_218657_a("setting", (INBT)new ItemStack((IItemProvider)this.setting).func_77955_b(new CompoundNBT()));
        return compound;
    }

    public List<BlockPos> getPosForPhase(World world) {
        ArrayList<BlockPos> filtered = new ArrayList<BlockPos>();
        if (this.tileEntity != null && !this.tileEntity.getPositionedTags().isEmpty()) {
            for (Map.Entry entry : this.tileEntity.getPositionedTags().entrySet()) {
                if (!(((List)entry.getValue()).contains("bamboo") && this.currentPhase == Items.field_222068_kQ || ((List)entry.getValue()).contains("sugar") && this.currentPhase == Items.field_222065_kN) && (!((List)entry.getValue()).contains("cactus") || this.currentPhase != Items.field_221774_cw)) continue;
                filtered.add(this.getPosition().func_177971_a((Vec3i)entry.getKey()));
            }
        }
        if (filtered.isEmpty()) {
            for (BlockPos blockPos : this.sand) {
                if (this.currentPhase == Items.field_222065_kN) {
                    if (world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150347_e || world.func_180495_p(blockPos.func_177978_c()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(blockPos.func_177968_d()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(blockPos.func_177974_f()).func_177230_c() != Blocks.field_150355_j && world.func_180495_p(blockPos.func_177976_e()).func_177230_c() != Blocks.field_150355_j) continue;
                    filtered.add(blockPos);
                    continue;
                }
                if (this.currentPhase == Items.field_221774_cw) {
                    if (world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_150347_e || world.func_180495_p(blockPos.func_177978_c()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos.func_177968_d()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos.func_177974_f()).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(blockPos.func_177976_e()).func_177230_c() == Blocks.field_150355_j) continue;
                    filtered.add(blockPos);
                    continue;
                }
                if (world.func_180495_p(blockPos.func_177977_b()).func_177230_c() != Blocks.field_196696_di) continue;
                filtered.add(blockPos);
            }
        }
        return filtered;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobPlanter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return PLANTATION;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Agility;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage iRecipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        return false;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.plantation;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Plantation", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public void setSetting(Item phase) {
        this.setting = phase;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.func_150788_a(new ItemStack((IItemProvider)this.setting));
    }

    public Item getCurrentPhase() {
        UnlockAbilityResearchEffect researchEffect = this.getColony().getResearchManager().getResearchEffects().getEffect("Plant 2", UnlockAbilityResearchEffect.class);
        if (researchEffect != null && researchEffect.getEffect().booleanValue()) {
            if (this.currentPhase == this.setting) {
                this.nextPhase();
            }
        } else {
            this.currentPhase = this.setting;
        }
        return this.currentPhase;
    }

    public void nextPhase() {
        int nextIndex = this.settings.indexOf(this.currentPhase) + 1;
        if (nextIndex >= this.settings.size()) {
            nextIndex = 0;
        }
        if (this.settings.get(nextIndex) == this.setting && ++nextIndex >= this.settings.size()) {
            nextIndex = 0;
        }
        this.currentPhase = this.settings.get(nextIndex);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        private final List<Item> phases = Arrays.asList(Items.field_222065_kN, Items.field_221774_cw, Items.field_222068_kQ);
        private Item currentPhase;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        public List<Item> getPhases() {
            return this.phases;
        }

        @Override
        public void deserialize(@NotNull PacketBuffer buf) {
            super.deserialize(buf);
            this.currentPhase = buf.func_150791_c().func_77973_b();
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutPlantation(this);
        }

        public Item getCurrentPhase() {
            return this.currentPhase;
        }

        public void setPhase(Item phase) {
            this.currentPhase = phase;
            Network.getNetwork().sendToServer(new PlantationSetPhaseMessage(this, phase));
        }
    }
}

