/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.client.gui.WindowHutCrafter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingCrafter;
import com.minecolonies.coremod.colony.jobs.JobSawmill;
import com.minecolonies.coremod.research.UnlockBuildingResearchEffect;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class BuildingSawmill
extends AbstractBuildingCrafter {
    private static final String SAWMILL = "sawmill";
    private static final double MIN_PERCENTAGE_TO_CRAFT = 0.75;

    public BuildingSawmill(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SAWMILL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob<?> createJob(ICitizenData citizen) {
        return new JobSawmill(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return SAWMILL;
    }

    @Override
    @NotNull
    public Skill getPrimarySkill() {
        return Skill.Knowledge;
    }

    @Override
    @NotNull
    public Skill getSecondarySkill() {
        return Skill.Dexterity;
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        if (!super.canRecipeBeAdded(token)) {
            return false;
        }
        Optional<Boolean> isRecipeAllowed = super.canRecipeBeAddedBasedOnTags((IToken)token);
        if (isRecipeAllowed.isPresent()) {
            return isRecipeAllowed.get();
        }
        IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        double amountOfValidBlocks = 0.0;
        double blocks = 0.0;
        for (ItemStack stack : storage.getInput()) {
            if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
            if (stack.func_77973_b().func_206844_a(ItemTags.field_199905_b) || stack.func_77973_b().func_206844_a(ItemTags.field_200038_h)) {
                amountOfValidBlocks += 1.0;
                continue;
            }
            for (ResourceLocation tag : stack.func_77973_b().getTags()) {
                if (!tag.func_110623_a().contains("wood")) continue;
                amountOfValidBlocks += 1.0;
                break;
            }
            blocks += 1.0;
        }
        return amountOfValidBlocks > 0.0 && amountOfValidBlocks / blocks > 0.75;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.sawmill;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        UnlockBuildingResearchEffect effect = this.colony.getResearchManager().getResearchEffects().getEffect("Sawmill", UnlockBuildingResearchEffect.class);
        if (effect == null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock", new Object[0]));
            return;
        }
        super.requestUpgrade(player, builder);
    }

    public static class View
    extends AbstractBuildingCrafter.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCrafter(this, BuildingSawmill.SAWMILL);
        }
    }
}

